/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.HashMap;
import java.util.List;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.HashAttribute;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHashAttribute {
    @Test
    public void test() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new HashAttribute());
        runner.setProperty(HashAttribute.HASH_VALUE_ATTRIBUTE.getName(), "hashValue");
        runner.setProperty("MDKey1", ".*");
        runner.setProperty("MDKey2", "(.).*");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("MDKey1", "a");
        attributeMap.put("MDKey2", "b");
        runner.enqueue(new byte[0], attributeMap);
        attributeMap.put("MDKey1", "1");
        attributeMap.put("MDKey2", "2");
        runner.enqueue(new byte[0], attributeMap);
        attributeMap.put("MDKey1", "a");
        attributeMap.put("MDKey2", "z");
        runner.enqueue(new byte[0], attributeMap);
        attributeMap.put("MDKey1", "a");
        attributeMap.put("MDKey2", "bad");
        runner.enqueue(new byte[0], attributeMap);
        attributeMap.put("MDKey1", "a");
        attributeMap.remove("MDKey2");
        runner.enqueue(new byte[0], attributeMap);
        runner.run(5);
        runner.assertTransferCount(HashAttribute.REL_FAILURE, 1);
        runner.assertTransferCount(HashAttribute.REL_SUCCESS, 4);
        List success = runner.getFlowFilesForRelationship(HashAttribute.REL_SUCCESS);
        HashMap<String, Integer> correlationCount = new HashMap<String, Integer>();
        for (MockFlowFile flowFile : success) {
            String correlationId = flowFile.getAttribute("hashValue");
            Assertions.assertNotNull((Object)correlationId);
            Integer cur = (Integer)correlationCount.get(correlationId);
            if (cur == null) {
                cur = 0;
            }
            correlationCount.put(correlationId, cur + 1);
        }
        int twoCount = 0;
        int oneCount = 0;
        for (Integer i : correlationCount.values()) {
            if (i == 1) {
                ++oneCount;
                continue;
            }
            if (i == 2) {
                ++twoCount;
                continue;
            }
            Assertions.fail((String)("Got count of " + i));
        }
        Assertions.assertEquals((int)1, (int)twoCount);
        Assertions.assertEquals((int)2, (int)oneCount);
    }
}

