/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.standard.ExecuteStreamCommand;
import org.apache.nifi.processors.standard.util.ArgumentUtils;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS}, disabledReason="Test only runs on *nix")
public class TestExecuteStreamCommand {
    @Test
    public void testDynamicPropertyArgumentsStrategyValid() {
        TestRunner runner = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        runner.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        runner.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        runner.setProperty("command.argument.1", "-version");
        runner.assertValid();
        List warnMessages = runner.getLogger().getWarnMessages();
        Assertions.assertTrue((boolean)warnMessages.isEmpty(), (String)"Warning Log Messages found");
    }

    @Test
    public void testCommandArgumentsPropertyStrategyValid() {
        TestRunner runner = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        runner.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.COMMAND_ARGUMENTS_PROPERTY_STRATEGY.getValue());
        runner.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        runner.setProperty("RUNTIME_VERSION", "version-1");
        runner.assertValid();
        List warnMessages = runner.getLogger().getWarnMessages();
        Assertions.assertTrue((boolean)warnMessages.isEmpty(), (String)"Warning Log Messages found");
    }

    @Test
    public void testExecuteJar() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestSuccess.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setProperty(ExecuteStreamCommand.MIME_TYPE.getName(), "text/plain");
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        byte[] byteArray = outputFlowFile.toByteArray();
        String result = new String(byteArray);
        Assertions.assertTrue((boolean)Pattern.compile("Test was a success\r?\n").matcher(result).find());
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar;", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 5));
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "TestSuccess.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
        outputFlowFile.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "text/plain");
        MockFlowFile originalFlowFile = (MockFlowFile)controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP).get(0);
        Assertions.assertEquals((Object)outputFlowFile.getAttribute("execution.status"), (Object)originalFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)outputFlowFile.getAttribute("execution.command"), (Object)originalFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)outputFlowFile.getAttribute("execution.command.args"), (Object)originalFlowFile.getAttribute("execution.command.args"));
    }

    @Test
    public void testExecuteJarDynamicPropArgs() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestSuccess.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        byte[] byteArray = outputFlowFile.toByteArray();
        String result = new String(byteArray);
        Assertions.assertTrue((boolean)Pattern.compile("Test was a success\r?\n").matcher(result).find());
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 4).trim());
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "TestSuccess.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
        MockFlowFile originalFlowFile = (MockFlowFile)controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP).get(0);
        Assertions.assertEquals((Object)outputFlowFile.getAttribute("execution.status"), (Object)originalFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)outputFlowFile.getAttribute("execution.command"), (Object)originalFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)outputFlowFile.getAttribute("execution.command.args"), (Object)originalFlowFile.getAttribute("execution.command.args"));
    }

    @Test
    public void testExecuteJarWithBadPath() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/noSuchFile.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP);
        MockFlowFile flowFile = (MockFlowFile)flowFiles.get(0);
        Assertions.assertEquals((long)0L, (long)flowFile.getSize());
        Assertions.assertTrue((boolean)flowFile.getAttribute("execution.error").contains("Error: Unable to access jarfile"));
        Assertions.assertTrue((boolean)flowFile.isPenalized());
    }

    @Test
    public void testExecuteJarWithBadPathDynamicProperties() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/noSuchFile.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP);
        MockFlowFile flowFile = (MockFlowFile)flowFiles.get(0);
        Assertions.assertEquals((long)0L, (long)flowFile.getSize());
        Assertions.assertTrue((boolean)flowFile.getAttribute("execution.error").contains("Error: Unable to access jarfile"));
        Assertions.assertTrue((boolean)flowFile.isPenalized());
    }

    @Test
    public void testExecuteIngestAndUpdate() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        File dummy10MBytes = new File("target/10MB.txt");
        try (FileOutputStream fos = new FileOutputStream(dummy10MBytes);){
            byte[] bytes = Files.readAllBytes(dummy.toPath());
            Assertions.assertEquals((int)1000, (int)bytes.length);
            for (int i = 0; i < 10000; ++i) {
                fos.write(bytes, 0, 1000);
            }
        }
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy10MBytes.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        Assertions.assertTrue((boolean)Pattern.compile("nifi-standard-processors:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testExecuteIngestAndUpdateDynamicProperties() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        File dummy10MBytes = new File("target/10MB.txt");
        try (FileOutputStream fos = new FileOutputStream(dummy10MBytes);){
            byte[] bytes = Files.readAllBytes(dummy.toPath());
            Assertions.assertEquals((int)1000, (int)bytes.length);
            for (int i = 0; i < 10000; ++i) {
                fos.write(bytes, 0, 1000);
            }
        }
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy10MBytes.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        Assertions.assertTrue((boolean)Pattern.compile("nifi-standard-processors:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testLoggingToStdErr() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestLogStdErr.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1mb.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setValidateExpressionUsage(false);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        MockFlowFile flowFile = (MockFlowFile)flowFiles.get(0);
        Assertions.assertEquals((long)0L, (long)flowFile.getSize());
        Assertions.assertTrue((boolean)flowFile.getAttribute("execution.error").contains("\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df"));
        Assertions.assertTrue((boolean)flowFile.getAttribute("execution.error").contains("fffffffffffffffffffffffffffffff"));
    }

    @Test
    public void testLoggingToStdErrDynamicProperties() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestLogStdErr.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1mb.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setValidateExpressionUsage(false);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        MockFlowFile flowFile = (MockFlowFile)flowFiles.get(0);
        Assertions.assertEquals((long)0L, (long)flowFile.getSize());
        Assertions.assertTrue((boolean)flowFile.getAttribute("execution.error").contains("\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df"));
        Assertions.assertTrue((boolean)flowFile.getAttribute("execution.error").contains("fffffffffffffffffffffffffffffff"));
    }

    @Test
    public void testExecuteIngestAndUpdateWithWorkingDir() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        String quotedSeparator = Pattern.quote(File.separator);
        Assertions.assertTrue((boolean)Pattern.compile(quotedSeparator + "nifi-standard-processors" + quotedSeparator + "target:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testExecuteIngestAndUpdateWithWorkingDirDynamicProperties() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        String quotedSeparator = Pattern.quote(File.separator);
        Assertions.assertTrue((boolean)Pattern.compile(quotedSeparator + "nifi-standard-processors" + quotedSeparator + "target:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testIgnoredStdin() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        Assertions.assertTrue((boolean)Pattern.compile("target:ModifiedResult\r?\n$").matcher(result).find(), (String)"TestIngestAndUpdate.jar should not have received anything to modify");
    }

    @Test
    public void testIgnoredStdinDynamicProperties() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        Assertions.assertTrue((boolean)Pattern.compile("target:ModifiedResult\r?\n$").matcher(result).find(), (String)"TestIngestAndUpdate.jar should not have received anything to modify");
    }

    @Test
    public void testDynamicEnvironment() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestDynamicEnvironment.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setProperty("NIFI_TEST_1", "testvalue1");
        controller.setProperty("NIFI_TEST_2", "testvalue2");
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        HashSet<String> dynamicEnvironmentVariables = new HashSet<String>(Arrays.asList(result.split("\r?\n")));
        Assertions.assertFalse((dynamicEnvironmentVariables.size() < 2 ? 1 : 0) != 0, (String)"Should contain at least two environment variables starting with NIFI");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_1=testvalue1"), (String)"NIFI_TEST_1 environment variable is missing");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_2=testvalue2"), (String)"NIFI_TEST_2 environment variable is missing");
    }

    @Test
    public void testDynamicEnvironmentDynamicProperties() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestDynamicEnvironment.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setProperty("NIFI_TEST_1", "testvalue1");
        controller.setProperty("NIFI_TEST_2", "testvalue2");
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        byte[] byteArray = ((MockFlowFile)flowFiles.get(0)).toByteArray();
        String result = new String(byteArray);
        HashSet<String> dynamicEnvironmentVariables = new HashSet<String>(Arrays.asList(result.split("\r?\n")));
        Assertions.assertFalse((dynamicEnvironmentVariables.size() < 2 ? 1 : 0) != 0, (String)"Should contain at least two environment variables starting with NIFI");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_1=testvalue1"), (String)"NIFI_TEST_1 environment variable is missing");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_2=testvalue2"), (String)"NIFI_TEST_2 environment variable is missing");
    }

    @Test
    public void testSmallEchoPutToAttribute() {
        File dummy = new File("src/test/resources/hello.txt");
        Assertions.assertTrue((boolean)dummy.exists());
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setProperty(ExecuteStreamCommand.MIME_TYPE, "application/json");
        controller.enqueue("".getBytes());
        if (TestExecuteStreamCommand.isWindows()) {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "cmd.exe");
            controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "/c;echo Hello");
            controller.setProperty(ExecuteStreamCommand.ARG_DELIMITER, ";");
        } else {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "echo");
            controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "Hello");
        }
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        outputFlowFile.assertContentEquals("");
        outputFlowFile.assertAttributeNotExists(CoreAttributes.MIME_TYPE.key());
        String ouput = outputFlowFile.getAttribute("executeStreamCommand.output");
        Assertions.assertTrue((boolean)ouput.startsWith("Hello"));
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)(TestExecuteStreamCommand.isWindows() ? "cmd.exe" : "echo"), (Object)outputFlowFile.getAttribute("execution.command"));
    }

    @Test
    public void testSmallEchoPutToAttributeDynamicProperties() {
        PropertyDescriptor dynamicProp1;
        File dummy = new File("src/test/resources/hello.txt");
        Assertions.assertTrue((boolean)dummy.exists());
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue("".getBytes());
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        if (TestExecuteStreamCommand.isWindows()) {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "cmd.exe");
            dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp1, "/c");
            PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp2, "echo Hello");
            controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "/c;echo Hello");
        } else {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "echo");
            dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp1, "Hello");
        }
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        outputFlowFile.assertContentEquals("");
        String ouput = outputFlowFile.getAttribute("executeStreamCommand.output");
        Assertions.assertTrue((boolean)ouput.startsWith("Hello"));
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)(TestExecuteStreamCommand.isWindows() ? "cmd.exe" : "echo"), (Object)outputFlowFile.getAttribute("execution.command"));
    }

    @Test
    public void testArgumentsWithQuotesFromAttributeDynamicProperties() throws Exception {
        File dummy = new File("src/test/resources/TestJson/json-sample.json");
        Assertions.assertTrue((boolean)dummy.exists());
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        HashMap<String, String> attrs = new HashMap<String, String>();
        String json = FileUtils.readFileToString((File)dummy, (Charset)StandardCharsets.UTF_8);
        attrs.put("json.attribute", json);
        controller.enqueue("".getBytes(), attrs);
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        if (TestExecuteStreamCommand.isWindows()) {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "cmd.exe");
            PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp1, "/c");
            PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp2, "echo");
        } else {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "echo");
        }
        PropertyDescriptor dynamicProp3 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.3").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp3, "${json.attribute}");
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        String output = new String(outputFlowFile.toByteArray());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode tree1 = mapper.readTree(json);
        JsonNode tree2 = mapper.readTree(output);
        Assertions.assertEquals((Object)tree1, (Object)tree2);
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)(TestExecuteStreamCommand.isWindows() ? "cmd.exe" : "echo"), (Object)outputFlowFile.getAttribute("execution.command"));
    }

    @Test
    public void testExecuteJarPutToAttribute() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestSuccess.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        String result = outputFlowFile.getAttribute("executeStreamCommand.output");
        outputFlowFile.assertContentEquals(dummy);
        Assertions.assertTrue((boolean)Pattern.compile("Test was a success\r?\n").matcher(result).find());
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar;", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 5));
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "TestSuccess.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
    }

    @Test
    public void testExecuteJarPutToAttributeDynamicProperties() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestSuccess.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        String result = outputFlowFile.getAttribute("executeStreamCommand.output");
        outputFlowFile.assertContentEquals(dummy);
        Assertions.assertTrue((boolean)Pattern.compile("Test was a success\r?\n").matcher(result).find());
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 4));
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "TestSuccess.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
    }

    @Test
    public void testExecuteJarToAttributeConfiguration() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestSuccess.jar");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue("small test".getBytes());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_ATTRIBUTE_MAX_LENGTH, "10");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "outputDest");
        Assertions.assertEquals((int)1, (int)controller.getProcessContext().getAvailableRelationships().size());
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        outputFlowFile.assertContentEquals("small test".getBytes());
        String result = outputFlowFile.getAttribute("outputDest");
        Assertions.assertTrue((boolean)Pattern.compile("Test was a").matcher(result).find());
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar;", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 5));
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "TestSuccess.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
    }

    @Test
    public void testExecuteJarToAttributeConfigurationDyanmicProperties() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestSuccess.jar");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue("small test".getBytes());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_ATTRIBUTE_MAX_LENGTH, "10");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "outputDest");
        Assertions.assertEquals((int)1, (int)controller.getProcessContext().getAvailableRelationships().size());
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        outputFlowFile.assertContentEquals("small test".getBytes());
        String result = outputFlowFile.getAttribute("outputDest");
        Assertions.assertTrue((boolean)Pattern.compile("Test was a").matcher(result).find());
        Assertions.assertEquals((Object)"0", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 4));
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "TestSuccess.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
    }

    @Test
    public void testExecuteIngestAndUpdatePutToAttribute() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        File dummy10MBytes = new File("target/10MB.txt");
        byte[] bytes = Files.readAllBytes(dummy.toPath());
        try (FileOutputStream fos = new FileOutputStream(dummy10MBytes);){
            for (int i = 0; i < 10000; ++i) {
                fos.write(bytes, 0, 1000);
            }
        }
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy10MBytes.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "outputDest");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("outputDest");
        Assertions.assertTrue((boolean)Pattern.compile("nifi-standard-processors:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testExecuteIngestAndUpdatePutToAttributeDynamicProperties() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        File dummy10MBytes = new File("target/10MB.txt");
        byte[] bytes = Files.readAllBytes(dummy.toPath());
        try (FileOutputStream fos = new FileOutputStream(dummy10MBytes);){
            for (int i = 0; i < 10000; ++i) {
                fos.write(bytes, 0, 1000);
            }
        }
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy10MBytes.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "outputDest");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("outputDest");
        Assertions.assertTrue((boolean)Pattern.compile("nifi-standard-processors:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testLargePutToAttribute() throws IOException {
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        File dummy10MBytes = new File("target/10MB.txt");
        byte[] bytes = Files.readAllBytes(dummy.toPath());
        try (FileOutputStream fos = new FileOutputStream(dummy10MBytes);){
            for (int i = 0; i < 10000; ++i) {
                fos.write(bytes, 0, 1000);
            }
        }
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue("".getBytes());
        if (TestExecuteStreamCommand.isWindows()) {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "cmd.exe");
            controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "/c;type " + dummy10MBytes.getAbsolutePath());
            controller.setProperty(ExecuteStreamCommand.ARG_DELIMITER, ";");
        } else {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "cat");
            controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, dummy10MBytes.getAbsolutePath());
        }
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.setProperty(ExecuteStreamCommand.PUT_ATTRIBUTE_MAX_LENGTH, "256");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("execution.status", "0");
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("executeStreamCommand.output");
        Assertions.assertTrue((boolean)Pattern.compile("a{256}").matcher(result).matches());
    }

    @Test
    public void testLargePutToAttributeDynamicProperties() throws IOException {
        PropertyDescriptor dynamicProp1;
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        File dummy10MBytes = new File("target/10MB.txt");
        byte[] bytes = Files.readAllBytes(dummy.toPath());
        try (FileOutputStream fos = new FileOutputStream(dummy10MBytes);){
            for (int i = 0; i < 10000; ++i) {
                fos.write(bytes, 0, 1000);
            }
        }
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue("".getBytes());
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        if (TestExecuteStreamCommand.isWindows()) {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "cmd.exe");
            dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp1, "/c");
            PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp2, "type " + dummy10MBytes.getAbsolutePath());
        } else {
            controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "cat");
            dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
            controller.setProperty(dynamicProp1, dummy10MBytes.getAbsolutePath());
        }
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.setProperty(ExecuteStreamCommand.PUT_ATTRIBUTE_MAX_LENGTH, "256");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("execution.status", "0");
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("executeStreamCommand.output");
        Assertions.assertTrue((boolean)Pattern.compile("a{256}").matcher(result).matches());
    }

    @Test
    public void testExecuteIngestAndUpdateWithWorkingDirPutToAttribute() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "streamOutput");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("streamOutput");
        String quotedSeparator = Pattern.quote(File.separator);
        Assertions.assertTrue((boolean)Pattern.compile(quotedSeparator + "nifi-standard-processors" + quotedSeparator + "target:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testExecuteIngestAndUpdateWithWorkingDirPutToAttributeDynamicProperties() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "streamOutput");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("streamOutput");
        String quotedSeparator = Pattern.quote(File.separator);
        Assertions.assertTrue((boolean)Pattern.compile(quotedSeparator + "nifi-standard-processors" + quotedSeparator + "target:ModifiedResult\r?\n").matcher(result).find());
    }

    @Test
    public void testIgnoredStdinPutToAttribute() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("executeStreamCommand.output");
        Assertions.assertTrue((boolean)Pattern.compile("target:ModifiedResult\r?\n?").matcher(result).find(), (String)"TestIngestAndUpdate.jar should not have received anything to modify");
    }

    @Test
    public void testIgnoredStdinPutToAttributeDynamicProperties() throws IOException {
        File exJar = new File("src/test/resources/ExecuteCommand/TestIngestAndUpdate.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.setProperty(ExecuteStreamCommand.IGNORE_STDIN, "true");
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("executeStreamCommand.output");
        Assertions.assertTrue((boolean)Pattern.compile("target:ModifiedResult\r?\n?").matcher(result).find(), (String)"TestIngestAndUpdate.jar should not have received anything to modify");
    }

    @Test
    public void testDynamicEnvironmentPutToAttribute() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestDynamicEnvironment.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setProperty("NIFI_TEST_1", "testvalue1");
        controller.setProperty("NIFI_TEST_2", "testvalue2");
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("executeStreamCommand.output");
        HashSet<String> dynamicEnvironmentVariables = new HashSet<String>(Arrays.asList(result.split("\r?\n")));
        Assertions.assertFalse((dynamicEnvironmentVariables.size() < 2 ? 1 : 0) != 0, (String)"Should contain at least two environment variables starting with NIFI");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_1=testvalue1"), (String)"NIFI_TEST_1 environment variable is missing");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_2=testvalue2"), (String)"NIFI_TEST_2 environment variable is missing");
    }

    @Test
    public void testDynamicEnvironmentPutToAttributeDynamicProperties() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/TestDynamicEnvironment.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setProperty("NIFI_TEST_1", "testvalue1");
        controller.setProperty("NIFI_TEST_2", "testvalue2");
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.WORKING_DIR, "target");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        String result = ((MockFlowFile)flowFiles.get(0)).getAttribute("executeStreamCommand.output");
        HashSet<String> dynamicEnvironmentVariables = new HashSet<String>(Arrays.asList(result.split("\r?\n")));
        Assertions.assertFalse((dynamicEnvironmentVariables.size() < 2 ? 1 : 0) != 0, (String)"Should contain at least two environment variables starting with NIFI");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_1=testvalue1"), (String)"NIFI_TEST_1 environment variable is missing");
        Assertions.assertTrue((boolean)dynamicEnvironmentVariables.contains("NIFI_TEST_2=testvalue2"), (String)"NIFI_TEST_2 environment variable is missing");
    }

    @Test
    public void testQuotedArguments() throws Exception {
        List args = ArgumentUtils.splitArgs((String)"echo -n \"arg1 arg2 arg3\"", (char)' ');
        Assertions.assertEquals((int)3, (int)args.size());
        args = ArgumentUtils.splitArgs((String)"echo;-n;\"arg1 arg2 arg3\"", (char)';');
        Assertions.assertEquals((int)3, (int)args.size());
    }

    @Test
    public void testInvalidDelimiter() throws Exception {
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "echo");
        controller.assertValid();
        controller.setProperty(ExecuteStreamCommand.ARG_DELIMITER, "foo");
        controller.assertNotValid();
        controller.setProperty(ExecuteStreamCommand.ARG_DELIMITER, "f");
        controller.assertValid();
    }

    @Test
    public void testExecuteJarPutToAttributeBadPath() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/noSuchFile.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.EXECUTION_ARGUMENTS, "-jar;" + jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        String result = outputFlowFile.getAttribute("executeStreamCommand.output");
        outputFlowFile.assertContentEquals(dummy);
        Assertions.assertTrue((boolean)result.isEmpty());
        Assertions.assertEquals((Object)"1", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar;", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 5));
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "noSuchFile.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
    }

    @Test
    public void testExecuteJarPutToAttributeBadPathDynamicProperties() throws Exception {
        File exJar = new File("src/test/resources/ExecuteCommand/noSuchFile.jar");
        File dummy = new File("src/test/resources/ExecuteCommand/1000bytes.txt");
        String jarPath = exJar.getAbsolutePath();
        exJar.setExecutable(true);
        TestRunner controller = TestRunners.newTestRunner(ExecuteStreamCommand.class);
        controller.enqueue(dummy.toPath());
        controller.setProperty(ExecuteStreamCommand.EXECUTION_COMMAND, "java");
        controller.setProperty(ExecuteStreamCommand.ARGUMENTS_STRATEGY, ExecuteStreamCommand.DYNAMIC_PROPERTY_ARGUMENTS_STRATEGY.getValue());
        PropertyDescriptor dynamicProp1 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.1").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp1, "-jar");
        PropertyDescriptor dynamicProp2 = new PropertyDescriptor.Builder().dynamic(true).name("command.argument.2").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        controller.setProperty(dynamicProp2, jarPath);
        controller.setProperty(ExecuteStreamCommand.PUT_OUTPUT_IN_ATTRIBUTE, "executeStreamCommand.output");
        controller.run(1);
        controller.assertTransferCount(ExecuteStreamCommand.OUTPUT_STREAM_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.NONZERO_STATUS_RELATIONSHIP, 0);
        controller.assertTransferCount(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP, 1);
        List flowFiles = controller.getFlowFilesForRelationship(ExecuteStreamCommand.ORIGINAL_RELATIONSHIP);
        MockFlowFile outputFlowFile = (MockFlowFile)flowFiles.get(0);
        String result = outputFlowFile.getAttribute("executeStreamCommand.output");
        outputFlowFile.assertContentEquals(dummy);
        Assertions.assertTrue((boolean)result.isEmpty());
        Assertions.assertEquals((Object)"1", (Object)outputFlowFile.getAttribute("execution.status"));
        Assertions.assertEquals((Object)"java", (Object)outputFlowFile.getAttribute("execution.command"));
        Assertions.assertEquals((Object)"-jar", (Object)outputFlowFile.getAttribute("execution.command.args").substring(0, 4));
        String attribute = outputFlowFile.getAttribute("execution.command.args");
        String expected = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "ExecuteCommand" + File.separator + "noSuchFile.jar";
        Assertions.assertEquals((Object)expected, (Object)attribute.substring(attribute.length() - expected.length()));
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }
}

