/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;

@EventDriven
@SideEffectFree
@SupportsBatching(defaultDuration=DefaultRunDuration.TWENTY_FIVE_MILLIS)
@Tags(value={"attributes", "hash"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Hashes together the key/value pairs of several flowfile attributes and adds the hash as a new attribute. Optional properties are to be added such that the name of the property is the name of a flowfile attribute to consider and the value of the property is a regular expression that, if matched by the attribute value, will cause that attribute to be used as part of the hash. If the regular expression contains a capturing group, only the value of the capturing group will be used. For a processor which accepts various attributes and generates a cryptographic hash of each, see \"CryptographicHashAttribute\". ")
@WritesAttribute(attribute="<Hash Value Attribute Key>", description="This Processor adds an attribute whose value is the result of Hashing the existing flowfile attributes. The name of this attribute is specified by the <Hash Value Attribute Key> property.")
@DynamicProperty(name="A flowfile attribute key for attribute inspection", value="A Regular Expression", description="This regular expression is evaluated against the flowfile attribute values. If the regular expression contains a capturing group, the value of that group will be used when comparing flow file attributes. Otherwise, the original flow file attribute's value will be used if and only if the value matches the given regular expression.")
@DeprecationNotice(classNames={"org.apache.nifi.processors.attributes.UpdateAttribute"}, reason="UpdateAttribute can be configured using the hash Expression Language function to digest one or more attributes")
public class HashAttribute
extends AbstractProcessor {
    public static final PropertyDescriptor HASH_VALUE_ATTRIBUTE = new PropertyDescriptor.Builder().name("Hash Value Attribute Key").displayName("Hash Value Attribute Key").description("The name of the flowfile attribute where the hash value should be stored").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Used for flowfiles that have a hash value added").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Used for flowfiles that are missing required attributes").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicReference<Map<String, Pattern>> regexMapRef = new AtomicReference(Collections.emptyMap());

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_FAILURE);
        relationships.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HASH_VALUE_ATTRIBUTE);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.createRegexValidator((int)0, (int)1, (boolean)false)).required(false).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isRequired()) {
            return;
        }
        HashMap<String, Pattern> patternMap = new HashMap<String, Pattern>(this.regexMapRef.get());
        if (newValue == null) {
            patternMap.remove(descriptor.getName());
        } else if (newValue.equals(".*")) {
            patternMap.put(descriptor.getName(), null);
        } else {
            Pattern pattern = Pattern.compile(newValue);
            patternMap.put(descriptor.getName(), pattern);
        }
        this.regexMapRef.set(Collections.unmodifiableMap(patternMap));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Map<String, Pattern> patterns = this.regexMapRef.get();
        ComponentLog logger = this.getLogger();
        SortedMap<String, String> attributes = this.getRelevantAttributes(flowFile, patterns);
        if (attributes.size() != patterns.size()) {
            Set<String> wantedKeys = patterns.keySet();
            Set<String> foundKeys = attributes.keySet();
            StringBuilder missingKeys = new StringBuilder();
            for (String wantedKey : wantedKeys) {
                if (foundKeys.contains(wantedKey)) continue;
                missingKeys.append(wantedKey).append(" ");
            }
            logger.error("routing {} to 'failure' because of missing attributes: {}", new Object[]{flowFile, missingKeys});
            session.transfer(flowFile, REL_FAILURE);
        } else {
            StringBuilder hashableValue = new StringBuilder();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                hashableValue.append(entry.getKey());
                if (StringUtils.isBlank((CharSequence)entry.getValue())) {
                    hashableValue.append("EMPTY");
                    continue;
                }
                hashableValue.append(entry.getValue());
            }
            String hashValue = DigestUtils.md5Hex((String)hashableValue.toString());
            logger.info("adding Hash Value {} to attributes for {} and routing to success", new Object[]{hashValue, flowFile});
            flowFile = session.putAttribute(flowFile, context.getProperty(HASH_VALUE_ATTRIBUTE).getValue(), hashValue);
            session.getProvenanceReporter().modifyAttributes(flowFile);
            session.transfer(flowFile, REL_SUCCESS);
        }
    }

    private SortedMap<String, String> getRelevantAttributes(FlowFile flowFile, Map<String, Pattern> patterns) {
        TreeMap<String, String> attributeMap = new TreeMap<String, String>();
        for (Map.Entry<String, Pattern> entry : patterns.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = flowFile.getAttribute(attributeName);
            if (attributeValue == null) continue;
            Pattern pattern = entry.getValue();
            if (pattern == null) {
                attributeMap.put(attributeName, attributeValue);
                continue;
            }
            Matcher matcher = pattern.matcher(attributeValue);
            if (!matcher.matches()) continue;
            if (matcher.groupCount() == 0) {
                attributeMap.put(attributeName, matcher.group(0));
                continue;
            }
            attributeMap.put(attributeName, matcher.group(1));
        }
        return attributeMap;
    }
}

