/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.record.sink.RecordSinkService;
import org.apache.nifi.record.sink.RetryableIOException;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class MockRecordSinkService
extends AbstractConfigurableComponent
implements RecordSinkService {
    private List<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
    private boolean transmitted = false;
    private boolean failWithRetryableError = false;

    public MockRecordSinkService() {
    }

    public MockRecordSinkService(boolean failWithRetryableError) {
        this();
        this.failWithRetryableError = failWithRetryableError;
    }

    public WriteResult sendData(RecordSet recordSet, Map<String, String> attributes, boolean sendZeroResults) throws IOException {
        Record record;
        if (this.failWithRetryableError) {
            throw new RetryableIOException("Retryable");
        }
        int numRecordsWritten = 0;
        RecordSchema recordSchema = recordSet.getSchema();
        while ((record = recordSet.next()) != null) {
            HashMap row = new HashMap();
            Record finalRecord = record;
            recordSchema.getFieldNames().forEach(fieldName -> row.put(fieldName, finalRecord.getValue(fieldName)));
            this.rows.add(row);
            ++numRecordsWritten;
        }
        if (numRecordsWritten > 0 || sendZeroResults) {
            this.transmitted = true;
        }
        return WriteResult.of((int)numRecordsWritten, Collections.emptyMap());
    }

    public String getIdentifier() {
        return "MockRecordSinkService";
    }

    public void initialize(ControllerServiceInitializationContext context) throws InitializationException {
    }

    public List<Map<String, Object>> getRows() {
        return this.rows;
    }

    public boolean isTransmitted() {
        return this.transmitted;
    }

    public void setFailWithRetryableError(boolean failWithRetryableError) {
        this.failWithRetryableError = failWithRetryableError;
    }
}

