/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.List;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.SegmentContent;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSegmentContent {
    @Test
    public void test() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SegmentContent());
        testRunner.setProperty(SegmentContent.SIZE, "4 B");
        testRunner.enqueue(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        testRunner.run();
        testRunner.assertTransferCount(SegmentContent.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(SegmentContent.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(SegmentContent.FRAGMENT_ID);
        originalFlowFile.assertAttributeEquals(SegmentContent.FRAGMENT_COUNT, "3");
        List flowFiles = testRunner.getFlowFilesForRelationship(SegmentContent.REL_SEGMENTS);
        Assertions.assertEquals((int)3, (int)flowFiles.size());
        MockFlowFile out1 = (MockFlowFile)flowFiles.get(0);
        MockFlowFile out2 = (MockFlowFile)flowFiles.get(1);
        MockFlowFile out3 = (MockFlowFile)flowFiles.get(2);
        out1.assertContentEquals(new byte[]{1, 2, 3, 4});
        out2.assertContentEquals(new byte[]{5, 6, 7, 8});
        out3.assertContentEquals(new byte[]{9});
    }

    @Test
    public void testTransferSmall() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new SegmentContent());
        testRunner.setProperty(SegmentContent.SIZE, "4 KB");
        testRunner.enqueue(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        testRunner.run();
        testRunner.assertTransferCount(SegmentContent.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)testRunner.getFlowFilesForRelationship(SegmentContent.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(SegmentContent.FRAGMENT_ID);
        originalFlowFile.assertAttributeEquals(SegmentContent.FRAGMENT_COUNT, "1");
        testRunner.assertTransferCount(SegmentContent.REL_SEGMENTS, 1);
        MockFlowFile out1 = (MockFlowFile)testRunner.getFlowFilesForRelationship(SegmentContent.REL_SEGMENTS).get(0);
        out1.assertContentEquals(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
    }
}

