/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractExecuteSQL;
import org.apache.nifi.processors.standard.ExecuteSQL;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.util.db.AvroUtil;
import org.apache.nifi.util.db.SimpleCommerceDataSet;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecuteSQL {
    private final Logger LOGGER = LoggerFactory.getLogger(TestExecuteSQL.class);
    static final String DB_LOCATION = "target/db";
    static final String QUERY_WITH_EL = "select   PER.ID as PersonId, PER.NAME as PersonName, PER.CODE as PersonCode, PRD.ID as ProductId,PRD.NAME as ProductName,PRD.CODE as ProductCode, REL.ID as RelId,    REL.NAME as RelName,    REL.CODE as RelCode, ROW_NUMBER() OVER () as rownr  from persons PER, products PRD, relationships REL where PER.ID = ${person.id}";
    static final String QUERY_WITHOUT_EL = "select   PER.ID as PersonId, PER.NAME as PersonName, PER.CODE as PersonCode, PRD.ID as ProductId,PRD.NAME as ProductName,PRD.CODE as ProductCode, REL.ID as RelId,    REL.NAME as RelName,    REL.CODE as RelCode, ROW_NUMBER() OVER () as rownr  from persons PER, products PRD, relationships REL where PER.ID = 10";
    static final String QUERY_WITHOUT_EL_WITH_PARAMS = "select   PER.ID as PersonId, PER.NAME as PersonName, PER.CODE as PersonCode, PRD.ID as ProductId,PRD.NAME as ProductName,PRD.CODE as ProductCode, REL.ID as RelId,    REL.NAME as RelName,    REL.CODE as RelCode, ROW_NUMBER() OVER () as rownr  from persons PER, products PRD, relationships REL where PER.ID < ? AND REL.ID < ?";
    private TestRunner runner;

    @BeforeAll
    public static void setupClass() {
        System.setProperty("derby.stream.error.file", "target/derby.log");
    }

    @AfterAll
    public static void cleanupClass() {
        System.clearProperty("derby.stream.error.file");
    }

    @BeforeEach
    public void setup() throws InitializationException {
        DBCPServiceSimpleImpl dbcp = new DBCPServiceSimpleImpl();
        HashMap dbcpProperties = new HashMap();
        this.runner = TestRunners.newTestRunner(ExecuteSQL.class);
        this.runner.addControllerService("dbcp", (ControllerService)dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)dbcp);
        this.runner.setProperty(ExecuteSQL.DBCP_SERVICE, "dbcp");
    }

    @Test
    public void testIncomingConnectionWithNoFlowFile() throws InitializationException {
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "SELECT * FROM persons");
        this.runner.run();
        this.runner.assertTransferCount(ExecuteSQL.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ExecuteSQL.REL_FAILURE, 0);
    }

    @Test
    public void testIncomingConnectionWithNoFlowFileAndNoQuery() throws InitializationException {
        this.runner.setIncomingConnection(true);
        this.runner.run();
        this.runner.assertTransferCount(ExecuteSQL.REL_SUCCESS, 0);
        this.runner.assertTransferCount(ExecuteSQL.REL_FAILURE, 0);
    }

    @Test
    public void testNoIncomingConnectionAndNoQuery() throws InitializationException {
        this.runner.setIncomingConnection(false);
        Assertions.assertThrows(AssertionError.class, () -> this.runner.run());
    }

    @Test
    public void testNoIncomingConnection() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        this.runner.setIncomingConnection(false);
        this.invokeOnTrigger(null, QUERY_WITHOUT_EL, false, null, true);
    }

    @Test
    public void testNoTimeLimit() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.invokeOnTrigger(null, QUERY_WITH_EL, true, null, true);
    }

    @Test
    public void testSelectQueryInFlowFile() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.invokeOnTrigger(null, QUERY_WITHOUT_EL, true, null, false);
    }

    @Test
    public void testSelectQueryInFlowFileWithParameters() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        HashMap<String, String> sqlParams = new HashMap<String, String>(){
            {
                this.put("sql.args.1.type", "4");
                this.put("sql.args.1.value", "20");
                this.put("sql.args.2.type", "4");
                this.put("sql.args.2.value", "5");
            }
        };
        this.invokeOnTrigger(null, QUERY_WITHOUT_EL_WITH_PARAMS, true, (Map<String, String>)sqlParams, false);
    }

    @Test
    public void testQueryTimeout() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.invokeOnTrigger(1, QUERY_WITH_EL, true, null, true);
    }

    @Test
    public void testAutoCommitFalse() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.runner.setProperty(ExecuteSQL.AUTO_COMMIT, "false");
        this.invokeOnTrigger(null, QUERY_WITHOUT_EL, true, null, false);
    }

    @Test
    public void testAutoCommitTrue() throws InitializationException, ClassNotFoundException, SQLException, IOException {
        this.runner.setProperty(ExecuteSQL.AUTO_COMMIT, "true");
        this.invokeOnTrigger(null, QUERY_WITHOUT_EL, true, null, false);
    }

    @Test
    public void testWithNullIntColumn() throws SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (1, 1, 1)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "SELECT * FROM TEST_NULL_INT");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0)).assertAttributeEquals("executesql.row.count", "2");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0)).assertAttributeEquals("executesql.resultset.index", "0");
    }

    @Test
    public void testCompression() throws SQLException, CompressorException, IOException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (1, 1, 1)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQL.COMPRESSION_FORMAT, AvroUtil.CodecType.BZIP2.name());
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "SELECT * FROM TEST_NULL_INT");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0);
        try (DataFileStream dfs = new DataFileStream((InputStream)new ByteArrayInputStream(flowFile.toByteArray()), (DatumReader)new GenericDatumReader());){
            Assertions.assertEquals((Object)AvroUtil.CodecType.BZIP2.name().toLowerCase(), (Object)dfs.getMetaString("avro.codec").toLowerCase());
        }
    }

    @Test
    public void testWithOutputBatching() throws SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        for (int i = 0; i < 1000; ++i) {
            stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (" + i + ", 1, 1)");
        }
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQL.MAX_ROWS_PER_FLOW_FILE, "5");
        this.runner.setProperty(ExecuteSQL.OUTPUT_BATCH_SIZE, "5");
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "SELECT * FROM TEST_NULL_INT");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 200);
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_INDEX.key());
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_ID.key());
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "5");
        firstFlowFile.assertAttributeNotExists(FragmentAttributes.FRAGMENT_COUNT.key());
        firstFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "0");
        firstFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
        MockFlowFile lastFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(199);
        lastFlowFile.assertAttributeEquals("executesql.row.count", "5");
        lastFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "199");
        lastFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
    }

    @Test
    public void testWithOutputBatchingAndIncomingFlowFile() throws SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        for (int i = 0; i < 1000; ++i) {
            stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (" + i + ", 1, 1)");
        }
        HashMap<String, String> attrMap = new HashMap<String, String>();
        String testAttrName = "attr1";
        String testAttrValue = "value1";
        attrMap.put(testAttrName, testAttrValue);
        attrMap.put("max.rows", "5");
        attrMap.put("batch.size", "1");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQL.MAX_ROWS_PER_FLOW_FILE, "${max.rows}");
        this.runner.setProperty(ExecuteSQL.OUTPUT_BATCH_SIZE, "${batch.size}");
        MockFlowFile inputFlowFile = this.runner.enqueue("SELECT * FROM TEST_NULL_INT", attrMap);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 200);
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_INDEX.key());
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_ID.key());
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "5");
        firstFlowFile.assertAttributeNotExists(FragmentAttributes.FRAGMENT_COUNT.key());
        firstFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "0");
        firstFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
        MockFlowFile lastFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(199);
        lastFlowFile.assertAttributeEquals("executesql.row.count", "5");
        lastFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "199");
        lastFlowFile.assertAttributeEquals(testAttrName, testAttrValue);
        lastFlowFile.assertAttributeEquals("input.flowfile.uuid", inputFlowFile.getAttribute(CoreAttributes.UUID.key()));
    }

    @Test
    public void testMaxRowsPerFlowFile() throws SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        for (int i = 0; i < 1000; ++i) {
            stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (" + i + ", 1, 1)");
        }
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQL.MAX_ROWS_PER_FLOW_FILE, "5");
        this.runner.setProperty(AbstractExecuteSQL.FETCH_SIZE, "5");
        this.runner.setProperty(ExecuteSQL.OUTPUT_BATCH_SIZE, "0");
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "SELECT * FROM TEST_NULL_INT");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 200);
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_INDEX.key());
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_ID.key());
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, FragmentAttributes.FRAGMENT_COUNT.key());
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "5");
        firstFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "0");
        firstFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
        MockFlowFile lastFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(199);
        lastFlowFile.assertAttributeEquals("executesql.row.count", "5");
        lastFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_INDEX.key(), "199");
        lastFlowFile.assertAttributeEquals("executesql.resultset.index", "0");
    }

    @Test
    public void testInsertStatementCreatesFlowFile() throws SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "insert into TEST_NULL_INT (id, val1, val2) VALUES (0, NULL, 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0)).assertAttributeEquals("executesql.row.count", "0");
    }

    @Test
    public void testNoRowsStatementCreatesEmptyFlowFile() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        this.runner.enqueue("Hello".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "0");
        ByteArrayInputStream in = new ByteArrayInputStream(firstFlowFile.toByteArray());
        GenericDatumReader datumReader = new GenericDatumReader();
        try (DataFileStream dataFileReader = new DataFileStream((InputStream)in, (DatumReader)datumReader);){
            GenericRecord record = null;
            long recordsFromStream = 0L;
            while (dataFileReader.hasNext()) {
                record = (GenericRecord)dataFileReader.next(record);
                ++recordsFromStream;
            }
            Assertions.assertEquals((long)0L, (long)recordsFromStream);
        }
    }

    @Test
    public void testWithDuplicateColumns() throws SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table host1");
            stmt.execute("drop table host2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table host1 (id integer not null, host varchar(45))");
        stmt.execute("create table host2 (id integer not null, host varchar(45))");
        stmt.execute("insert into host1 values(1,'host1')");
        stmt.execute("insert into host2 values(1,'host2')");
        stmt.execute("select a.host as hostA,b.host as hostB from host1 a join host2 b on b.id=a.id");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "select a.host as hostA,b.host as hostB from host1 a join host2 b on b.id=a.id");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0)).assertAttributeEquals("executesql.row.count", "1");
    }

    @Test
    public void testWithSqlException() throws SQLException {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NO_ROWS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NO_ROWS (id integer)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "SELECT val1 FROM TEST_NO_ROWS");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_FAILURE, 0);
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 0);
    }

    @Test
    public void testWithSqlExceptionErrorProcessingResultSet() throws Exception {
        DBCPService dbcp = (DBCPService)Mockito.mock(DBCPService.class);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dbcp.getConnection((Map)ArgumentMatchers.any(Map.class))).thenReturn((Object)conn);
        Mockito.when((Object)dbcp.getIdentifier()).thenReturn((Object)"mockdbcp");
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)conn.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute()).thenReturn((Object)true);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)rs);
        Mockito.when((Object)rs.getMetaData()).thenThrow(new Throwable[]{new SQLException("test execute statement failed")});
        this.runner.addControllerService("mockdbcp", (ControllerService)dbcp, new HashMap());
        this.runner.enableControllerService((ControllerService)dbcp);
        this.runner.setProperty(ExecuteSQL.DBCP_SERVICE, "mockdbcp");
        this.runner.setIncomingConnection(true);
        this.runner.enqueue("SELECT 1");
        this.runner.run();
        this.runner.assertTransferCount(ExecuteSQL.REL_FAILURE, 1);
        this.runner.assertTransferCount(ExecuteSQL.REL_SUCCESS, 0);
        MockFlowFile failedFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_FAILURE).get(0);
        Assertions.assertEquals((Object)"java.sql.SQLException: test execute statement failed", (Object)failedFlowFile.getAttribute("executesql.error.message"));
    }

    public void invokeOnTrigger(Integer queryTimeout, String query, boolean incomingFlowFile, Map<String, String> attrs, boolean setQueryProperty) throws InitializationException, ClassNotFoundException, SQLException, IOException {
        if (queryTimeout != null) {
            this.runner.setProperty(ExecuteSQL.QUERY_TIMEOUT, queryTimeout.toString() + " secs");
        }
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        SimpleCommerceDataSet.loadTestData2Database((Connection)con, (int)100, (int)200, (int)100);
        this.LOGGER.info("test data loaded");
        if (!con.getAutoCommit()) {
            con.commit();
        }
        int nrOfRows = 20000;
        if (incomingFlowFile) {
            HashMap<String, String> attributes = attrs == null ? new HashMap<String, String>() : attrs;
            attributes.put("person.id", "10");
            if (!setQueryProperty) {
                this.runner.enqueue(query.getBytes(), attributes);
            } else {
                this.runner.enqueue("Hello".getBytes(), attributes);
            }
        }
        if (setQueryProperty) {
            this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, query);
        }
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, "executesql.query.duration");
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, "executesql.query.executiontime");
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, "executesql.query.fetchtime");
        this.runner.assertAllFlowFilesContainAttribute(ExecuteSQL.REL_SUCCESS, "executesql.row.count");
        List flowfiles = this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS);
        long executionTime = Long.parseLong(((MockFlowFile)flowfiles.get(0)).getAttribute("executesql.query.executiontime"));
        long fetchTime = Long.parseLong(((MockFlowFile)flowfiles.get(0)).getAttribute("executesql.query.fetchtime"));
        long durationTime = Long.parseLong(((MockFlowFile)flowfiles.get(0)).getAttribute("executesql.query.duration"));
        Assertions.assertEquals((long)durationTime, (long)(fetchTime + executionTime));
        ByteArrayInputStream in = new ByteArrayInputStream(((MockFlowFile)flowfiles.get(0)).toByteArray());
        GenericDatumReader datumReader = new GenericDatumReader();
        try (DataFileStream dataFileReader = new DataFileStream((InputStream)in, (DatumReader)datumReader);){
            GenericRecord record = null;
            long recordsFromStream = 0L;
            while (dataFileReader.hasNext()) {
                record = (GenericRecord)dataFileReader.next(record);
                ++recordsFromStream;
            }
            this.LOGGER.info("total nr of records from stream: " + recordsFromStream);
            Assertions.assertEquals((long)20000L, (long)recordsFromStream);
        }
    }

    @Test
    public void testPreQuery() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT values(1,2,3)");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQL.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "1");
        ByteArrayInputStream in = new ByteArrayInputStream(firstFlowFile.toByteArray());
        GenericDatumReader datumReader = new GenericDatumReader();
        try (DataFileStream dataFileReader = new DataFileStream((InputStream)in, (DatumReader)datumReader);){
            GenericRecord record = null;
            long recordsFromStream = 0L;
            while (dataFileReader.hasNext()) {
                record = (GenericRecord)dataFileReader.next(record);
                ++recordsFromStream;
            }
            Assertions.assertEquals((long)1L, (long)recordsFromStream);
        }
    }

    @Test
    public void testPostQuery() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT values(1,2,3)");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQL.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        this.runner.setProperty(ExecuteSQL.SQL_POST_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)");
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_SUCCESS, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_SUCCESS).get(0);
        firstFlowFile.assertAttributeEquals("executesql.row.count", "1");
        ByteArrayInputStream in = new ByteArrayInputStream(firstFlowFile.toByteArray());
        GenericDatumReader datumReader = new GenericDatumReader();
        try (DataFileStream dataFileReader = new DataFileStream((InputStream)in, (DatumReader)datumReader);){
            GenericRecord record = null;
            long recordsFromStream = 0L;
            while (dataFileReader.hasNext()) {
                record = (GenericRecord)dataFileReader.next(record);
                ++recordsFromStream;
            }
            Assertions.assertEquals((long)1L, (long)recordsFromStream);
        }
    }

    @Test
    public void testPreQueryFail() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQL.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS()");
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_FAILURE, 1);
    }

    @Test
    public void testPostQueryFail() throws Exception {
        File dbLocation = new File(DB_LOCATION);
        dbLocation.delete();
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        this.runner.setIncomingConnection(true);
        this.runner.setProperty(ExecuteSQL.SQL_PRE_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1);CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.runner.setProperty(ExecuteSQL.SQL_SELECT_QUERY, "select * from TEST_NULL_INT");
        this.runner.setProperty(ExecuteSQL.SQL_POST_QUERY, "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS()");
        this.runner.enqueue("test".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(ExecuteSQL.REL_FAILURE, 1);
        MockFlowFile firstFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ExecuteSQL.REL_FAILURE).get(0);
        firstFlowFile.assertContentEquals("test");
    }

    class DBCPServiceSimpleImpl
    extends AbstractControllerService
    implements DBCPService {
        DBCPServiceSimpleImpl() {
        }

        public String getIdentifier() {
            return "dbcp";
        }

        public Connection getConnection() throws ProcessException {
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                Connection con = DriverManager.getConnection("jdbc:derby:target/db;create=true");
                return con;
            }
            catch (Exception e) {
                throw new ProcessException("getConnection failed: " + e);
            }
        }
    }
}

