/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.nifi.processors.standard.ExtractGrok;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestExtractGrok {
    private TestRunner testRunner;
    private static final Path GROK_LOG_INPUT = Paths.get("src/test/resources/TestExtractGrok/apache.log", new String[0]);
    private static final Path GROK_TEXT_INPUT = Paths.get("src/test/resources/TestExtractGrok/simple_text.log", new String[0]);

    @BeforeEach
    public void init() {
        this.testRunner = TestRunners.newTestRunner(ExtractGrok.class);
    }

    @Test
    public void testExtractGrokWithMissingPattern() throws Exception {
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, "%{FOOLOG}");
        this.testRunner.enqueue(GROK_LOG_INPUT);
        this.testRunner.assertNotValid();
    }

    @Test
    public void testExtractGrokPatternsProperty() {
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, "%{USERNAME:username} - %{DATA}");
        this.testRunner.setProperty(ExtractGrok.GROK_PATTERNS, "USERNAME [a-zA-Z0-9._-]+");
        this.testRunner.enqueue("admin - 127.0.0.1");
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(ExtractGrok.REL_MATCH);
        MockFlowFile matched = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(ExtractGrok.REL_MATCH).get(0);
        matched.assertAttributeEquals("grok.username", "admin");
    }

    @Test
    public void testExtractGrokWithMatchedContent() throws IOException {
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, "%{COMMONAPACHELOG}");
        this.testRunner.setProperty(ExtractGrok.GROK_PATTERNS, "src/test/resources/TestExtractGrok/patterns");
        this.testRunner.enqueue(GROK_LOG_INPUT);
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(ExtractGrok.REL_MATCH);
        MockFlowFile matched = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(ExtractGrok.REL_MATCH).get(0);
        matched.assertAttributeEquals("grok.verb", "GET");
        matched.assertAttributeEquals("grok.response", "401");
        matched.assertAttributeEquals("grok.bytes", "12846");
        matched.assertAttributeEquals("grok.clientip", "64.242.88.10");
        matched.assertAttributeEquals("grok.auth", "-");
        matched.assertAttributeEquals("grok.timestamp", "07/Mar/2004:16:05:49 -0800");
        matched.assertAttributeEquals("grok.request", "/twiki/bin/edit/Main/Double_bounce_sender?topicparent=Main.ConfigurationVariables");
        matched.assertAttributeEquals("grok.httpversion", "1.1");
    }

    @Test
    public void testExtractGrokKeepEmptyCaptures() {
        String expression = "%{NUMBER}|%{NUMBER}";
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, expression);
        this.testRunner.enqueue("-42");
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(ExtractGrok.REL_MATCH);
        MockFlowFile matched = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(ExtractGrok.REL_MATCH).get(0);
        matched.assertAttributeEquals("grok.NUMBER", "[-42, null]");
    }

    @Test
    public void testExtractGrokDoNotKeepEmptyCaptures() {
        String expression = "%{NUMBER}|%{NUMBER}";
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, expression);
        this.testRunner.setProperty(ExtractGrok.KEEP_EMPTY_CAPTURES, "false");
        this.testRunner.enqueue("-42");
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(ExtractGrok.REL_MATCH);
        MockFlowFile matched = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(ExtractGrok.REL_MATCH).get(0);
        matched.assertAttributeEquals("grok.NUMBER", "-42");
    }

    @Test
    public void testExtractGrokWithUnMatchedContent() throws IOException {
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, "%{URI}");
        this.testRunner.setProperty(ExtractGrok.GROK_PATTERNS, "src/test/resources/TestExtractGrok/patterns");
        this.testRunner.enqueue(GROK_TEXT_INPUT);
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(ExtractGrok.REL_NO_MATCH);
        MockFlowFile notMatched = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(ExtractGrok.REL_NO_MATCH).get(0);
        notMatched.assertContentEquals(GROK_TEXT_INPUT);
    }

    @Test
    public void testExtractGrokWithNotFoundPatternFile() throws IOException {
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, "%{COMMONAPACHELOG}");
        this.testRunner.setProperty(ExtractGrok.GROK_PATTERNS, "file:///src/test/resources/TestExtractGrok/file-not-found");
        this.testRunner.enqueue(GROK_LOG_INPUT);
        this.testRunner.assertNotValid();
    }

    @Test
    public void testExtractGrokWithBadGrokExpression() throws IOException {
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, "%{TOTO");
        this.testRunner.setProperty(ExtractGrok.GROK_PATTERNS, "src/test/resources/TestExtractGrok/patterns");
        this.testRunner.enqueue(GROK_LOG_INPUT);
        this.testRunner.assertNotValid();
    }

    @Test
    public void testExtractGrokWithNamedCapturesOnly() throws IOException {
        this.testRunner.setProperty(ExtractGrok.GROK_EXPRESSION, "%{COMMONAPACHELOG}");
        this.testRunner.setProperty(ExtractGrok.GROK_PATTERNS, "src/test/resources/TestExtractGrok/patterns");
        this.testRunner.setProperty(ExtractGrok.NAMED_CAPTURES_ONLY, "true");
        this.testRunner.enqueue(GROK_LOG_INPUT);
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(ExtractGrok.REL_MATCH);
        MockFlowFile matched = (MockFlowFile)this.testRunner.getFlowFilesForRelationship(ExtractGrok.REL_MATCH).get(0);
        matched.assertAttributeEquals("grok.verb", "GET");
        matched.assertAttributeEquals("grok.response", "401");
        matched.assertAttributeEquals("grok.bytes", "12846");
        matched.assertAttributeEquals("grok.clientip", "64.242.88.10");
        matched.assertAttributeEquals("grok.auth", "-");
        matched.assertAttributeEquals("grok.timestamp", "07/Mar/2004:16:05:49 -0800");
        matched.assertAttributeEquals("grok.request", "/twiki/bin/edit/Main/Double_bounce_sender?topicparent=Main.ConfigurationVariables");
        matched.assertAttributeEquals("grok.httpversion", "1.1");
        matched.assertAttributeNotExists("grok.INT");
        matched.assertAttributeNotExists("grok.BASE10NUM");
        matched.assertAttributeNotExists("grok.COMMONAPACHELOG");
    }
}

