/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.standard.enrichment.RecordJoinInput;
import org.apache.nifi.processors.standard.enrichment.RecordJoinResult;
import org.apache.nifi.processors.standard.enrichment.RecordJoinStrategy;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public abstract class IndexCorrelatedJoinStrategy
implements RecordJoinStrategy {
    private final ComponentLog logger;

    public IndexCorrelatedJoinStrategy(ComponentLog logger) {
        this.logger = logger;
    }

    protected ComponentLog getLogger() {
        return this.logger;
    }

    @Override
    public RecordJoinResult join(RecordJoinInput originalInput, RecordJoinInput enrichmentInput, ProcessSession session, RecordSchema writerSchema) throws Exception {
        FlowFile originalFlowFile = originalInput.getFlowFile();
        FlowFile enrichmentFlowFile = enrichmentInput.getFlowFile();
        InputStream originalIn = null;
        RecordReader originalRecordReader = null;
        InputStream enrichmentIn = null;
        RecordReader enrichmentRecordReader = null;
        try {
            originalIn = session.read(originalFlowFile);
            originalRecordReader = originalInput.getRecordReaderFactory().createRecordReader(originalFlowFile, originalIn, this.logger);
            enrichmentIn = session.read(enrichmentFlowFile);
            enrichmentRecordReader = enrichmentInput.getRecordReaderFactory().createRecordReader(enrichmentFlowFile, enrichmentIn, this.logger);
            final Record firstOriginalRecord = originalRecordReader.nextRecord();
            final Record firstEnrichmentRecord = enrichmentRecordReader.nextRecord();
            final RecordSchema resultSchema = this.createResultSchema(firstOriginalRecord, firstEnrichmentRecord);
            final InputStream finalOriginalIn = originalIn;
            final RecordReader finalOriginalRecordReader = originalRecordReader;
            final InputStream finalEnrichmentIn = enrichmentIn;
            final RecordReader finalEnrichmentRecordReader = enrichmentRecordReader;
            final RecordSet recordSet = new RecordSet(){
                private boolean usedFirstRecords = false;

                public RecordSchema getSchema() {
                    return resultSchema;
                }

                public Record next() throws IOException {
                    if (!this.usedFirstRecords) {
                        this.usedFirstRecords = true;
                        Record combined = IndexCorrelatedJoinStrategy.this.combineRecords(firstOriginalRecord, firstEnrichmentRecord, resultSchema);
                        return combined;
                    }
                    try {
                        Record originalRecord = finalOriginalRecordReader.nextRecord();
                        Record enrichmentRecord = finalEnrichmentRecordReader.nextRecord();
                        if (originalRecord == null && enrichmentRecord == null) {
                            return null;
                        }
                        Record combined = IndexCorrelatedJoinStrategy.this.combineRecords(originalRecord, enrichmentRecord, resultSchema);
                        return combined;
                    }
                    catch (MalformedRecordException e) {
                        throw new IOException("Failed to read record", e);
                    }
                }
            };
            return new RecordJoinResult(){

                @Override
                public RecordSet getRecordSet() {
                    return recordSet;
                }

                @Override
                public void close() {
                    IndexCorrelatedJoinStrategy.this.closeQuietly(new AutoCloseable[]{finalOriginalRecordReader, finalOriginalIn, finalEnrichmentRecordReader, finalEnrichmentIn});
                }
            };
        }
        catch (Throwable t) {
            this.closeQuietly(new AutoCloseable[]{originalRecordReader, originalIn, enrichmentRecordReader, enrichmentIn});
            throw t;
        }
    }

    private void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            this.closeQuietly(closeable);
        }
    }

    private void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close {}", new Object[]{closeable, e});
            }
        }
    }

    protected abstract Record combineRecords(Record var1, Record var2, RecordSchema var3);

    protected abstract RecordSchema createResultSchema(Record var1, Record var2);
}

