/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ValidateXml;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestValidateXml {
    private static final String VALID_XML = "<ns:bundle xmlns:ns=\"http://namespace/1\"><node><subNode><value>Hello</value></subNode><subNode><value>World!</value></subNode></node></ns:bundle>";
    private static final String INVALID_XML = "<this>is an invalid</xml>";
    private static final String NONCOMPLIANT_XML = "<ns:bundle xmlns:ns=\"http://namespace/1\"><this>is good XML, but violates schema</this></ns:bundle>";

    @Test
    public void testValid() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.SCHEMA_FILE, "src/test/resources/TestXml/XmlBundle.xsd");
        runner.enqueue(Paths.get("src/test/resources/TestXml/xml-snippet.xml", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_VALID, 1);
    }

    @Test
    public void testInvalid() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.SCHEMA_FILE, "src/test/resources/TestXml/XmlBundle.xsd");
        runner.enqueue(INVALID_XML);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_INVALID, 1);
        runner.assertAllFlowFilesContainAttribute(ValidateXml.REL_INVALID, "validatexml.invalid.error");
        runner.clearTransferState();
        runner.enqueue(NONCOMPLIANT_XML);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_INVALID, 1);
        runner.assertAllFlowFilesContainAttribute(ValidateXml.REL_INVALID, "validatexml.invalid.error");
    }

    @Test
    public void testValidEL() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.SCHEMA_FILE, "${my.schema}");
        runner.setVariable("my.schema", "src/test/resources/TestXml/XmlBundle.xsd");
        runner.enqueue(Paths.get("src/test/resources/TestXml/xml-snippet.xml", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_VALID, 1);
    }

    @Test
    public void testInvalidEL() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.SCHEMA_FILE, "${my.schema}");
        runner.enqueue(INVALID_XML);
        Assertions.assertThrows(AssertionError.class, () -> runner.run());
    }

    @Test
    public void testValidXMLAttributeWithSchema() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.SCHEMA_FILE, "src/test/resources/TestXml/XmlBundle.xsd");
        runner.setProperty(ValidateXml.XML_SOURCE_ATTRIBUTE, "xml.attribute");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xml.attribute", VALID_XML);
        runner.enqueue("XML is in attribute, not content", attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_VALID, 1);
    }

    @Test
    public void testInvalidXMLAttributeWithSchema() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.SCHEMA_FILE, "src/test/resources/TestXml/XmlBundle.xsd");
        runner.setProperty(ValidateXml.XML_SOURCE_ATTRIBUTE, "xml.attribute");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xml.attribute", INVALID_XML);
        runner.enqueue("flowfile content is irrelevant", attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_INVALID, 1);
        runner.assertAllFlowFilesContainAttribute(ValidateXml.REL_INVALID, "validatexml.invalid.error");
        runner.clearTransferState();
        attributes.clear();
        attributes.put("xml.attribute", NONCOMPLIANT_XML);
        runner.enqueue("flowfile content is irrelevant", attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_INVALID, 1);
        runner.assertAllFlowFilesContainAttribute(ValidateXml.REL_INVALID, "validatexml.invalid.error");
    }

    @Test
    public void testValidXMLAttributeStructure() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.XML_SOURCE_ATTRIBUTE, "xml.attribute");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xml.attribute", VALID_XML);
        runner.enqueue("XML is in attribute, not content", attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_VALID, 1);
    }

    @Test
    public void testInvalidXMLAttributeStructure() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.setProperty(ValidateXml.XML_SOURCE_ATTRIBUTE, "xml.attribute");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xml.attribute", INVALID_XML);
        runner.enqueue("XML is in attribute, not content", attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_INVALID, 1);
        runner.assertAllFlowFilesContainAttribute(ValidateXml.REL_INVALID, "validatexml.invalid.error");
    }

    @Test
    public void testValidXMLContentStructure() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.enqueue(Paths.get("src/test/resources/TestXml/xml-snippet.xml", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_VALID, 1);
    }

    @Test
    public void testInvalidXMLContentStructure() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ValidateXml());
        runner.enqueue(INVALID_XML);
        runner.run();
        runner.assertAllFlowFilesTransferred(ValidateXml.REL_INVALID, 1);
        runner.assertAllFlowFilesContainAttribute(ValidateXml.REL_INVALID, "validatexml.invalid.error");
    }
}

