/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.OutputStream;

public class SoftLimitBoundedByteArrayOutputStream
extends OutputStream {
    private final byte[] buffer;
    private int limit;
    private int count;

    public SoftLimitBoundedByteArrayOutputStream(int capacity) {
        this(capacity, capacity);
    }

    public SoftLimitBoundedByteArrayOutputStream(int capacity, int limit) {
        if (capacity < limit || (capacity | limit) < 0) {
            throw new IllegalArgumentException("Invalid capacity/limit");
        }
        this.buffer = new byte[capacity];
        this.limit = limit;
        this.count = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.limit) {
            return;
        }
        this.buffer[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.count + len > this.limit && (len = this.limit - this.count) == 0) {
            return;
        }
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    public void reset(int newlim) {
        if (newlim > this.buffer.length) {
            throw new IndexOutOfBoundsException("Limit exceeds buffer size");
        }
        this.limit = newlim;
        this.count = 0;
    }

    public void reset() {
        this.limit = this.buffer.length;
        this.count = 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int size() {
        return this.count;
    }
}

