/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.OpenPGPPasswordBasedEncryptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenPGPPasswordBasedEncryptorTest {
    private static final String FILENAME = OpenPGPPasswordBasedEncryptorTest.class.getSimpleName();
    private static final int CIPHER = 7;
    private static final byte[] PLAINTEXT = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final String PASSWORD = OpenPGPPasswordBasedEncryptorTest.class.getName();

    @Test
    public void testEncryptDecrypt() throws Exception {
        ByteArrayInputStream plainStream = new ByteArrayInputStream(PLAINTEXT);
        OpenPGPPasswordBasedEncryptor encryptor = new OpenPGPPasswordBasedEncryptor(EncryptionMethod.PGP.getAlgorithm(), Integer.valueOf(7), EncryptionMethod.PGP.getProvider(), PASSWORD.toCharArray(), FILENAME);
        StreamCallback encryptionCallback = encryptor.getEncryptionCallback();
        StreamCallback decryptionCallback = encryptor.getDecryptionCallback();
        ByteArrayOutputStream encryptedStream = new ByteArrayOutputStream();
        encryptionCallback.process((InputStream)plainStream, (OutputStream)encryptedStream);
        ByteArrayInputStream encryptedInputStream = new ByteArrayInputStream(encryptedStream.toByteArray());
        ByteArrayOutputStream decryptedStream = new ByteArrayOutputStream();
        decryptionCallback.process((InputStream)encryptedInputStream, (OutputStream)decryptedStream);
        byte[] decryptedBytes = decryptedStream.toByteArray();
        Assertions.assertArrayEquals((byte[])PLAINTEXT, (byte[])decryptedBytes);
    }
}

