/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.HashMap;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ScanAttribute;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestScanAttribute {
    @Test
    public void testSingleMatch() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ScanAttribute());
        runner.setVariable("dictionary", "src/test/resources/ScanAttribute/dictionary1");
        runner.setProperty(ScanAttribute.DICTIONARY_FILE, "${dictionary}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "world");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_MATCHED, 1);
        runner.clearTransferState();
        attributes.remove("abc");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_UNMATCHED, 1);
        runner.clearTransferState();
        attributes.put("abc", "world");
        runner.setProperty(ScanAttribute.ATTRIBUTE_PATTERN, "a.*");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_MATCHED, 1);
        runner.clearTransferState();
        runner.setProperty(ScanAttribute.ATTRIBUTE_PATTERN, "c.*");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_UNMATCHED, 1);
        runner.clearTransferState();
    }

    @Test
    public void testAllMatch() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ScanAttribute());
        runner.setProperty(ScanAttribute.DICTIONARY_FILE, "src/test/resources/ScanAttribute/dictionary1");
        runner.setProperty(ScanAttribute.MATCHING_CRITERIA, "All Must Match");
        runner.setProperty(ScanAttribute.ATTRIBUTE_PATTERN, "a.*");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "world");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_MATCHED, 1);
        runner.clearTransferState();
        attributes.remove("abc");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_MATCHED, 1);
        runner.clearTransferState();
        attributes.put("abc", "world");
        attributes.put("a world", "apart");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_UNMATCHED, 1);
        runner.clearTransferState();
        attributes.put("abc", "world");
        attributes.put("a world", "hello");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_MATCHED, 1);
    }

    @Test
    public void testWithEmptyEntries() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ScanAttribute());
        runner.setProperty(ScanAttribute.DICTIONARY_FILE, "src/test/resources/ScanAttribute/dictionary-with-empty-new-lines");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_UNMATCHED, 1);
        runner.clearTransferState();
        runner.setProperty(ScanAttribute.ATTRIBUTE_PATTERN, "a.*");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_UNMATCHED, 1);
    }

    @Test
    public void testWithDictionaryFilter() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ScanAttribute());
        runner.setProperty(ScanAttribute.DICTIONARY_FILE, "src/test/resources/ScanAttribute/dictionary-with-extra-info");
        runner.setProperty(ScanAttribute.DICTIONARY_FILTER, "(.*)<greeting>");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "hello");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_MATCHED, 1);
        runner.clearTransferState();
        attributes.put("abc", "world");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_UNMATCHED, 1);
        runner.clearTransferState();
        runner.setProperty(ScanAttribute.DICTIONARY_FILTER, "(.*)<.*>");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(ScanAttribute.REL_MATCHED, 1);
        runner.clearTransferState();
    }
}

