/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.DebugFlow;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDebugFlow {
    private DebugFlow debugFlow;
    private TestRunner runner;
    private ProcessSession session;
    private final Map<Integer, String> contents = new HashMap<Integer, String>();
    private final Map<Integer, Map<String, String>> attribs = new HashMap<Integer, Map<String, String>>();
    private Map<String, String> namesToContent = new HashMap<String, String>();

    @BeforeEach
    public void setup() throws IOException {
        for (int n = 0; n < 6; ++n) {
            String filename = "testFile" + (n + 1) + ".txt";
            String content = "Hello World " + (n + 1) + "!";
            this.contents.put(n, content);
            this.attribs.put(n, new HashMap());
            this.attribs.get(n).put(CoreAttributes.FILENAME.key(), filename);
            this.attribs.get(n).put(CoreAttributes.UUID.key(), "TESTING-FILE-" + (n + 1) + "-TESTING");
            this.namesToContent.put(filename, content);
        }
        this.debugFlow = new DebugFlow();
        this.runner = TestRunners.newTestRunner((Processor)this.debugFlow);
        this.session = this.runner.getProcessSessionFactory().createSession();
        this.runner.setProperty(DebugFlow.FF_SUCCESS_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.FF_FAILURE_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_YIELD_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_PENALTY_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.NO_FF_SKIP_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_ITERATIONS, "0");
        this.runner.setProperty(DebugFlow.NO_FF_YIELD_ITERATIONS, "0");
    }

    private boolean isInContents(byte[] content) {
        return this.contents.containsValue(new String(content));
    }

    @Test
    public void testFlowFileSuccess() {
        this.runner.setProperty(DebugFlow.FF_SUCCESS_ITERATIONS, "1");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        this.runner.run(7);
        this.runner.assertTransferCount(DebugFlow.REL_SUCCESS, 6);
        this.runner.assertTransferCount(DebugFlow.REL_FAILURE, 0);
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(0)).toByteArray()));
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(1)).toByteArray()));
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(2)).toByteArray()));
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(3)).toByteArray()));
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(4)).toByteArray()));
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(5)).toByteArray()));
    }

    @Test
    public void testFlowFileFailure() {
        this.runner.setProperty(DebugFlow.FF_FAILURE_ITERATIONS, "1");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        this.runner.run(7);
        this.runner.assertTransferCount(DebugFlow.REL_SUCCESS, 0);
        this.runner.assertTransferCount(DebugFlow.REL_FAILURE, 6);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(0)).assertContentEquals(this.contents.get(0));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(1)).assertContentEquals(this.contents.get(1));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(2)).assertContentEquals(this.contents.get(2));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(3)).assertContentEquals(this.contents.get(3));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(4)).assertContentEquals(this.contents.get(4));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(5)).assertContentEquals(this.contents.get(5));
    }

    @Test
    public void testFlowFileSuccessAndFailure() {
        this.runner.setProperty(DebugFlow.FF_SUCCESS_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_FAILURE_ITERATIONS, "1");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        this.runner.run(7);
        this.runner.assertTransferCount(DebugFlow.REL_SUCCESS, 3);
        this.runner.assertTransferCount(DebugFlow.REL_FAILURE, 3);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(0)).assertContentEquals(this.contents.get(0));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(0)).assertContentEquals(this.contents.get(1));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(1)).assertContentEquals(this.contents.get(2));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(1)).assertContentEquals(this.contents.get(3));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(2)).assertContentEquals(this.contents.get(4));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(2)).assertContentEquals(this.contents.get(5));
    }

    @Test
    public void testFlowFileRollback() throws IOException {
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_ITERATIONS, "1");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        this.runner.run(7);
        this.runner.assertTransferCount(DebugFlow.REL_SUCCESS, 0);
        this.runner.assertTransferCount(DebugFlow.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        Assertions.assertEquals((int)6, (int)this.runner.getQueueSize().getObjectCount());
        MockFlowFile ff1 = (MockFlowFile)this.session.get();
        Assertions.assertNotNull((Object)ff1);
        Assertions.assertEquals((Object)this.namesToContent.get(ff1.getAttribute(CoreAttributes.FILENAME.key())), (Object)new String(ff1.toByteArray()));
        this.session.rollback();
    }

    @Test
    public void testFlowFileRollbackYield() {
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_YIELD_ITERATIONS, "1");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        this.runner.run(7);
        this.runner.assertTransferCount(DebugFlow.REL_SUCCESS, 0);
        this.runner.assertTransferCount(DebugFlow.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        Assertions.assertEquals((int)6, (int)this.runner.getQueueSize().getObjectCount());
    }

    @Test
    public void testFlowFileRollbackPenalty() {
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_PENALTY_ITERATIONS, "1");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        this.runner.run(7);
        this.runner.assertTransferCount(DebugFlow.REL_SUCCESS, 0);
        this.runner.assertTransferCount(DebugFlow.REL_FAILURE, 0);
        this.runner.assertQueueNotEmpty();
        Assertions.assertEquals((int)6, (int)this.runner.getQueueSize().getObjectCount());
    }

    @Test
    public void testFlowFileDefaultException() {
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_ITERATIONS, "1");
        this.runner.assertValid();
        this.runner.enqueue(this.contents.get(0).getBytes(), this.attribs.get(0));
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.runner.run(2)));
        Assertions.assertInstanceOf(RuntimeException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("forced by org.apache.nifi.processors.standard.DebugFlow"));
    }

    @Test
    public void testFlowFileNonDefaultException() {
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_CLASS, "java.lang.RuntimeException");
        this.runner.assertValid();
        this.runner.enqueue(this.contents.get(0).getBytes(), this.attribs.get(0));
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.runner.run(2)));
        Assertions.assertInstanceOf(RuntimeException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("forced by org.apache.nifi.processors.standard.DebugFlow"));
    }

    @Test
    public void testFlowFileNPEException() {
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_CLASS, "java.lang.NullPointerException");
        this.runner.assertValid();
        this.runner.enqueue(this.contents.get(0).getBytes(), this.attribs.get(0));
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.runner.run(2)));
        Assertions.assertInstanceOf(NullPointerException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("forced by org.apache.nifi.processors.standard.DebugFlow"));
    }

    @Test
    public void testFlowFileBadException() {
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_CLASS, "java.lang.NonExistantException");
        this.runner.assertNotValid();
    }

    @Test
    public void testFlowFileExceptionRollover() {
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_ITERATIONS, "2");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.runner.run(8)));
        Assertions.assertInstanceOf(RuntimeException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("forced by org.apache.nifi.processors.standard.DebugFlow"));
    }

    @Test
    public void testFlowFileAll() {
        this.runner.setProperty(DebugFlow.FF_SUCCESS_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_FAILURE_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_YIELD_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_ROLLBACK_PENALTY_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.FF_EXCEPTION_ITERATIONS, "1");
        this.runner.assertValid();
        for (int n = 0; n < 6; ++n) {
            this.runner.enqueue(this.contents.get(n).getBytes(), this.attribs.get(n));
        }
        this.runner.run(5);
        this.runner.assertTransferCount(DebugFlow.REL_SUCCESS, 1);
        this.runner.assertTransferCount(DebugFlow.REL_FAILURE, 1);
        Assertions.assertEquals((int)4, (int)this.runner.getQueueSize().getObjectCount());
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_SUCCESS).get(0)).toByteArray()));
        Assertions.assertTrue((boolean)this.isInContents(((MockFlowFile)this.runner.getFlowFilesForRelationship(DebugFlow.REL_FAILURE).get(0)).toByteArray()));
        this.runner.run(2);
    }

    @Test
    public void testNoFlowFileZeroIterations() {
        this.runner.run(4);
    }

    @Test
    public void testNoFlowFileSkip() {
        this.runner.setProperty(DebugFlow.NO_FF_SKIP_ITERATIONS, "1");
        this.runner.assertValid();
        this.runner.run(4);
    }

    @Test
    public void testNoFlowFileDefaultException() {
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_ITERATIONS, "1");
        this.runner.assertValid();
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.runner.run(3)));
        Assertions.assertInstanceOf(RuntimeException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("forced by org.apache.nifi.processors.standard.DebugFlow"));
    }

    @Test
    public void testNoFlowFileNonDefaultException() {
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_CLASS, "java.lang.RuntimeException");
        this.runner.assertValid();
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.runner.run(3)));
        Assertions.assertInstanceOf(RuntimeException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("forced by org.apache.nifi.processors.standard.DebugFlow"));
    }

    @Test
    public void testNoFlowFileOtherException() {
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_CLASS, "java.lang.NullPointerException");
        this.runner.assertValid();
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.runner.run(3)));
        Assertions.assertInstanceOf(NullPointerException.class, (Object)((Throwable)((Object)e)).getCause());
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("forced by org.apache.nifi.processors.standard.DebugFlow"));
    }

    @Test
    public void testNoFlowFileBadException() {
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_ITERATIONS, "1");
        this.runner.setProperty(DebugFlow.NO_FF_EXCEPTION_CLASS, "java.lang.NonExistantException");
        this.runner.assertNotValid();
    }

    @Test
    public void testNoFlowFileYield() {
        this.runner.setProperty(DebugFlow.NO_FF_YIELD_ITERATIONS, "1");
        this.runner.assertValid();
        this.runner.run(4);
    }
}

