/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.TableSchema;

public class DerbyDatabaseAdapter
implements DatabaseAdapter {
    public String getName() {
        return "Derby";
    }

    public String getDescription() {
        return "Generates Derby compatible SQL (used for testing)";
    }

    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        return this.getSelectStatement(tableName, columnNames, whereClause, orderByClause, limit, offset, null);
    }

    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset, String columnForPartitioning) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
            if (!StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
                query.append(" AND ");
                query.append(columnForPartitioning);
                query.append(" >= ");
                query.append(offset != null ? offset : "0");
                if (limit != null) {
                    query.append(" AND ");
                    query.append(columnForPartitioning);
                    query.append(" < ");
                    query.append((offset == null ? 0L : offset) + limit);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause) && StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            if (offset != null && offset > 0L) {
                query.append(" OFFSET ");
                query.append(offset);
                query.append(" ROWS");
            }
            if (limit != null) {
                query.append(" FETCH NEXT ");
                query.append(limit);
                query.append(" ROWS ONLY");
            }
        }
        return query.toString();
    }

    public boolean supportsCreateTableIfNotExists() {
        return true;
    }

    public String getCreateTableStatement(TableSchema tableSchema, boolean quoteTableName, boolean quoteColumnNames) {
        StringBuilder createTableStatement = new StringBuilder();
        List columns = tableSchema.getColumnsAsList();
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columns.size());
        Set primaryKeyColumnNames = tableSchema.getPrimaryKeyColumnNames();
        for (ColumnDescription column : columns) {
            StringBuilder sb = new StringBuilder().append(quoteColumnNames ? this.getColumnQuoteString() : "").append(column.getColumnName()).append(quoteColumnNames ? this.getColumnQuoteString() : "").append(" ").append(this.getSQLForDataType(column.getDataType())).append(column.isNullable() ? "" : " NOT NULL").append(primaryKeyColumnNames != null && primaryKeyColumnNames.contains(column.getColumnName()) ? " PRIMARY KEY" : "");
            columnsAndDatatypes.add(sb.toString());
        }
        createTableStatement.append("CREATE TABLE ").append(quoteTableName ? this.getTableQuoteString() : "").append(tableSchema.getTableName()).append(quoteTableName ? this.getTableQuoteString() : "").append(" (").append(String.join((CharSequence)", ", columnsAndDatatypes)).append(") ");
        return createTableStatement.toString();
    }

    public List<String> getAlterTableStatements(String tableName, List<ColumnDescription> columnsToAdd, boolean quoteTableName, boolean quoteColumnNames) {
        ArrayList<String> alterTableStatements = new ArrayList<String>();
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columnsToAdd.size());
        for (ColumnDescription column : columnsToAdd) {
            String dataType = this.getSQLForDataType(column.getDataType());
            StringBuilder sb = new StringBuilder().append(quoteColumnNames ? this.getColumnQuoteString() : "").append(column.getColumnName()).append(quoteColumnNames ? this.getColumnQuoteString() : "").append(" ").append(dataType);
            columnsAndDatatypes.add(sb.toString());
        }
        for (String columnAndDataType : columnsAndDatatypes) {
            StringBuilder createTableStatement = new StringBuilder();
            alterTableStatements.add(createTableStatement.append("ALTER TABLE ").append(quoteTableName ? this.getTableQuoteString() : "").append(tableName).append(quoteTableName ? this.getTableQuoteString() : "").append(" ADD COLUMN ").append(columnAndDataType).toString());
        }
        return alterTableStatements;
    }

    public String getSQLForDataType(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: 
            case 2009: 
            case 2011: {
                return "VARCHAR(100)";
            }
        }
        return JDBCType.valueOf(sqlType).getName();
    }
}

