/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.SimpleKeyValueLookupService;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.LookupAttribute;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLookupAttribute {
    @Test
    public void testKeyValueLookupAttribute() throws InitializationException {
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        TestRunner runner = TestRunners.newTestRunner((Processor)new LookupAttribute());
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.setProperty((ControllerService)service, "key1", "value1");
        runner.setProperty((ControllerService)service, "key2", "value2");
        runner.setProperty((ControllerService)service, "key3", "value3");
        runner.setProperty((ControllerService)service, "key4", "  ");
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(LookupAttribute.LOOKUP_SERVICE, "simple-key-value-lookup-service");
        runner.setProperty(LookupAttribute.INCLUDE_EMPTY_VALUES, "true");
        runner.setProperty("foo", "key1");
        runner.setProperty("bar", "key2");
        runner.setProperty("baz", "${attr1}");
        runner.setProperty("qux", "key4");
        runner.setProperty("zab", "key5");
        runner.assertValid();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("attr1", "key3");
        runner.enqueue("some content".getBytes(), attributes);
        runner.run(1, false);
        runner.assertAllFlowFilesTransferred(LookupAttribute.REL_MATCHED, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(LookupAttribute.REL_MATCHED).get(0);
        Assertions.assertNotNull((Object)flowFile);
        flowFile.assertAttributeExists("foo");
        flowFile.assertAttributeExists("bar");
        flowFile.assertAttributeExists("baz");
        flowFile.assertAttributeExists("qux");
        flowFile.assertAttributeExists("zab");
        flowFile.assertAttributeNotExists("zar");
        flowFile.assertAttributeEquals("foo", "value1");
        flowFile.assertAttributeEquals("bar", "value2");
        flowFile.assertAttributeEquals("baz", "value3");
        flowFile.assertAttributeEquals("qux", "");
        flowFile.assertAttributeEquals("zab", "null");
    }

    @Test
    public void testLookupAttributeUnmatched() throws InitializationException {
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        TestRunner runner = TestRunners.newTestRunner((Processor)new LookupAttribute());
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.setProperty((ControllerService)service, "key1", "value1");
        runner.setProperty((ControllerService)service, "key2", "value2");
        runner.setProperty((ControllerService)service, "key3", "value3");
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(LookupAttribute.LOOKUP_SERVICE, "simple-key-value-lookup-service");
        runner.setProperty(LookupAttribute.INCLUDE_EMPTY_VALUES, "false");
        runner.setProperty("baz", "${attr1}");
        runner.assertValid();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("attr1", "key4");
        runner.enqueue("some content".getBytes(), attributes);
        runner.run(1, false);
        runner.assertAllFlowFilesTransferred(LookupAttribute.REL_UNMATCHED, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(LookupAttribute.REL_UNMATCHED).get(0);
        Assertions.assertNotNull((Object)flowFile);
        flowFile.assertAttributeExists("attr1");
        flowFile.assertAttributeNotExists("baz");
        flowFile.assertAttributeEquals("attr1", "key4");
    }

    @Test
    public void testCustomValidateInvalidLookupService() throws InitializationException {
        InvalidLookupService service = new InvalidLookupService();
        TestRunner runner = TestRunners.newTestRunner((Processor)new LookupAttribute());
        runner.addControllerService("invalid-lookup-service", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(LookupAttribute.LOOKUP_SERVICE, "invalid-lookup-service");
        runner.setProperty("foo", "key1");
        runner.assertNotValid();
    }

    @Test
    public void testCustomValidateMissingDynamicProps() throws InitializationException {
        SimpleKeyValueLookupService service = new SimpleKeyValueLookupService();
        TestRunner runner = TestRunners.newTestRunner((Processor)new LookupAttribute());
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(LookupAttribute.LOOKUP_SERVICE, "simple-key-value-lookup-service");
        runner.assertNotValid();
    }

    @Test
    public void testLookupServicePassFlowfileAttributes() throws InitializationException {
        TestService service = new TestService();
        TestRunner runner = TestRunners.newTestRunner((Processor)new LookupAttribute());
        runner.addControllerService("simple-key-value-lookup-service", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.assertValid((ControllerService)service);
        runner.setProperty(LookupAttribute.LOOKUP_SERVICE, "simple-key-value-lookup-service");
        runner.setProperty(LookupAttribute.INCLUDE_EMPTY_VALUES, "false");
        runner.setProperty("baz", "${attr1}");
        runner.assertValid();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("user_defined", "key4");
        runner.enqueue("some content".getBytes(), attributes);
        runner.run(1, false);
        runner.assertAllFlowFilesTransferred(LookupAttribute.REL_MATCHED, 1);
    }

    static class TestService
    extends AbstractControllerService
    implements StringLookupService {
        TestService() {
        }

        public Optional<String> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
            Assertions.assertNotNull(coordinates);
            Assertions.assertNotNull(context);
            Assertions.assertEquals((int)1, (int)coordinates.size());
            Assertions.assertTrue((boolean)context.containsKey("user_defined"));
            return Optional.of("Test!");
        }

        public Optional<String> lookup(Map<String, Object> coordinates) throws LookupFailureException {
            return Optional.empty();
        }

        public Class<?> getValueType() {
            return String.class;
        }

        public Set<String> getRequiredKeys() {
            HashSet<String> set = new HashSet<String>();
            set.add("key");
            return set;
        }
    }

    private static class InvalidLookupService
    extends AbstractControllerService
    implements StringLookupService {
        private InvalidLookupService() {
        }

        public Optional<String> lookup(Map<String, Object> coordinates) {
            return Optional.empty();
        }

        public Set<String> getRequiredKeys() {
            HashSet<String> requiredKeys = new HashSet<String>();
            requiredKeys.add("key1");
            requiredKeys.add("key2");
            return Collections.unmodifiableSet(requiredKeys);
        }
    }
}

