/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.EvaluateXQuery;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateXQuery {
    private static final Path XML_SNIPPET = Paths.get("src/test/resources/TestXml/fruit.xml", new String[0]);
    private static final Path XML_SNIPPET_EMBEDDED_DOCTYPE = Paths.get("src/test/resources/TestXml/xml-snippet-embedded-doctype.xml", new String[0]);
    private static final Path XML_SNIPPET_NONEXISTENT_DOCTYPE = Paths.get("src/test/resources/TestXml/xml-snippet-external-doctype.xml", new String[0]);
    private static final String[] fruitNames = new String[]{"apple", "apple", "banana", "orange", "blueberry", "raspberry", "none"};
    private static final String[] methods = new String[]{"xml", "html", "text"};
    private static final boolean[] booleans = new boolean[]{true, false};

    @Test
    public void testFormatting() throws Exception {
        List<String> formattedResults;
        String atomicQuery = "count(//fruit)";
        String singleElementNodeQuery = "//fruit[1]";
        String singleTextNodeQuery = "//fruit[1]/name/text()";
        for (String method : methods) {
            for (boolean indent : booleans) {
                for (boolean omitDeclaration : booleans) {
                    formattedResults = this.getFormattedResult(XML_SNIPPET, "count(//fruit)", method, indent, omitDeclaration);
                    Assertions.assertEquals((int)1, (int)formattedResults.size());
                    Assertions.assertEquals((Object)"7", (Object)formattedResults.get(0));
                }
            }
        }
        for (String method : methods) {
            for (boolean indent : booleans) {
                for (boolean omitDeclaration : booleans) {
                    formattedResults = this.getFormattedResult(XML_SNIPPET, "//fruit[1]/name/text()", method, indent, omitDeclaration);
                    Assertions.assertEquals((int)1, (int)formattedResults.size());
                    Assertions.assertEquals((Object)"apple", (Object)formattedResults.get(0));
                }
            }
        }
        formattedResults = this.getFormattedResult(XML_SNIPPET, "//fruit[1]", "xml", false, false);
        Assertions.assertEquals((int)1, (int)formattedResults.size());
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\">\n<!-- Apples are my favorite -->\n    <name>apple</name>\n    <color>red</color>\n  </fruit>";
        Assertions.assertEquals((Object)this.spaceTrimmed(expectedXml), (Object)this.spaceTrimmed(formattedResults.get(0)));
        formattedResults = this.getFormattedResult(XML_SNIPPET, "//fruit[1]", "html", false, false);
        Assertions.assertEquals((int)1, (int)formattedResults.size());
        expectedXml = "<fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\">\n    <!-- Apples are my favorite -->\n    <name>apple</name>\n    <color>red</color>\n  </fruit>";
        Assertions.assertEquals((Object)this.spaceTrimmed(expectedXml), (Object)this.spaceTrimmed(formattedResults.get(0)));
        formattedResults = this.getFormattedResult(XML_SNIPPET, "//fruit[1]", "text", false, false);
        Assertions.assertEquals((int)1, (int)formattedResults.size());
        expectedXml = "\n    \n    apple\n    red\n  ";
        Assertions.assertEquals((Object)this.spaceTrimmed(expectedXml), (Object)this.spaceTrimmed(formattedResults.get(0)));
        formattedResults = this.getFormattedResult(XML_SNIPPET, "//fruit[1]", "xml", true, false);
        Assertions.assertEquals((int)1, (int)formattedResults.size());
        expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\">\n    <!-- Apples are my favorite -->\n    <name>apple</name>\n    <color>red</color>\n  </fruit>\n";
        Assertions.assertEquals((Object)this.spaceTrimmed(expectedXml), (Object)this.spaceTrimmed(formattedResults.get(0)));
        formattedResults = this.getFormattedResult(XML_SNIPPET, "//fruit[1]", "xml", true, true);
        Assertions.assertEquals((int)1, (int)formattedResults.size());
        expectedXml = "<fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\">\n    <!-- Apples are my favorite -->\n    <name>apple</name>\n    <color>red</color>\n  </fruit>\n";
        Assertions.assertEquals((Object)this.spaceTrimmed(expectedXml), (Object)this.spaceTrimmed(formattedResults.get(0)));
    }

    private String spaceTrimmed(String str) {
        return Arrays.stream(str.split("\n")).map(String::trim).reduce("", String::concat);
    }

    private List<String> getFormattedResult(Path xml, String xQuery, String method, boolean indent, boolean omitDeclaration) throws Exception {
        HashMap<String, String> runnerProps = new HashMap<String, String>();
        ArrayList<String> resultStrings = new ArrayList<String>();
        runnerProps.put(EvaluateXQuery.DESTINATION.getName(), "flowfile-content");
        runnerProps.put(EvaluateXQuery.XML_OUTPUT_METHOD.getName(), method);
        runnerProps.put(EvaluateXQuery.XML_OUTPUT_INDENT.getName(), Boolean.toString(indent));
        runnerProps.put(EvaluateXQuery.XML_OUTPUT_OMIT_XML_DECLARATION.getName(), Boolean.toString(omitDeclaration));
        runnerProps.put("xquery", xQuery);
        List<MockFlowFile> resultFlowFiles = this.runXquery(xml, runnerProps);
        for (MockFlowFile flowFile : resultFlowFiles) {
            byte[] outData = flowFile.toByteArray();
            String outXml = new String(outData, StandardCharsets.UTF_8);
            resultStrings.add(outXml);
        }
        return resultStrings;
    }

    @Test
    public void testBadXQuery() {
        Assertions.assertThrows(AssertionError.class, () -> this.doXqueryTest(XML_SNIPPET, "counttttttt(*:fruitbasket/fruit)", Collections.singletonList("7")));
    }

    @Test
    public void testXQueries() throws Exception {
        this.doXqueryTest(XML_SNIPPET, "count(*:fruitbasket/fruit)", Collections.singletonList("7"));
        this.doXqueryTest(XML_SNIPPET, "count(//fruit)", Collections.singletonList("7"));
        this.doXqueryTest(XML_SNIPPET, "declare namespace fb = \"http://namespace/1\"; count(fb:fruitbasket/fruit)", Collections.singletonList("7"));
        this.doXqueryTest(XML_SNIPPET, "boolean(//fruit[1])", Collections.singletonList("true"));
        this.doXqueryTest(XML_SNIPPET, "boolean(//fruit[100])", Collections.singletonList("false"));
        this.doXqueryTest(XML_SNIPPET, "//fruit[1]", Collections.singletonList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\"><!-- Apples are my favorite --><name>apple</name><color>red</color></fruit>"));
        this.doXqueryTest(XML_SNIPPET, "//fruit[count(//fruit)]", Collections.singletonList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\"><name>none</name><color/></fruit>"));
        this.doXqueryTest(XML_SNIPPET, "<wrap>{//fruit[1]}</wrap>", Collections.singletonList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><wrap><fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\"><!-- Apples are my favorite --><name>apple</name><color>red</color></fruit></wrap>"));
        this.doXqueryTest(XML_SNIPPET, "//fruit", Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\"><!-- Apples are my favorite --><name>apple</name><color>red</color></fruit>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\"><name>apple</name><color>green</color></fruit>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\"><name>banana</name><color>yellow</color></fruit>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\" taste=\"sweet\"><name>orange</name><color>orange</color></fruit>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\"><name>blueberry</name><color>blue</color></fruit>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\" taste=\"tart\"><name>raspberry</name><color>red</color></fruit>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruit xmlns:ns=\"http://namespace/1\"><name>none</name><color/></fruit>"));
        this.doXqueryTest(XML_SNIPPET, "<wrap>{//fruit}</wrap>", Collections.singletonList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><wrap><fruit xmlns:ns=\"http://namespace/1\" taste=\"crisp\"><!-- Apples are my favorite --><name>apple</name><color>red</color></fruit><fruit xmlns:ns=\"http://namespace/1\"><name>apple</name><color>green</color></fruit><fruit xmlns:ns=\"http://namespace/1\"><name>banana</name><color>yellow</color></fruit><fruit xmlns:ns=\"http://namespace/1\" taste=\"sweet\"><name>orange</name><color>orange</color></fruit><fruit xmlns:ns=\"http://namespace/1\"><name>blueberry</name><color>blue</color></fruit><fruit xmlns:ns=\"http://namespace/1\" taste=\"tart\"><name>raspberry</name><color>red</color></fruit><fruit xmlns:ns=\"http://namespace/1\"><name>none</name><color/></fruit></wrap>"));
        this.doXqueryTest(XML_SNIPPET, "for $x in //fruit return $x/name/text()", Arrays.asList(fruitNames));
        this.doXqueryTest(XML_SNIPPET, "//fruit[1]/name/text()", Collections.singletonList("apple"));
        this.doXqueryTest(XML_SNIPPET, "//fruit[1]/color/text()", Collections.singletonList("red"));
        this.doXqueryTest(XML_SNIPPET, "for $x in //fruit[1] return string-join(($x/name/text() , $x/color/text()), ' - ')", Collections.singletonList("apple - red"));
        this.doXqueryTest(XML_SNIPPET, "for $x in //fruit[1] return string-join(($x/name/text() , $x/color/text()), ' - ')", Collections.singletonList("apple - red"));
        this.doXqueryTest(XML_SNIPPET, "for $x in //fruit return string-join(($x/name/text() , $x/color/text()), ' - ')", Arrays.asList("apple - red", "apple - green", "banana - yellow", "orange - orange", "blueberry - blue", "raspberry - red", "none"));
        this.doXqueryTest(XML_SNIPPET, "string-join((for $y in (for $x in //fruit return string-join(($x/name/text() , $x/color/text()), ' - ')) return $y), '\n')", Collections.singletonList("apple - red\napple - green\nbanana - yellow\norange - orange\nblueberry - blue\nraspberry - red\nnone"));
        this.doXqueryTest(XML_SNIPPET, "string-join((for $y in (for $x in //fruit let $d := string-join(($x/name/text() , $x/color/text()), ' - ')  return $d) return $y), '\n')", Collections.singletonList("apple - red\napple - green\nbanana - yellow\norange - orange\nblueberry - blue\nraspberry - red\nnone"));
        this.doXqueryTest(XML_SNIPPET, "string-join((for $x in //fruit return $x/name/text()), ', ')", Collections.singletonList("apple, apple, banana, orange, blueberry, raspberry, none"));
        this.doXqueryTest(XML_SNIPPET, "string-join((for $y in (for $x in //fruit return string-join(($x/color/text() , $x/name/text()), ' ')) return $y), ', ')", Collections.singletonList("red apple, green apple, yellow banana, orange orange, blue blueberry, red raspberry, none"));
        this.doXqueryTest(XML_SNIPPET, "string-join((for $y in (for $x in //fruit let $d := string-join(($x/color/text() , $x/name/text()), ' ')  return $d) return $y), ', ')", Collections.singletonList("red apple, green apple, yellow banana, orange orange, blue blueberry, red raspberry, none"));
        this.doXqueryTest(XML_SNIPPET, "string(//fruit[1]/@taste)", Collections.singletonList("crisp"));
        this.doXqueryTest(XML_SNIPPET, "//fruit/comment()", Collections.singletonList(" Apples are my favorite "));
        this.doXqueryTest(XML_SNIPPET, "//processing-instruction()[name()='xml-stylesheet']", Collections.singletonList("type=\"text/xsl\" href=\"foo.xsl\""));
    }

    private void doXqueryTest(Path xml, String xQuery, List<String> expectedResults) throws Exception {
        int i;
        HashMap<String, String> runnerProps = new HashMap<String, String>();
        runnerProps.put(EvaluateXQuery.DESTINATION.getName(), "flowfile-attribute");
        runnerProps.put("xquery", xQuery);
        List<MockFlowFile> resultFlowFiles = this.runXquery(xml, runnerProps);
        Assertions.assertEquals((int)1, (int)resultFlowFiles.size());
        MockFlowFile out = resultFlowFiles.get(0);
        for (i = 0; i < expectedResults.size(); ++i) {
            Object key = "xquery";
            if (expectedResults.size() > 1) {
                key = (String)key + "." + (i + 1);
            }
            String actual = out.getAttribute((String)key).replaceAll(">\\s+<", "><");
            String expected = expectedResults.get(i).replaceAll(">\\s+<", "><");
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
        runnerProps.clear();
        runnerProps.put(EvaluateXQuery.DESTINATION.getName(), "flowfile-content");
        runnerProps.put("xquery", xQuery);
        resultFlowFiles = this.runXquery(xml, runnerProps);
        Assertions.assertEquals((int)expectedResults.size(), (int)resultFlowFiles.size());
        for (i = 0; i < resultFlowFiles.size(); ++i) {
            MockFlowFile resultFlowFile = resultFlowFiles.get(i);
            byte[] outData = resultFlowFile.toByteArray();
            String outXml = new String(outData, StandardCharsets.UTF_8).replaceAll(">\\s+<", "><");
            String expected = expectedResults.get(i).replaceAll(">\\s+<", "><");
            Assertions.assertEquals((Object)expected, (Object)outXml);
        }
    }

    private List<MockFlowFile> runXquery(Path xml, Map<String, String> runnerProps) throws Exception {
        return this.runXquery(xml, runnerProps, new HashMap<String, String>());
    }

    private List<MockFlowFile> runXquery(Path xml, Map<String, String> runnerProps, Map<String, String> flowFileAttributes) throws Exception {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        for (Map.Entry<String, String> entry : runnerProps.entrySet()) {
            testRunner.setProperty(entry.getKey(), entry.getValue());
        }
        testRunner.enqueue(xml, flowFileAttributes);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH);
        return testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH);
    }

    @Test
    public void testRootPath() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("xquery.result1", "/");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        String attributeString = out.getAttribute("xquery.result1").replaceAll(">\\s+<", "><");
        String xmlSnippetString = new String(Files.readAllBytes(XML_SNIPPET), StandardCharsets.UTF_8).replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)xmlSnippetString, (Object)attributeString);
    }

    @Test
    public void testCheckIfElementExists() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("xquery.result.exist.1", "boolean(/*:fruitbasket/fruit[1])");
        testRunner.setProperty("xquery.result.exist.2", "boolean(/*:fruitbasket/fruit[100])");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        out.assertAttributeEquals("xquery.result.exist.1", "true");
        out.assertAttributeEquals("xquery.result.exist.2", "false");
    }

    @Test
    public void testUnmatchedContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty("xquery.result.exist.2", "/*:fruitbasket/node2");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_NO_MATCH, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_NO_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testUnmatchedAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("xquery.result.exist.2", "/*:fruitbasket/node2");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_NO_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_NO_MATCH).get(0);
        out.assertAttributeEquals("xquery.result.exist.2", null);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_NO_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testNoXQueryAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_NO_MATCH, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_NO_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testNoXQueryContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.enqueue(XML_SNIPPET);
        Assertions.assertThrows(AssertionError.class, () -> ((TestRunner)testRunner).run());
    }

    @Test
    public void testOneMatchOneUnmatchAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("some.property", "//fruit/name/text()");
        testRunner.setProperty("xquery.result.exist.2", "/*:fruitbasket/node2");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        for (int i = 0; i < fruitNames.length; ++i) {
            String outXml = out.getAttribute("some.property." + (i + 1));
            Assertions.assertEquals((Object)fruitNames[i], (Object)outXml.trim());
        }
        out.assertAttributeEquals("xquery.result.exist.2", null);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testMatchedEmptyStringAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("xquery.result.exist.2", "/*:fruitbasket/*[name='none']/color/text()");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_NO_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_NO_MATCH).get(0);
        out.assertAttributeEquals("xquery.result.exist.2", null);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_NO_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testMultipleXPathForContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property.1", "/*:fruitbasket/fruit[1]");
        testRunner.setProperty("some.property.2", "/*:fruitbasket/fruit[2]");
        testRunner.enqueue(XML_SNIPPET);
        Assertions.assertThrows(AssertionError.class, () -> ((TestRunner)testRunner).run());
    }

    @Test
    public void testWriteStringToAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("xquery.result2", "/*:fruitbasket/fruit[1]/name/text()");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        out.assertAttributeEquals("xquery.result2", "apple");
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testWriteStringToContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property", "/*:fruitbasket/fruit[1]/name/text()");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        out.assertContentEquals("apple");
    }

    @Test
    public void testWriteXmlToAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("some.property", "/*:fruitbasket/fruit[1]/name");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        String outXml = out.getAttribute("some.property");
        Assertions.assertTrue((boolean)outXml.contains("<name xmlns:ns=\"http://namespace/1\">apple</name>"));
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testWriteXmlToContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property", "/*:fruitbasket/fruit[1]/name");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        byte[] outData = testRunner.getContentAsByteArray(out);
        String outXml = new String(outData, StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)outXml.contains("<name xmlns:ns=\"http://namespace/1\">apple</name>"));
    }

    @Test
    public void testMatchesMultipleStringContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property", "//fruit/name/text()");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 7);
        List flowFilesForRelMatch = testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH);
        for (int i = 0; i < flowFilesForRelMatch.size(); ++i) {
            MockFlowFile out = (MockFlowFile)flowFilesForRelMatch.get(i);
            out.assertContentEquals(fruitNames[i]);
        }
    }

    @Test
    public void testMatchesMultipleStringAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("some.property", "//fruit/name/text()");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        for (int i = 0; i < fruitNames.length; ++i) {
            String outXml = out.getAttribute("some.property." + (i + 1));
            Assertions.assertEquals((Object)fruitNames[i], (Object)outXml.trim());
        }
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testMatchesMultipleXmlContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property", "//fruit/name");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 7);
        List flowFilesForRelMatch = testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH);
        for (int i = 0; i < flowFilesForRelMatch.size(); ++i) {
            MockFlowFile out = (MockFlowFile)flowFilesForRelMatch.get(i);
            byte[] outData = testRunner.getContentAsByteArray(out);
            String outXml = new String(outData, StandardCharsets.UTF_8);
            String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><name xmlns:ns=\"http://namespace/1\">" + fruitNames[i] + "</name>";
            Assertions.assertEquals((Object)expectedXml, (Object)outXml.trim());
        }
    }

    @Test
    public void testMatchesMultipleXmlAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("some.property", "//fruit/name");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        for (int i = 0; i < fruitNames.length; ++i) {
            String outXml = out.getAttribute("some.property." + (i + 1));
            String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><name xmlns:ns=\"http://namespace/1\">" + fruitNames[i] + "</name>";
            Assertions.assertEquals((Object)expectedXml, (Object)outXml.trim());
        }
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testSuccessForEmbeddedDocTypeValidation() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXQuery.VALIDATE_DTD, "true");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_EMBEDDED_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXQuery.REL_MATCH).get(0);
        out.assertContentEquals("Hello");
    }

    @Test
    public void testFailureForEmbeddedDocTypeValidationDisabled() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXQuery.VALIDATE_DTD, "false");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_EMBEDDED_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_FAILURE, 1);
    }

    @Test
    public void testFailureForExternalDocTypeWithDocTypeValidationEnabled() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_NONEXISTENT_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_FAILURE, 1);
    }

    @Test
    public void testFailureForExternalDocTypeWithDocTypeValidationDisabled() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXQuery());
        testRunner.setProperty(EvaluateXQuery.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXQuery.VALIDATE_DTD, "false");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_NONEXISTENT_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXQuery.REL_FAILURE, 1);
    }
}

