/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp;

import java.util.Collections;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.standard.ftp.StandardFTPClientProvider;
import org.apache.nifi.processors.standard.socket.ClientConnectException;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.remote.io.socket.NetworkUtils;
import org.apache.nifi.util.MockPropertyValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StandardFTPClientProviderTest {
    private static final PropertyValue NULL_PROPERTY_VALUE = new MockPropertyValue(null);
    private static final PropertyValue BOOLEAN_TRUE_PROPERTY_VALUE = new MockPropertyValue(Boolean.TRUE.toString());
    private static final PropertyValue BUFFER_SIZE_PROPERTY_VALUE = new MockPropertyValue("1 KB");
    private static final PropertyValue TIMEOUT_PROPERTY_VALUE = new MockPropertyValue("2 s");
    private static final String LOCALHOST = "localhost";
    private static final PropertyValue HOSTNAME_PROPERTY = new MockPropertyValue("localhost");
    @Mock
    private PropertyContext context;
    private StandardFTPClientProvider provider;
    private int port;

    @BeforeEach
    public void setProvider() {
        Mockito.when((Object)this.context.getProperty((PropertyDescriptor)ArgumentMatchers.any())).thenReturn((Object)BOOLEAN_TRUE_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.UTF8_ENCODING)).thenReturn((Object)BOOLEAN_TRUE_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.BUFFER_SIZE)).thenReturn((Object)BUFFER_SIZE_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FileTransfer.CONNECTION_TIMEOUT)).thenReturn((Object)TIMEOUT_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FileTransfer.DATA_TIMEOUT)).thenReturn((Object)TIMEOUT_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PROXY_CONFIGURATION_SERVICE)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PROXY_TYPE)).thenReturn((Object)new MockPropertyValue(FTPTransfer.PROXY_TYPE_DIRECT));
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PROXY_HOST)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PROXY_PORT)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.HTTP_PROXY_USERNAME)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FTPTransfer.HTTP_PROXY_PASSWORD)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(FileTransfer.HOSTNAME)).thenReturn((Object)HOSTNAME_PROPERTY);
        this.port = NetworkUtils.getAvailableTcpPort();
        Mockito.when((Object)this.context.getProperty(FTPTransfer.PORT)).thenReturn((Object)new MockPropertyValue(Integer.toString(this.port)));
        this.provider = new StandardFTPClientProvider();
    }

    @Test
    public void testGetClientConnectException() {
        ClientConnectException exception = (ClientConnectException)Assertions.assertThrows(ClientConnectException.class, () -> this.provider.getClient(this.context, Collections.emptyMap()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(LOCALHOST));
        Assertions.assertTrue((boolean)exception.getMessage().contains(Integer.toString(this.port)));
    }
}

