/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public abstract class TestIndexCorrelatedJoinStrategy {
    protected RecordSchema getOriginalSchema() {
        List<RecordField> originalFields = Collections.singletonList(new RecordField("id", RecordFieldType.INT.getDataType()));
        return new SimpleRecordSchema(originalFields);
    }

    protected RecordSchema getEnrichmentSchema() {
        List<RecordField> enrichmentFields = Arrays.asList(new RecordField("name", RecordFieldType.STRING.getDataType()), new RecordField("number", RecordFieldType.INT.getDataType()));
        return new SimpleRecordSchema(enrichmentFields);
    }

    protected Record createOriginalRecord(int id) {
        RecordSchema originalSchema = this.getOriginalSchema();
        HashMap<String, Integer> originalValues = new HashMap<String, Integer>();
        originalValues.put("id", id);
        return new MapRecord(originalSchema, originalValues);
    }

    protected Record createEnrichmentRecord(int id, String name, int number) {
        RecordSchema enrichmentSchema = this.getEnrichmentSchema();
        HashMap<String, Object> enrichmentValues = new HashMap<String, Object>();
        enrichmentValues.put("id", id);
        enrichmentValues.put("name", name);
        enrichmentValues.put("number", number);
        MapRecord enrichmentRecord = new MapRecord(enrichmentSchema, enrichmentValues);
        return enrichmentRecord;
    }
}

