/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.w3c.dom.Document;

public class DocumentReaderCallback
implements InputStreamCallback {
    private final boolean isNamespaceAware;
    private Document document;

    public DocumentReaderCallback(boolean isNamespaceAware) {
        this.isNamespaceAware = isNamespaceAware;
    }

    public void process(InputStream stream) throws IOException {
        try {
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            documentProvider.setNamespaceAware(this.isNamespaceAware);
            this.document = documentProvider.parse(stream);
        }
        catch (ProcessingException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

