/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@EventDriven
@SupportsBatching
@Tags(value={"test", "load", "duplicate"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Intended for load testing, this processor will create the configured number of copies of each incoming FlowFile. The original FlowFile as well as all generated copies are sent to the 'success' relationship. In addition, each FlowFile gets an attribute 'copy.index' set to the copy number, where the original FlowFile gets a value of zero, and all copies receive incremented integer values.")
@WritesAttributes(value={@WritesAttribute(attribute="copy.index", description="A zero-based incrementing integer value based on which copy the FlowFile is.")})
public class DuplicateFlowFile
extends AbstractProcessor {
    public static final String COPY_INDEX_ATTRIBUTE = "copy.index";
    static final PropertyDescriptor NUM_COPIES = new PropertyDescriptor.Builder().name("Number of Copies").displayName("Number of Copies").description("Specifies how many copies of each incoming FlowFile will be made").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("100").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The original FlowFile and all copies will be sent to this relationship").build();

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(NUM_COPIES);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        for (int i = 1; i <= context.getProperty(NUM_COPIES).evaluateAttributeExpressions(flowFile).asInteger(); ++i) {
            FlowFile copy = session.clone(flowFile);
            copy = session.putAttribute(copy, COPY_INDEX_ATTRIBUTE, Integer.toString(i));
            session.transfer(copy, REL_SUCCESS);
        }
        flowFile = session.putAttribute(flowFile, COPY_INDEX_ATTRIBUTE, "0");
        session.transfer(flowFile, REL_SUCCESS);
    }
}

