/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processors.standard.CalculateRecordStats;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCalculateRecordStats {
    TestRunner runner;
    MockRecordParser recordParser;
    RecordSchema personSchema;

    @BeforeEach
    void setup() throws InitializationException {
        this.runner = TestRunners.newTestRunner(CalculateRecordStats.class);
        this.recordParser = new MockRecordParser();
        this.runner.addControllerService("recordReader", (ControllerService)this.recordParser);
        this.runner.setProperty(CalculateRecordStats.RECORD_READER, "recordReader");
        this.runner.enableControllerService((ControllerService)this.recordParser);
        this.runner.assertValid();
        this.recordParser.addSchemaField("id", RecordFieldType.INT);
        ArrayList<RecordField> personFields = new ArrayList<RecordField>();
        RecordField nameField = new RecordField("name", RecordFieldType.STRING.getDataType());
        RecordField ageField = new RecordField("age", RecordFieldType.INT.getDataType());
        RecordField sportField = new RecordField("sport", RecordFieldType.STRING.getDataType());
        personFields.add(nameField);
        personFields.add(ageField);
        personFields.add(sportField);
        this.personSchema = new SimpleRecordSchema(personFields);
        this.recordParser.addSchemaField("person", RecordFieldType.RECORD);
    }

    @Test
    void testNoNullOrEmptyRecordFields() {
        List<String> sports = Arrays.asList("Soccer", "Soccer", "Soccer", "Football", "Football", "Basketball");
        HashMap<String, String> expectedAttributes = new HashMap<String, String>();
        expectedAttributes.put("recordStats.sport.Soccer", "3");
        expectedAttributes.put("recordStats.sport.Football", "2");
        expectedAttributes.put("recordStats.sport.Basketball", "1");
        expectedAttributes.put("recordStats.sport", "6");
        expectedAttributes.put("record.count", "6");
        this.commonTest(Collections.singletonMap("sport", "/person/sport"), sports, expectedAttributes);
    }

    @Test
    void testWithNullFields() {
        List<String> sports = Arrays.asList("Soccer", null, null, "Football", null, "Basketball");
        HashMap<String, String> expectedAttributes = new HashMap<String, String>();
        expectedAttributes.put("recordStats.sport.Soccer", "1");
        expectedAttributes.put("recordStats.sport.Football", "1");
        expectedAttributes.put("recordStats.sport.Basketball", "1");
        expectedAttributes.put("recordStats.sport", "3");
        expectedAttributes.put("record.count", "6");
        this.commonTest(Collections.singletonMap("sport", "/person/sport"), sports, expectedAttributes);
    }

    @Test
    void testWithFilters() {
        List<String> sports = Arrays.asList("Soccer", "Soccer", "Soccer", "Football", "Football", "Basketball");
        HashMap<String, String> expectedAttributes = new HashMap<String, String>();
        expectedAttributes.put("recordStats.sport.Soccer", "3");
        expectedAttributes.put("recordStats.sport.Basketball", "1");
        expectedAttributes.put("recordStats.sport", "4");
        expectedAttributes.put("record.count", "6");
        Map<String, String> propz = Collections.singletonMap("sport", "/person/sport[. != 'Football']");
        this.commonTest(propz, sports, expectedAttributes);
    }

    @Test
    void testWithSizeLimit() {
        this.runner.setProperty(CalculateRecordStats.LIMIT, "3");
        List<String> sports = Arrays.asList("Soccer", "Soccer", "Soccer", "Football", "Football", "Basketball", "Baseball", "Baseball", "Baseball", "Baseball", "Skiing", "Skiing", "Skiing", "Snowboarding");
        HashMap<String, String> expectedAttributes = new HashMap<String, String>();
        expectedAttributes.put("recordStats.sport.Skiing", "3");
        expectedAttributes.put("recordStats.sport.Soccer", "3");
        expectedAttributes.put("recordStats.sport.Baseball", "4");
        expectedAttributes.put("recordStats.sport", String.valueOf(sports.size()));
        expectedAttributes.put("record.count", String.valueOf(sports.size()));
        Map<String, String> propz = Collections.singletonMap("sport", "/person/sport");
        this.commonTest(propz, sports, expectedAttributes);
    }

    private void commonTest(Map<String, String> procProperties, List<String> sports, Map<String, String> expectedAttributes) {
        int index = 1;
        for (String string : sports) {
            HashMap<String, Object> newRecord = new HashMap<String, Object>();
            newRecord.put("name", "John Doe");
            newRecord.put("age", 48);
            newRecord.put("sport", string);
            this.recordParser.addRecord(new Object[]{index++, new MapRecord(this.personSchema, newRecord)});
        }
        for (Map.Entry entry : procProperties.entrySet()) {
            this.runner.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertTransferCount(CalculateRecordStats.REL_FAILURE, 0);
        this.runner.assertTransferCount(CalculateRecordStats.REL_SUCCESS, 1);
        List flowFiles = this.runner.getFlowFilesForRelationship(CalculateRecordStats.REL_SUCCESS);
        MockFlowFile mockFlowFile = (MockFlowFile)flowFiles.get(0);
        for (Map.Entry<String, String> expectedAttribute : expectedAttributes.entrySet()) {
            String key = expectedAttribute.getKey();
            String value = expectedAttribute.getValue();
            Assertions.assertNotNull((Object)mockFlowFile.getAttribute(key), (String)String.format("Missing %s", key));
            Assertions.assertEquals((Object)value, (Object)mockFlowFile.getAttribute(key));
        }
    }
}

