/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.prioritizer;

import java.util.regex.Pattern;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;

public class PriorityAttributePrioritizer
implements FlowFilePrioritizer {
    private static final Pattern intPattern = Pattern.compile("-?\\d+");

    public int compare(FlowFile o1, FlowFile o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 == null) {
            return 1;
        }
        String o1Priority = o1.getAttribute(CoreAttributes.PRIORITY.key());
        String o2Priority = o2.getAttribute(CoreAttributes.PRIORITY.key());
        if (o1Priority == null && o2Priority == null) {
            return 0;
        }
        if (o2Priority == null) {
            return -1;
        }
        if (o1Priority == null) {
            return 1;
        }
        if (intPattern.matcher(o1Priority.trim()).matches()) {
            if (intPattern.matcher(o2Priority.trim()).matches()) {
                try {
                    long o1num = Long.parseLong(o1Priority.trim());
                    long o2num = Long.parseLong(o2Priority.trim());
                    return o1num < o2num ? -1 : (o1num > o2num ? 1 : 0);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            return -1;
        }
        if (intPattern.matcher(o2Priority.trim()).matches()) {
            return 1;
        }
        return o1Priority.compareTo(o2Priority);
    }
}

