/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parameter.AbstractParameterProvider;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterGroup;
import org.apache.nifi.parameter.ParameterProviderInitializationContext;
import org.apache.nifi.parameter.VerifiableParameterProvider;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"environment", "variable"})
@CapabilityDescription(value="Fetches parameters from environment variables")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.ACCESS_ENVIRONMENT_CREDENTIALS, explanation="Provides operator the ability to read environment variables, which may contain environment credentials.")})
public class EnvironmentVariableParameterProvider
extends AbstractParameterProvider
implements VerifiableParameterProvider {
    private final Map<String, String> environmentVariables = new ConcurrentHashMap<String, String>();
    private static final AllowableValue INCLUDE_ALL_STRATEGY = new AllowableValue("include-all", "Include All", "All Environment Variables will be included");
    private static final AllowableValue COMMA_SEPARATED_STRATEGY = new AllowableValue("comma-separated", "Comma-Separated", "List comma-separated Environment Variable names to include");
    private static final AllowableValue REGEX_STRATEGY = new AllowableValue("regex", "Regular Expression", "Include Environment Variable names that match a Regular Expression");
    public static final PropertyDescriptor ENVIRONMENT_VARIABLE_INCLUSION_STRATEGY = new PropertyDescriptor.Builder().name("environment-variable-inclusion-strategy").displayName("Environment Variable Inclusion Strategy").description("Indicates how Environment Variables should be included").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(new AllowableValue[]{INCLUDE_ALL_STRATEGY, COMMA_SEPARATED_STRATEGY, REGEX_STRATEGY}).defaultValue(INCLUDE_ALL_STRATEGY.getValue()).required(true).build();
    public static final PropertyDescriptor INCLUDE_ENVIRONMENT_VARIABLES = new PropertyDescriptor.Builder().name("include-environment-variables").displayName("Include Environment Variables").description("Specifies environment variable names that should be included from the fetched environment variables.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).dependsOn(ENVIRONMENT_VARIABLE_INCLUSION_STRATEGY, new AllowableValue[]{REGEX_STRATEGY, COMMA_SEPARATED_STRATEGY}).build();
    public static final PropertyDescriptor PARAMETER_GROUP_NAME = new PropertyDescriptor.Builder().name("parameter-group-name").displayName("Parameter Group Name").description("The name of the parameter group that will be fetched.  This indicates the name of the Parameter Context that may receive the fetched parameters.").addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[a-zA-Z0-9_. -]+$"))).defaultValue("Environment Variables").required(true).build();
    private List<PropertyDescriptor> properties;

    protected void init(ParameterProviderInitializationContext config) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(PARAMETER_GROUP_NAME);
        properties.add(ENVIRONMENT_VARIABLE_INCLUSION_STRATEGY);
        properties.add(INCLUDE_ENVIRONMENT_VARIABLES);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public List<ParameterGroup> fetchParameters(ConfigurationContext context) {
        this.environmentVariables.clear();
        this.environmentVariables.putAll(System.getenv());
        EnvironmentVariableInclusionStrategy inclusionStrategy = this.getStrategy(context);
        String parameterGroupName = context.getProperty(PARAMETER_GROUP_NAME).getValue();
        ArrayList parameters = new ArrayList();
        this.environmentVariables.forEach((key, value) -> {
            if (inclusionStrategy.include((String)key)) {
                ParameterDescriptor parameterDescriptor = new ParameterDescriptor.Builder().name(key).build();
                parameters.add(new Parameter(parameterDescriptor, value, null, Boolean.valueOf(true)));
            }
        });
        return Collections.singletonList(new ParameterGroup(parameterGroupName, parameters));
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            List<ParameterGroup> parameterGroups = this.fetchParameters(context);
            int parameterCount = parameterGroups.get(0).getParameters().size();
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Fetch Environment Variables").explanation(String.format("Fetched %s Environment Variables as parameters", parameterCount)).build());
        }
        catch (IllegalArgumentException e) {
            verificationLogger.error("Failed to fetch parameters", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Fetch Environment Variables").explanation("Failed to fetch parameters: " + e.getMessage()).build());
        }
        return results;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        PropertyValue includeEnvironmentVariables = validationContext.getProperty(INCLUDE_ENVIRONMENT_VARIABLES);
        if (includeEnvironmentVariables.isSet()) {
            String inclusionStrategy = validationContext.getProperty(ENVIRONMENT_VARIABLE_INCLUSION_STRATEGY).getValue();
            if (REGEX_STRATEGY.getValue().equals(inclusionStrategy)) {
                results.add(StandardValidators.REGULAR_EXPRESSION_VALIDATOR.validate(INCLUDE_ENVIRONMENT_VARIABLES.getDisplayName(), includeEnvironmentVariables.getValue(), validationContext));
            } else if (COMMA_SEPARATED_STRATEGY.getValue().equals(inclusionStrategy)) {
                results.add(StandardValidators.NON_EMPTY_VALIDATOR.validate(INCLUDE_ENVIRONMENT_VARIABLES.getDisplayName(), includeEnvironmentVariables.getValue(), validationContext));
            }
        }
        return results;
    }

    private EnvironmentVariableInclusionStrategy getStrategy(ConfigurationContext context) {
        return InclusionStrategyValue.fromValue(context.getProperty(ENVIRONMENT_VARIABLE_INCLUSION_STRATEGY).getValue()).getStrategy(context.getProperty(INCLUDE_ENVIRONMENT_VARIABLES).getValue());
    }

    static class CommaSeparatedEnvironmentVariableInclusionStrategy
    implements EnvironmentVariableInclusionStrategy {
        private final Set<String> includedNames;

        CommaSeparatedEnvironmentVariableInclusionStrategy(String includedNames) {
            if (includedNames == null) {
                throw new IllegalArgumentException("Comma-separated list of included names is required");
            }
            this.includedNames = new HashSet<String>(Arrays.asList(includedNames.split(",")).stream().map(String::trim).collect(Collectors.toList()));
        }

        @Override
        public boolean include(String variableName) {
            return this.includedNames.contains(variableName);
        }
    }

    static class RegexEnvironmentVariableInclusionStrategy
    implements EnvironmentVariableInclusionStrategy {
        private final Pattern pattern;

        RegexEnvironmentVariableInclusionStrategy(String regex) {
            if (regex == null) {
                throw new IllegalArgumentException("Regular Expression is required");
            }
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean include(String variableName) {
            return this.pattern.matcher(variableName).matches();
        }
    }

    static class IncludeAllEnvironmentVariableInclusionStrategy
    implements EnvironmentVariableInclusionStrategy {
        IncludeAllEnvironmentVariableInclusionStrategy(String inclusionText) {
        }

        @Override
        public boolean include(String variableName) {
            return true;
        }
    }

    static interface EnvironmentVariableInclusionStrategy {
        public boolean include(String var1);
    }

    private static enum InclusionStrategyValue {
        INCLUDE_ALL(INCLUDE_ALL_STRATEGY.getValue(), IncludeAllEnvironmentVariableInclusionStrategy::new),
        COMMA_SEPARATED(COMMA_SEPARATED_STRATEGY.getValue(), CommaSeparatedEnvironmentVariableInclusionStrategy::new),
        REGEX_STRATEGY(REGEX_STRATEGY.getValue(), RegexEnvironmentVariableInclusionStrategy::new);

        private String name;
        private Function<String, EnvironmentVariableInclusionStrategy> factoryMethod;

        private InclusionStrategyValue(String name, Function<String, EnvironmentVariableInclusionStrategy> factoryMethod) {
            this.name = name;
            this.factoryMethod = factoryMethod;
        }

        EnvironmentVariableInclusionStrategy getStrategy(String inclusionText) {
            return this.factoryMethod.apply(inclusionText);
        }

        static InclusionStrategyValue fromValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Inclusion strategy value is required");
            }
            for (InclusionStrategyValue v : InclusionStrategyValue.values()) {
                if (!v.name.equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("Unrecognized inclusion strategy value");
        }
    }
}

