/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.nifi.web.ViewableContent;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.transform.StandardTransformProvider;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class StandardContentViewerController
extends HttpServlet {
    private static final Set<String> supportedMimeTypes = new HashSet();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ViewableContent content = (ViewableContent)request.getAttribute("org.apache.nifi.web.content");
        String contentType = content.getContentType();
        if (supportedMimeTypes.contains(contentType)) {
            String formatted;
            if (ViewableContent.DisplayMode.Original.equals((Object)content.getDisplayMode())) {
                formatted = content.getContent();
            } else if ("application/json".equals(contentType)) {
                ObjectMapper mapper = new ObjectMapper();
                Object objectJson = mapper.readValue(content.getContentStream(), Object.class);
                formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(objectJson);
            } else if ("application/xml".equals(contentType) || "text/xml".equals(contentType)) {
                StringWriter writer = new StringWriter();
                try {
                    StreamSource source = new StreamSource(content.getContentStream());
                    StreamResult result = new StreamResult(writer);
                    StandardTransformProvider transformProvider = new StandardTransformProvider();
                    transformProvider.setIndent(true);
                    transformProvider.transform((Source)source, (Result)result);
                }
                catch (ProcessingException te) {
                    throw new IOException("Unable to transform content as XML: " + te, te);
                }
                formatted = writer.toString();
            } else if ("application/avro-binary".equals(contentType) || "avro/binary".equals(contentType) || "application/avro+binary".equals(contentType)) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                GenericData genericData = new GenericData();
                genericData.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
                genericData.addLogicalTypeConversion((Conversion)new TimeConversions.DateConversion());
                genericData.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMicrosConversion());
                genericData.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMillisConversion());
                genericData.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMicrosConversion());
                genericData.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMillisConversion());
                genericData.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMicrosConversion());
                genericData.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMillisConversion());
                GenericDatumReader datumReader = new GenericDatumReader(null, null, genericData);
                try (DataFileStream dataFileReader = new DataFileStream(content.getContentStream(), (DatumReader)datumReader);){
                    while (dataFileReader.hasNext()) {
                        GenericData.Record record = (GenericData.Record)dataFileReader.next();
                        String formattedRecord = genericData.toString((Object)record);
                        sb.append(formattedRecord);
                        sb.append(",");
                        if (sb.length() <= 0x200000) continue;
                        break;
                    }
                }
                if (sb.length() > 1) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("]");
                String json = sb.toString();
                ObjectMapper mapper = new ObjectMapper();
                Object objectJson = mapper.readValue(json, Object.class);
                formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(objectJson);
                contentType = "application/json";
            } else if ("text/x-yaml".equals(contentType) || "text/yaml".equals(contentType) || "text/yml".equals(contentType) || "application/x-yaml".equals(contentType) || "application/x-yml".equals(contentType) || "application/yaml".equals(contentType) || "application/yml".equals(contentType)) {
                Yaml yaml = new Yaml();
                Object yamlObject = yaml.load(content.getContentStream());
                DumperOptions options = new DumperOptions();
                options.setIndent(2);
                options.setPrettyFlow(true);
                options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                Yaml output = new Yaml(options);
                formatted = output.dump(yamlObject);
            } else {
                formatted = content.getContent();
            }
            request.setAttribute("mode", (Object)contentType);
            request.setAttribute("content", (Object)formatted);
            this.getServletContext().getRequestDispatcher("/WEB-INF/jsp/codemirror.jsp").include((ServletRequest)request, (ServletResponse)response);
        } else {
            PrintWriter out = response.getWriter();
            out.println("Unexpected content type: " + contentType);
        }
    }

    static {
        supportedMimeTypes.add("application/json");
        supportedMimeTypes.add("application/xml");
        supportedMimeTypes.add("text/xml");
        supportedMimeTypes.add("text/plain");
        supportedMimeTypes.add("text/csv");
        supportedMimeTypes.add("application/avro-binary");
        supportedMimeTypes.add("avro/binary");
        supportedMimeTypes.add("application/avro+binary");
        supportedMimeTypes.add("text/x-yaml");
        supportedMimeTypes.add("text/yaml");
        supportedMimeTypes.add("text/yml");
        supportedMimeTypes.add("application/x-yaml");
        supportedMimeTypes.add("application/x-yml");
        supportedMimeTypes.add("application/yaml");
        supportedMimeTypes.add("application/yml");
    }
}

