/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.solr;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrPortAwareCookieSpecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosHttpClientBuilder
implements HttpClientBuilderFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HttpRequestInterceptor bufferedEntityInterceptor = (request, context) -> {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
            HttpEntity requestEntity = enclosingRequest.getEntity();
            enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
        }
    };

    public SolrHttpClientBuilder getBuilder() {
        return this.getBuilder(HttpClientUtil.getHttpClientBuilder());
    }

    public void close() {
        HttpClientUtil.removeRequestInterceptor((HttpRequestInterceptor)this.bufferedEntityInterceptor);
    }

    public SolrHttpClientBuilder getHttpClientBuilder(Optional<SolrHttpClientBuilder> builder) {
        return builder.isPresent() ? this.getBuilder(builder.get()) : this.getBuilder();
    }

    public SolrHttpClientBuilder getBuilder(SolrHttpClientBuilder builder) {
        builder.setAuthSchemeRegistryProvider(() -> {
            Registry authProviders = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, false)).build();
            return authProviders;
        });
        Credentials useJaasCreds = new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
        HttpClientUtil.setCookiePolicy((String)"solr-portaware");
        builder.setCookieSpecRegistryProvider(() -> {
            SolrPortAwareCookieSpecFactory cookieFactory = new SolrPortAwareCookieSpecFactory();
            Registry cookieRegistry = RegistryBuilder.create().register("solr-portaware", (Object)cookieFactory).build();
            return cookieRegistry;
        });
        builder.setDefaultCredentialsProvider(() -> {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, useJaasCreds);
            return credentialsProvider;
        });
        HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)this.bufferedEntityInterceptor);
        return builder;
    }
}

