/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.nifi.io.nio.AbstractChannelReader;
import org.apache.nifi.io.nio.BufferPool;
import org.apache.nifi.io.nio.consumer.StreamConsumerFactory;

public final class DatagramChannelReader
extends AbstractChannelReader {
    public static final int MAX_UDP_PACKET_SIZE = 65507;
    private final boolean readSingleDatagram;

    public DatagramChannelReader(String id, SelectionKey key, BufferPool empties, StreamConsumerFactory consumerFactory, boolean readSingleDatagram) {
        super(id, key, empties, consumerFactory);
        this.readSingleDatagram = readSingleDatagram;
    }

    @Override
    protected int fillBuffer(SelectionKey key, ByteBuffer buffer) throws IOException {
        DatagramChannel dChannel = (DatagramChannel)key.channel();
        int initialBufferPosition = buffer.position();
        while (buffer.remaining() > 65507 && key.isValid() && key.isReadable() && dChannel.receive(buffer) != null && !this.readSingleDatagram) {
        }
        return buffer.position() - initialBufferPosition;
    }
}

