/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.operations.SNMPTrapReceiverHandler;
import org.apache.nifi.snmp.processors.properties.BasicProperties;
import org.apache.nifi.snmp.processors.properties.V3SecurityProperties;
import org.apache.nifi.snmp.utils.JsonFileUsmReader;
import org.apache.nifi.snmp.utils.JsonUsmReader;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.apache.nifi.snmp.utils.SecurityNamesUsmReader;
import org.apache.nifi.snmp.utils.UsmReader;
import org.snmp4j.security.UsmUser;

@Tags(value={"snmp", "listen", "trap"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Receives information from SNMP Agent and outputs a FlowFile with information in attributes and without any content")
@WritesAttribute(attribute="snmp$*", description="Attributes retrieved from the SNMP response. It may include: snmp$errorIndex, snmp$errorStatus, snmp$errorStatusText, snmp$nonRepeaters, snmp$requestID, snmp$type, snmp$variableBindings")
@RequiresInstanceClassLoading
public class ListenTrapSNMP
extends AbstractSessionFactoryProcessor
implements VerifiableProcessor {
    public static final AllowableValue USM_JSON_FILE_PATH = new AllowableValue("usm-json-file-path", "Json File Path", "The path of the JSON file containing the USM users");
    public static final AllowableValue USM_JSON_CONTENT = new AllowableValue("usm-json-content", "Json Content", "The JSON containing the USM users");
    public static final AllowableValue USM_SECURITY_NAMES = new AllowableValue("usm-security-names", "Security Names", "In case of noAuthNoPriv security level - the list of security names separated by commas");
    public static final PropertyDescriptor SNMP_MANAGER_PORT = new PropertyDescriptor.Builder().name("snmp-manager-port").displayName("SNMP Manager Port").description("The port where the SNMP Manager listens to the incoming traps.").required(true).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor SNMP_USM_USER_SOURCE = new PropertyDescriptor.Builder().name("snmp-usm-users-source").displayName("USM Users Source").description("The ways to provide USM User data").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(new AllowableValue[]{USM_JSON_CONTENT, USM_JSON_FILE_PATH, USM_SECURITY_NAMES}).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).build();
    public static final PropertyDescriptor SNMP_USM_USERS_JSON_FILE_PATH = new PropertyDescriptor.Builder().name("snmp-usm-users-file-path").displayName("USM Users JSON File Path").description("The path of the json file containing the user credentials for SNMPv3. Check Usage for more details.").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).dependsOn(SNMP_USM_USER_SOURCE, new AllowableValue[]{USM_JSON_FILE_PATH}).build();
    public static final PropertyDescriptor SNMP_USM_USERS_JSON = new PropertyDescriptor.Builder().name("snmp-usm-users-json-content").displayName("USM Users JSON content").description("The JSON containing the user credentials for SNMPv3. Check Usage for more details.").required(false).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).dependsOn(SNMP_USM_USER_SOURCE, new AllowableValue[]{USM_JSON_CONTENT}).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor SNMP_USM_SECURITY_NAMES = new PropertyDescriptor.Builder().name("snmp-usm-security-names").displayName("SNMP Users Security Names").description("Security names listed separated by commas in SNMPv3. Check Usage for more details.").required(false).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).dependsOn(V3SecurityProperties.SNMP_SECURITY_LEVEL, new AllowableValue[]{V3SecurityProperties.NO_AUTH_NO_PRIV}).dependsOn(SNMP_USM_USER_SOURCE, new AllowableValue[]{USM_SECURITY_NAMES}).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are received from the SNMP agent are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot received from the SNMP agent are routed to this relationship").build();
    protected static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(SNMP_MANAGER_PORT, BasicProperties.SNMP_VERSION, BasicProperties.SNMP_COMMUNITY, V3SecurityProperties.SNMP_SECURITY_LEVEL, SNMP_USM_USER_SOURCE, SNMP_USM_USERS_JSON_FILE_PATH, SNMP_USM_USERS_JSON, SNMP_USM_SECURITY_NAMES));
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    private volatile SNMPTrapReceiverHandler snmpTrapReceiverHandler;
    private volatile List<UsmUser> usmUsers;

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        String usmUserSource = context.getProperty(SNMP_USM_USER_SOURCE).getValue();
        if (usmUserSource != null) {
            UsmReader usmReader = this.getUsmReader(context, usmUserSource);
            try {
                if (usmReader != null) {
                    usmReader.readUsm();
                }
            }
            catch (Exception e) {
                results.add(new ConfigVerificationResult.Builder().verificationStepName("USM User processing").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(e.getMessage() + " " + e.getCause().getMessage()).build());
            }
        }
        return results;
    }

    @OnScheduled
    public void initSnmpManager(ProcessContext context) {
        UsmReader usmReader;
        int version = SNMPUtils.getVersion(context.getProperty(BasicProperties.SNMP_VERSION).getValue());
        int managerPort = context.getProperty(SNMP_MANAGER_PORT).asInteger();
        String securityLevel = context.getProperty(V3SecurityProperties.SNMP_SECURITY_LEVEL).getValue();
        SNMPConfiguration configuration = SNMPConfiguration.builder().setManagerPort(managerPort).setVersion(version).setSecurityLevel(securityLevel).setCommunityString(context.getProperty(BasicProperties.SNMP_COMMUNITY).getValue()).build();
        String usmUserSource = context.getProperty(SNMP_USM_USER_SOURCE).getValue();
        if (usmUserSource != null && (usmReader = this.getUsmReader(context, usmUserSource)) != null) {
            this.usmUsers = usmReader.readUsm();
        }
        this.snmpTrapReceiverHandler = new SNMPTrapReceiverHandler(configuration, this.usmUsers);
    }

    public int getListeningPort() {
        if (this.snmpTrapReceiverHandler == null || !this.snmpTrapReceiverHandler.isStarted()) {
            return 0;
        }
        return this.snmpTrapReceiverHandler.getListeningPort();
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory processSessionFactory) {
        if (!this.snmpTrapReceiverHandler.isStarted()) {
            this.snmpTrapReceiverHandler.createTrapReceiver(processSessionFactory, this.getLogger());
        }
        context.yield();
    }

    @OnStopped
    public void close() {
        if (this.snmpTrapReceiverHandler != null) {
            this.snmpTrapReceiverHandler.close();
        }
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    private UsmReader getUsmReader(ProcessContext context, String usmUserSource) {
        String usmUsersJsonFilePath = context.getProperty(SNMP_USM_USERS_JSON_FILE_PATH).getValue();
        String usmUsersJson = context.getProperty(SNMP_USM_USERS_JSON).getValue();
        String usmSecurityNames = context.getProperty(SNMP_USM_SECURITY_NAMES).getValue();
        UsmReader usmReader = null;
        if (USM_JSON_FILE_PATH.getValue().equals(usmUserSource)) {
            usmReader = new JsonFileUsmReader(usmUsersJsonFilePath);
        } else if (USM_JSON_CONTENT.getValue().equals(usmUserSource)) {
            usmReader = new JsonUsmReader(usmUsersJson);
        } else if (USM_SECURITY_NAMES.getValue().equals(usmUserSource)) {
            usmReader = new SecurityNamesUsmReader(usmSecurityNames);
        }
        return usmReader;
    }
}

