/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.snmp.dto.SNMPSingleResponse;
import org.apache.nifi.snmp.dto.SNMPTreeResponse;
import org.apache.nifi.snmp.exception.RequestTimeoutException;
import org.apache.nifi.snmp.exception.SNMPWalkException;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

public class GetSNMPHandler {
    private static final PDUFactory getPduFactory = new DefaultPDUFactory(-96);
    protected static final String EMPTY_SUBTREE_EXCEPTION_MESSAGE = "Agent is not available, the %s OID not found or user not found. Please, check if (1) the agent is available, (2) the processor's SNMP version matches the agent version, (3) the OID is correct, (4) The user is valid.";
    protected static final String SNMP_ERROR_EXCEPTION_MESSAGE = "Agent is not available, OID not found or user not found. Please, check if (1) the agent is available, (2) the processor's SNMP version matches the agent version, (3) the OID is correct, (4) The user is valid.";
    protected static final String LEAF_ELEMENT_EXCEPTION_MESSAGE = "OID not found or it is a single leaf element. The leaf element associated with this %s OID does not contain child OIDs. Please check if the OID exists in the agent MIB or specify a parent OID with at least one child element";
    private Snmp snmpManager;
    private TreeUtils treeUtils;

    public GetSNMPHandler(Snmp snmpManager) {
        this.snmpManager = snmpManager;
        this.treeUtils = new TreeUtils((Session)snmpManager, getPduFactory);
    }

    public Optional<SNMPSingleResponse> get(Map<String, String> flowFileAttributes, Target target) throws IOException {
        PDU pdu = getPduFactory.createPDU(target);
        VariableBinding[] variableBindings = SNMPUtils.addGetVariables(flowFileAttributes);
        if (variableBindings.length == 0) {
            return Optional.empty();
        }
        pdu.addAll(variableBindings);
        PDU responsePdu = this.getResponsePdu(target, pdu);
        return Optional.of(new SNMPSingleResponse(target, responsePdu));
    }

    public Optional<SNMPTreeResponse> walk(Map<String, String> flowFileAttributes, Target target) {
        Object[] oids = SNMPUtils.addWalkVariables(flowFileAttributes);
        if (oids.length == 0) {
            return Optional.empty();
        }
        List subtree = this.treeUtils.walk(target, (OID[])oids);
        this.evaluateSubtreeErrors(Arrays.toString(oids), subtree);
        return Optional.of(new SNMPTreeResponse(target, subtree));
    }

    private PDU getResponsePdu(Target target, PDU pdu) throws IOException {
        ResponseEvent response = this.snmpManager.get(pdu, target);
        PDU responsePdu = response.getResponse();
        if (responsePdu == null) {
            throw new RequestTimeoutException(String.format("Request timed out. Please check if (1). the agent host and port is correctly set, (2). the agent is running, (3). the agent SNMP version corresponds with the processor's one, (4) the community string is correct and has %1$s access, (5) In case of SNMPv3 check if the user credentials are valid and the user in a group with %1$s access.", "read"));
        }
        return responsePdu;
    }

    private void evaluateSubtreeErrors(String oid, List<TreeEvent> subtree) {
        if (subtree.isEmpty()) {
            throw new SNMPWalkException(String.format(EMPTY_SUBTREE_EXCEPTION_MESSAGE, oid));
        }
        if (this.isSnmpError(subtree)) {
            throw new SNMPWalkException(SNMP_ERROR_EXCEPTION_MESSAGE);
        }
        if (this.isLeafElement(subtree)) {
            throw new SNMPWalkException(String.format(LEAF_ELEMENT_EXCEPTION_MESSAGE, oid));
        }
    }

    private boolean isSnmpError(List<TreeEvent> subtree) {
        return subtree.size() == 1 && subtree.get(0).getVariableBindings() == null;
    }

    private boolean isLeafElement(List<TreeEvent> subtree) {
        return subtree.size() == 1 && subtree.get(0).getVariableBindings().length == 0;
    }

    void setTreeUtils(TreeUtils treeUtils) {
        this.treeUtils = treeUtils;
    }
}

