/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.configuration.V1TrapConfiguration;
import org.apache.nifi.snmp.configuration.V2TrapConfiguration;
import org.apache.nifi.snmp.operations.SendTrapSNMPHandler;
import org.apache.nifi.snmp.processors.AbstractSNMPProcessor;
import org.apache.nifi.snmp.processors.properties.BasicProperties;
import org.apache.nifi.snmp.processors.properties.V1TrapProperties;
import org.apache.nifi.snmp.processors.properties.V2TrapProperties;
import org.apache.nifi.snmp.processors.properties.V3SecurityProperties;
import org.apache.nifi.snmp.utils.SNMPUtils;

@Tags(value={"snmp", "send", "trap"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@CapabilityDescription(value="Sends information to SNMP Manager.")
public class SendTrapSNMP
extends AbstractSNMPProcessor {
    public static final PropertyDescriptor SNMP_MANAGER_HOST = new PropertyDescriptor.Builder().name("snmp-trap-manager-host").displayName("SNMP Manager Host").description("The host where the SNMP Manager sends the trap.").required(true).defaultValue("localhost").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SNMP_MANAGER_PORT = new PropertyDescriptor.Builder().name("snmp-trap-manager-port").displayName("SNMP Manager Port").description("The port where the SNMP Manager listens to the incoming traps.").required(true).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that have been successfully used to perform SNMP Set are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot received from the SNMP agent are routed to this relationship").build();
    protected static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(SNMP_MANAGER_HOST, SNMP_MANAGER_PORT, BasicProperties.SNMP_VERSION, BasicProperties.SNMP_COMMUNITY, V3SecurityProperties.SNMP_SECURITY_LEVEL, V3SecurityProperties.SNMP_SECURITY_NAME, V3SecurityProperties.SNMP_AUTH_PROTOCOL, V3SecurityProperties.SNMP_AUTH_PASSWORD, V3SecurityProperties.SNMP_PRIVACY_PROTOCOL, V3SecurityProperties.SNMP_PRIVACY_PASSWORD, BasicProperties.SNMP_RETRIES, BasicProperties.SNMP_TIMEOUT, V1TrapProperties.ENTERPRISE_OID, V1TrapProperties.AGENT_ADDRESS, V1TrapProperties.GENERIC_TRAP_TYPE, V1TrapProperties.SPECIFIC_TRAP_TYPE, V2TrapProperties.TRAP_OID_VALUE));
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    private volatile SendTrapSNMPHandler snmpHandler;

    @OnScheduled
    public void init(ProcessContext context) {
        Instant startTime = Instant.now();
        this.initSnmpManager(context);
        this.snmpHandler = new SendTrapSNMPHandler(this.snmpResourceHandler, startTime, this.getLogger());
    }

    public void onTrigger(ProcessContext context, ProcessSession processSession) {
        FlowFile flowFile = Optional.ofNullable(processSession.get()).orElseGet(() -> ((ProcessSession)processSession).create());
        HashMap<String, String> attributes = new HashMap<String, String>(flowFile.getAttributes());
        try {
            int snmpVersion = SNMPUtils.getVersion(context.getProperty(BasicProperties.SNMP_VERSION).getValue());
            if (0 == snmpVersion) {
                String enterpriseOid = context.getProperty(V1TrapProperties.ENTERPRISE_OID).evaluateAttributeExpressions(flowFile).getValue();
                String agentAddress = context.getProperty(V1TrapProperties.AGENT_ADDRESS).evaluateAttributeExpressions(flowFile).getValue();
                String genericTrapType = context.getProperty(V1TrapProperties.GENERIC_TRAP_TYPE).getValue();
                if (genericTrapType.equals(V1TrapProperties.WITH_FLOW_FILE_ATTRIBUTE.getValue())) {
                    genericTrapType = flowFile.getAttribute("generic-trap-type");
                }
                String specificTrapType = context.getProperty(V1TrapProperties.SPECIFIC_TRAP_TYPE).evaluateAttributeExpressions(flowFile).getValue();
                V1TrapConfiguration v1TrapConfiguration = V1TrapConfiguration.builder().enterpriseOid(enterpriseOid).agentAddress(agentAddress).genericTrapType(genericTrapType).specificTrapType(specificTrapType).build();
                attributes.put("agentAddress", agentAddress);
                attributes.put("enterpriseOid", enterpriseOid);
                attributes.put("genericTrapType", genericTrapType);
                attributes.put("specificTrapType", specificTrapType);
                this.snmpHandler.sendTrap(attributes, v1TrapConfiguration);
            } else {
                String trapOidValue = context.getProperty(V2TrapProperties.TRAP_OID_VALUE).evaluateAttributeExpressions(flowFile).getValue();
                V2TrapConfiguration v2TrapConfiguration = new V2TrapConfiguration(trapOidValue);
                attributes.put("trapOidValue", trapOidValue);
                this.snmpHandler.sendTrap(attributes, v2TrapConfiguration);
            }
            processSession.putAllAttributes(flowFile, attributes);
            processSession.transfer(flowFile, REL_SUCCESS);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to send request to the agent. Check if the agent supports the used version.", (Throwable)e);
            processSession.transfer(processSession.penalize(flowFile), REL_FAILURE);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Invalid trap configuration.", (Throwable)e);
            processSession.transfer(processSession.penalize(flowFile), REL_FAILURE);
        }
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    protected String getTargetHost(ProcessContext processContext) {
        return processContext.getProperty(SNMP_MANAGER_HOST).getValue();
    }

    @Override
    protected String getTargetPort(ProcessContext processContext) {
        return processContext.getProperty(SNMP_MANAGER_PORT).getValue();
    }
}

