/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

class UsmUserDeserializer
extends StdDeserializer<UsmUser> {
    public UsmUserDeserializer() {
        super((Class)null);
    }

    public UsmUser deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String securityName = node.get("securityName").asText();
        OID authProtocol = null;
        JsonNode authProtocolNode = node.get("authProtocol");
        if (authProtocolNode != null) {
            authProtocol = SNMPUtils.getAuth(authProtocolNode.asText());
        }
        OctetString authPassphrase = null;
        JsonNode authPassphraseNode = node.get("authPassphrase");
        if (authPassphraseNode != null) {
            authPassphrase = new OctetString(authPassphraseNode.asText());
        }
        if (authProtocol != null && authPassphrase == null) {
            throw new IllegalArgumentException("Authentication passphrase must be set and at least 8 bytes long ifauthentication protocol is specified.");
        }
        OID privProtocol = null;
        JsonNode privProtocolNode = node.get("privProtocol");
        if (privProtocolNode != null) {
            privProtocol = SNMPUtils.getPriv(privProtocolNode.asText());
        }
        OctetString privPassphrase = null;
        JsonNode privPassphraseNode = node.get("privPassphrase");
        if (privPassphraseNode != null) {
            privPassphrase = new OctetString(privPassphraseNode.asText());
        }
        if (privProtocol != null && privPassphrase == null) {
            throw new IllegalArgumentException("Privacy passphrase must be set and at least 8 bytes long ifauthentication protocol is specified.");
        }
        return new UsmUser(new OctetString(securityName), authProtocol, authPassphrase, privProtocol, privPassphrase);
    }
}

