/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.snmp.exception.InvalidAuthProtocolException;
import org.apache.nifi.snmp.exception.InvalidPrivProtocolException;
import org.apache.nifi.snmp.exception.InvalidSnmpVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public final class SNMPUtils {
    public static final String SNMP_PROP_DELIMITER = "$";
    public static final String SNMP_PROP_PREFIX = "snmp$";
    private static final Logger logger = LoggerFactory.getLogger(SNMPUtils.class);
    private static final String OID_PROP_PATTERN = "snmp$%s$%s";
    private static final Pattern OID_PATTERN = Pattern.compile("[0-9+.]*");
    private static final Map<String, OID> AUTH_MAP;
    private static final Map<String, OID> PRIV_MAP;
    private static final Map<String, String> REPORT_MAP;
    private static final Map<String, Integer> VERSION_MAP;

    private SNMPUtils() {
    }

    public static Map<String, String> getPduAttributeMap(PDU response) {
        Vector variableBindings = response.getVariableBindings();
        Map<String, String> attributes = variableBindings.stream().collect(Collectors.toMap(k -> String.format(OID_PROP_PATTERN, k.getOid(), k.getSyntax()), v -> v.getVariable().toString()));
        attributes.computeIfAbsent("snmp$errorIndex", v -> String.valueOf(response.getErrorIndex()));
        attributes.computeIfAbsent("snmp$errorStatus", v -> String.valueOf(response.getErrorStatus()));
        attributes.computeIfAbsent("snmp$errorStatusText", v -> response.getErrorStatusText());
        attributes.computeIfAbsent("snmp$nonRepeaters", v -> String.valueOf(response.getNonRepeaters()));
        attributes.computeIfAbsent("snmp$requestID", v -> String.valueOf(response.getRequestID()));
        attributes.computeIfAbsent("snmp$type", v -> String.valueOf(response.getType()));
        attributes.computeIfAbsent("snmp$typeString", v -> PDU.getTypeString((int)response.getType()));
        return attributes;
    }

    public static Map<String, String> getV1TrapPduAttributeMap(PDUv1 v1TrapPdu) {
        Map<String, String> trapAttributes = SNMPUtils.getPduAttributeMap((PDU)v1TrapPdu);
        trapAttributes.computeIfAbsent("snmp$enterprise", v -> String.valueOf(v1TrapPdu.getEnterprise()));
        trapAttributes.computeIfAbsent("snmp$agentAddress", v -> String.valueOf(v1TrapPdu.getAgentAddress()));
        trapAttributes.computeIfAbsent("snmp$genericTrapType", v -> String.valueOf(v1TrapPdu.getGenericTrap()));
        trapAttributes.computeIfAbsent("snmp$specificTrapType", v -> String.valueOf(v1TrapPdu.getSpecificTrap()));
        trapAttributes.computeIfAbsent("snmp$timestamp", v -> String.valueOf(v1TrapPdu.getTimestamp()));
        return trapAttributes;
    }

    public static Map<String, String> createWalkOidValuesMap(List<VariableBinding> variableBindings) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        variableBindings.forEach(vb -> SNMPUtils.addAttributeFromVariable(vb, attributes));
        return attributes;
    }

    public static OID getPriv(String privProtocol) {
        if (PRIV_MAP.containsKey(privProtocol)) {
            return PRIV_MAP.get(privProtocol);
        }
        throw new InvalidPrivProtocolException("Invalid privacy protocol provided.");
    }

    public static OID getAuth(String authProtocol) {
        if (AUTH_MAP.containsKey(authProtocol)) {
            return AUTH_MAP.get(authProtocol);
        }
        throw new InvalidAuthProtocolException("Invalid authentication protocol provided.");
    }

    public static boolean addVariables(PDU pdu, Map<String, String> attributes) {
        boolean result = false;
        try {
            for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
                Optional<OctetString> var;
                if (!attributeEntry.getKey().startsWith(SNMP_PROP_PREFIX)) continue;
                String[] splits = attributeEntry.getKey().split("\\$");
                String snmpPropName = splits[1];
                String snmpPropValue = attributeEntry.getValue();
                if (!OID_PATTERN.matcher(snmpPropName).matches()) continue;
                if (splits.length == 2) {
                    var = Optional.of(new OctetString(snmpPropValue));
                } else {
                    int smiSyntax = Integer.parseInt(splits[2]);
                    var = SNMPUtils.stringToVariable(snmpPropValue, smiSyntax);
                }
                if (!var.isPresent()) continue;
                VariableBinding varBind = new VariableBinding(new OID(snmpPropName), (Variable)var.get());
                pdu.add(varBind);
                result = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return result;
    }

    public static VariableBinding[] addGetVariables(Map<String, String> attributes) {
        ArrayList<VariableBinding> variableBindings = new ArrayList<VariableBinding>();
        try {
            for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
                String[] splits;
                String snmpPropName;
                if (!attributeEntry.getKey().startsWith(SNMP_PROP_PREFIX) || !OID_PATTERN.matcher(snmpPropName = (splits = attributeEntry.getKey().split("\\$"))[1]).matches()) continue;
                variableBindings.add(new VariableBinding(new OID(snmpPropName)));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new VariableBinding[0];
        }
        return variableBindings.toArray(new VariableBinding[0]);
    }

    public static OID[] addWalkVariables(Map<String, String> attributes) {
        ArrayList<OID> oids = new ArrayList<OID>();
        try {
            for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
                String[] splits;
                String snmpPropName;
                if (!attributeEntry.getKey().startsWith(SNMP_PROP_PREFIX) || !OID_PATTERN.matcher(snmpPropName = (splits = attributeEntry.getKey().split("\\$"))[1]).matches()) continue;
                oids.add(new OID(snmpPropName));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new OID[0];
        }
        return oids.toArray(new OID[0]);
    }

    private static void addAttributeFromVariable(VariableBinding variableBinding, Map<String, String> attributes) {
        attributes.put(SNMP_PROP_PREFIX + variableBinding.getOid() + SNMP_PROP_DELIMITER + variableBinding.getVariable().getSyntax(), variableBinding.getVariable().toString());
    }

    private static Optional<Variable> stringToVariable(String value, int smiSyntax) {
        Variable var = AbstractVariable.createFromSyntax((int)smiSyntax);
        try {
            if (var instanceof AssignableFromString) {
                ((AssignableFromString)var).setValue(value);
            } else if (var instanceof AssignableFromInteger) {
                ((AssignableFromInteger)var).setValue(Integer.parseInt(value));
            } else if (var instanceof AssignableFromLong) {
                ((AssignableFromLong)var).setValue(Long.parseLong(value));
            } else {
                logger.error("Unsupported conversion of [ {} ] to ", (Object)var.getSyntaxString());
                var = null;
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Unsupported conversion of [ {} ] to ", (Object)var.getSyntaxString(), (Object)e);
            var = null;
        }
        return Optional.ofNullable(var);
    }

    public static Optional<String> getErrorMessage(String oid) {
        Optional<String> errorMessage = Optional.ofNullable(REPORT_MAP.get(oid));
        if (!errorMessage.isPresent() && oid.charAt(oid.length() - 1) == '0') {
            String cutLastOidValue = oid.substring(0, oid.length() - 2);
            errorMessage = Optional.ofNullable(REPORT_MAP.get(cutLastOidValue));
        }
        return errorMessage.map(s -> oid + ": " + s);
    }

    public static int getVersion(String snmpVersion) {
        return Optional.ofNullable(VERSION_MAP.get(snmpVersion)).orElseThrow(() -> new InvalidSnmpVersionException("Invalid SNMP version provided."));
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("1.3.6.1.6.3.15.1.1.1", "usmStatsUnsupportedSecLevels");
        map.put("1.3.6.1.6.3.15.1.1.2", "usmStatsNotInTimeWindows");
        map.put("1.3.6.1.6.3.15.1.1.3", "usmStatsUnknownUserNames");
        map.put("1.3.6.1.6.3.15.1.1.4", "usmStatsUnknownEngineIDs");
        map.put("1.3.6.1.6.3.15.1.1.5", "usmStatsWrongDigests");
        map.put("1.3.6.1.6.3.15.1.1.6", "usmStatsDecryptionErrors");
        REPORT_MAP = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("DES", PrivDES.ID);
        map.put("3DES", Priv3DES.ID);
        map.put("AES128", PrivAES128.ID);
        map.put("AES192", PrivAES192.ID);
        map.put("AES256", PrivAES256.ID);
        PRIV_MAP = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("SHA", AuthSHA.ID);
        map.put("MD5", AuthMD5.ID);
        map.put("HMAC128SHA224", AuthHMAC128SHA224.ID);
        map.put("HMAC192SHA256", AuthHMAC192SHA256.ID);
        map.put("HMAC256SHA384", AuthHMAC256SHA384.ID);
        map.put("HMAC384SHA512", AuthHMAC384SHA512.ID);
        AUTH_MAP = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("SNMPv1", 0);
        map.put("SNMPv2c", 1);
        map.put("SNMPv3", 3);
        VERSION_MAP = Collections.unmodifiableMap(map);
    }
}

