/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.smb;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.smb.FetchSmb;
import org.apache.nifi.processors.smb.GetSmbFile;
import org.apache.nifi.processors.smb.ListSmb;
import org.apache.nifi.smb.common.SmbProperties;
import org.apache.nifi.smb.common.SmbUtils;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"samba, smb, cifs, files, put"})
@CapabilityDescription(value="Writes the contents of a FlowFile to a samba network location. Use this processor instead of a cifs mounts if share access control is important.Configure the Hostname, Share and Directory accordingly: \\\\[Hostname]\\[Share]\\[path\\to\\Directory]")
@SeeAlso(value={GetSmbFile.class, ListSmb.class, FetchSmb.class})
@ReadsAttributes(value={@ReadsAttribute(attribute="filename", description="The filename to use when writing the FlowFile to the network folder.")})
public class PutSmbFile
extends AbstractProcessor {
    public static final String SHARE_ACCESS_NONE = "none";
    public static final String SHARE_ACCESS_READ = "read";
    public static final String SHARE_ACCESS_READDELETE = "read, delete";
    public static final String SHARE_ACCESS_READWRITEDELETE = "read, write, delete";
    public static final String REPLACE_RESOLUTION = "replace";
    public static final String IGNORE_RESOLUTION = "ignore";
    public static final String FAIL_RESOLUTION = "fail";
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The network host to which files should be written.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SHARE = new PropertyDescriptor.Builder().name("Share").description("The network share to which files should be written. This is the \"first folder\"after the hostname: \\\\hostname\\[share]\\dir1\\dir2").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().name("Directory").description("The network folder to which files should be written. This is the remaining relative path after the share: \\\\hostname\\share\\[dir1\\dir2]. You may use expression language.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor DOMAIN = new PropertyDescriptor.Builder().name("Domain").description("The domain used for authentication. Optional, in most cases username and password is sufficient.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("The username used for authentication. If no username is set then anonymous authentication is attempted.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password used for authentication. Required if Username is set.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor CREATE_DIRS = new PropertyDescriptor.Builder().name("Create Missing Directories").description("If true, then missing destination directories will be created. If false, flowfiles are penalized and sent to failure.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor SHARE_ACCESS = new PropertyDescriptor.Builder().name("Share Access Strategy").description("Indicates which shared access are granted on the file during the write. None is the most restrictive, but the safest setting to prevent corruption.").required(true).defaultValue("none").allowableValues(new String[]{"none", "read", "read, delete", "read, write, delete"}).build();
    public static final PropertyDescriptor CONFLICT_RESOLUTION = new PropertyDescriptor.Builder().name("Conflict Resolution Strategy").description("Indicates what should happen when a file with the same name already exists in the output directory").required(true).defaultValue("replace").allowableValues(new String[]{"replace", "ignore", "fail"}).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The maximum number of files to put in each iteration").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("100").build();
    public static final PropertyDescriptor RENAME_SUFFIX = new PropertyDescriptor.Builder().name("Temporary Suffix").description("A temporary suffix which will be apended to the filename while it's transfering. After the transfer is complete, the suffix will be removed.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that have been successfully written to the output network path are transferred to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that could not be written to the output network path for some reason are transferred to this relationship").build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;
    private SMBClient smbClient = null;
    private Set<SMB2ShareAccess> sharedAccess;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(HOSTNAME);
        descriptors.add(SHARE);
        descriptors.add(DIRECTORY);
        descriptors.add(DOMAIN);
        descriptors.add(USERNAME);
        descriptors.add(PASSWORD);
        descriptors.add(CREATE_DIRS);
        descriptors.add(SHARE_ACCESS);
        descriptors.add(CONFLICT_RESOLUTION);
        descriptors.add(BATCH_SIZE);
        descriptors.add(RENAME_SUFFIX);
        descriptors.add(SmbProperties.SMB_DIALECT);
        descriptors.add(SmbProperties.USE_ENCRYPTION);
        descriptors.add(SmbProperties.ENABLE_DFS);
        descriptors.add(SmbProperties.TIMEOUT);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.smbClient = this.initSmbClient(context);
        switch (context.getProperty(SHARE_ACCESS).getValue()) {
            case "none": {
                this.sharedAccess = Collections.emptySet();
                break;
            }
            case "read": {
                this.sharedAccess = EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ);
                break;
            }
            case "read, delete": {
                this.sharedAccess = EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ, SMB2ShareAccess.FILE_SHARE_DELETE);
                break;
            }
            case "read, write, delete": {
                this.sharedAccess = EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_DELETE);
            }
        }
    }

    @OnStopped
    public void onStopped() {
        if (this.smbClient != null) {
            this.smbClient.close();
            this.smbClient = null;
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> set = new ArrayList<ValidationResult>();
        if (validationContext.getProperty(USERNAME).isSet() && !validationContext.getProperty(PASSWORD).isSet()) {
            set.add(new ValidationResult.Builder().explanation("Password must be set if username is supplied.").build());
        }
        return set;
    }

    SMBClient initSmbClient(ProcessContext context) {
        return SmbUtils.buildSmbClient((PropertyContext)context);
    }

    private void createMissingDirectoriesRecursevly(ComponentLog logger, DiskShare share, String pathToCreate) {
        ArrayList<String> paths = new ArrayList<String>();
        java.io.File file = new java.io.File(pathToCreate);
        paths.add(file.getPath());
        while (file.getParent() != null) {
            String parent = file.getParent();
            paths.add(parent);
            file = new java.io.File(parent);
        }
        Collections.reverse(paths);
        for (String path : paths) {
            if (!share.folderExists(path)) {
                logger.debug("Creating folder {}", new Object[]{path});
                share.mkdir(path);
                continue;
            }
            logger.debug("Folder already exists {}. Moving on", new Object[]{path});
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        List flowFiles = session.get(batchSize);
        if (flowFiles.isEmpty()) {
            return;
        }
        ComponentLog logger = this.getLogger();
        logger.debug("Processing next {} flowfiles", new Object[]{flowFiles.size()});
        String hostname = context.getProperty(HOSTNAME).getValue();
        String shareName = context.getProperty(SHARE).getValue();
        String domain = context.getProperty(DOMAIN).getValue();
        String username = context.getProperty(USERNAME).getValue();
        String password = context.getProperty(PASSWORD).getValue();
        AuthenticationContext ac = null;
        ac = username != null && password != null ? new AuthenticationContext(username, password.toCharArray(), domain) : AuthenticationContext.anonymous();
        try (Connection connection = this.smbClient.connect(hostname);
             Session smbSession = connection.authenticate(ac);
             DiskShare share = (DiskShare)smbSession.connectShare(shareName);){
            for (FlowFile flowFile : flowFiles) {
                String renameSuffixValue;
                long processingStartTime = System.nanoTime();
                String destinationDirectory = context.getProperty(DIRECTORY).evaluateAttributeExpressions(flowFile).getValue();
                String destinationFilename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
                String destinationFullPath = destinationDirectory == null || destinationDirectory.trim().isEmpty() ? destinationFilename : new java.io.File(destinationDirectory, destinationFilename).getPath();
                String destinationFileParentDirectory = new java.io.File(destinationFullPath).getParent();
                Boolean createMissingDirectories = context.getProperty(CREATE_DIRS).asBoolean();
                if (!createMissingDirectories.booleanValue() && !share.folderExists(destinationFileParentDirectory)) {
                    flowFile = session.penalize(flowFile);
                    logger.warn("Penalizing {} and routing to failure as configured because the destination directory ({}) doesn't exist", new Object[]{flowFile, destinationFileParentDirectory});
                    session.transfer(flowFile, REL_FAILURE);
                    continue;
                }
                if (!share.folderExists(destinationFileParentDirectory)) {
                    this.createMissingDirectoriesRecursevly(logger, share, destinationFileParentDirectory);
                }
                String conflictResolution = context.getProperty(CONFLICT_RESOLUTION).getValue();
                if (share.fileExists(destinationFullPath)) {
                    if (conflictResolution.equals(IGNORE_RESOLUTION)) {
                        session.transfer(flowFile, REL_SUCCESS);
                        logger.info("Transferring {} to success as configured because file with same name already exists", new Object[]{flowFile});
                        continue;
                    }
                    if (conflictResolution.equals(FAIL_RESOLUTION)) {
                        flowFile = session.penalize(flowFile);
                        logger.warn("Penalizing {} and routing to failure as configured because file with the same name already exists", new Object[]{flowFile});
                        session.transfer(flowFile, REL_FAILURE);
                        continue;
                    }
                }
                Boolean renameSuffix = (renameSuffixValue = context.getProperty(RENAME_SUFFIX).getValue()) != null && !renameSuffixValue.trim().isEmpty();
                Object finalDestinationFullPath = destinationFullPath;
                if (renameSuffix.booleanValue()) {
                    finalDestinationFullPath = (String)finalDestinationFullPath + renameSuffixValue;
                }
                try (File shareDestinationFile = share.openFile((String)finalDestinationFullPath, EnumSet.of(AccessMask.GENERIC_WRITE), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), this.sharedAccess, SMB2CreateDisposition.FILE_OVERWRITE_IF, EnumSet.of(SMB2CreateOptions.FILE_WRITE_THROUGH));
                     OutputStream shareDestinationFileOutputStream = shareDestinationFile.getOutputStream();){
                    session.exportTo(flowFile, shareDestinationFileOutputStream);
                }
                catch (Exception e) {
                    flowFile = session.penalize(flowFile);
                    session.transfer(flowFile, REL_FAILURE);
                    logger.error("Cannot transfer the file. Penalizing {} and routing to 'failure'", new Object[]{flowFile, e});
                    continue;
                }
                if (renameSuffix.booleanValue()) {
                    try (DiskEntry fileDiskEntry = share.open((String)finalDestinationFullPath, EnumSet.of(AccessMask.DELETE, AccessMask.GENERIC_WRITE), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), this.sharedAccess, SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_WRITE_THROUGH));){
                        destinationFullPath = destinationFullPath.replace("/", "\\");
                        fileDiskEntry.rename(destinationFullPath, true);
                    }
                    catch (Exception e) {
                        flowFile = session.penalize(flowFile);
                        session.transfer(flowFile, REL_FAILURE);
                        logger.error("Cannot rename the file. Penalizing {} and routing to 'failure'", new Object[]{flowFile, e});
                        continue;
                    }
                }
                URI provenanceUri = new URI("smb", hostname, "/" + destinationFullPath.replace('\\', '/'), null);
                long processingTimeInNano = System.nanoTime() - processingStartTime;
                long processingTimeInMilli = TimeUnit.MILLISECONDS.convert(processingTimeInNano, TimeUnit.NANOSECONDS);
                session.getProvenanceReporter().send(flowFile, provenanceUri.toString(), processingTimeInMilli);
                session.transfer(flowFile, REL_SUCCESS);
            }
        }
        catch (Exception e) {
            session.transfer((Collection)flowFiles, REL_FAILURE);
            logger.error("Could not establish smb connection", (Throwable)e);
            this.smbClient.getServerList().unregister(hostname);
        }
    }
}

