/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.json.JsonArray;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.VerifiableReportingTask;
import org.apache.nifi.reporting.s2s.SiteToSiteUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SerializedForm;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public abstract class AbstractSiteToSiteReportingTask
extends AbstractReportingTask
implements VerifiableReportingTask {
    private static final String ESTABLISH_COMMUNICATION = "Establish Site-to-Site Connection";
    protected static final String LAST_EVENT_ID_KEY = "last_event_id";
    protected static final String DESTINATION_URL_PATH = "/nifi";
    protected static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Writer").description("Specifies the Controller Service to use for writing out the records.").identifiesControllerService(RecordSetWriterFactory.class).required(false).build();
    static final PropertyDescriptor ALLOW_NULL_VALUES = new PropertyDescriptor.Builder().name("include-null-values").displayName("Include Null Values").description("Indicate if null values should be included in records. Default will be false").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    protected volatile SiteToSiteClient siteToSiteClient;
    protected volatile RecordSchema recordSchema;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SiteToSiteUtils.DESTINATION_URL);
        properties.add(SiteToSiteUtils.PORT_NAME);
        properties.add(SiteToSiteUtils.SSL_CONTEXT);
        properties.add(SiteToSiteUtils.INSTANCE_URL);
        properties.add(SiteToSiteUtils.COMPRESS);
        properties.add(SiteToSiteUtils.TIMEOUT);
        properties.add(SiteToSiteUtils.BATCH_SIZE);
        properties.add(SiteToSiteUtils.TRANSPORT_PROTOCOL);
        properties.add(SiteToSiteUtils.HTTP_PROXY_HOSTNAME);
        properties.add(SiteToSiteUtils.HTTP_PROXY_PORT);
        properties.add(SiteToSiteUtils.HTTP_PROXY_USERNAME);
        properties.add(SiteToSiteUtils.HTTP_PROXY_PASSWORD);
        properties.add(RECORD_WRITER);
        properties.add(ALLOW_NULL_VALUES);
        return properties;
    }

    public void setup(PropertyContext reportContext) throws IOException {
        if (this.siteToSiteClient == null) {
            this.siteToSiteClient = SiteToSiteUtils.getClient(reportContext, this.getLogger(), null);
        }
    }

    @OnStopped
    public void shutdown() throws IOException {
        SiteToSiteClient client = this.getClient();
        if (client != null) {
            client.close();
            this.siteToSiteClient = null;
        }
    }

    protected SiteToSiteClient getClient() {
        return this.siteToSiteClient;
    }

    protected void sendData(ReportingContext context, Transaction transaction, Map<String, String> attributes, JsonArray jsonArray) throws IOException {
        if (context.getProperty(RECORD_WRITER).isSet()) {
            transaction.send(this.getData(context, new ByteArrayInputStream(jsonArray.toString().getBytes(StandardCharsets.UTF_8)), attributes), attributes);
        } else {
            transaction.send(jsonArray.toString().getBytes(StandardCharsets.UTF_8), attributes);
        }
    }

    protected byte[] getData(ReportingContext context, InputStream in, Map<String, String> attributes) {
        byte[] byArray;
        JsonRecordReader reader = new JsonRecordReader(in, this.recordSchema);
        try {
            RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
            RecordSchema writeSchema = writerFactory.getSchema(null, this.recordSchema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (RecordSetWriter writer = writerFactory.createWriter(this.getLogger(), writeSchema, (OutputStream)out, attributes);){
                Record record;
                writer.beginRecordSet();
                while ((record = reader.nextRecord()) != null) {
                    writer.write(record);
                }
                WriteResult writeResult = writer.finishRecordSet();
                attributes.put(CoreAttributes.MIME_TYPE.key(), writer.getMimeType());
                attributes.putAll(writeResult.getAttributes());
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SchemaNotFoundException | MalformedRecordException e) {
                throw new ProcessException("Failed to write metrics using record writer: " + e.getMessage(), e);
            }
        }
        reader.close();
        return byArray;
    }

    protected void addField(JsonObjectBuilder builder, String key, Boolean value, boolean allowNullValues) {
        if (value != null) {
            builder.add(key, value.booleanValue());
        } else if (allowNullValues) {
            builder.add(key, JsonValue.NULL);
        }
    }

    protected void addField(JsonObjectBuilder builder, String key, Long value, boolean allowNullValues) {
        if (value != null) {
            builder.add(key, value.longValue());
        } else if (allowNullValues) {
            builder.add(key, JsonValue.NULL);
        }
    }

    protected void addField(JsonObjectBuilder builder, String key, Integer value, boolean allowNullValues) {
        if (value != null) {
            builder.add(key, value.intValue());
        } else if (allowNullValues) {
            builder.add(key, JsonValue.NULL);
        }
    }

    protected void addField(JsonObjectBuilder builder, String key, String value, boolean allowNullValues) {
        if (value != null) {
            builder.add(key, value);
        } else if (allowNullValues) {
            builder.add(key, JsonValue.NULL);
        }
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger) {
        ArrayList<ConfigVerificationResult> verificationResults = new ArrayList<ConfigVerificationResult>();
        try (SiteToSiteClient client = SiteToSiteUtils.getClient((PropertyContext)context, verificationLogger, null);){
            Transaction transaction = client.createTransaction(TransferDirection.SEND);
            if (transaction == null) {
                verificationResults.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_COMMUNICATION).outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("All nodes in destination NiFi are currently 'penalized', meaning that there have been recent failures communicating with the destination NiFi, or that the NiFi instance is applying backpressure").build());
            } else {
                transaction.cancel("Just verifying configuration");
                verificationResults.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_COMMUNICATION).outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Established connection to destination NiFi instance and Received indication that it is ready to ready to receive data").build());
            }
        }
        catch (Exception e) {
            verificationLogger.error("Failed to establish site-to-site connection", (Throwable)e);
            verificationResults.add(new ConfigVerificationResult.Builder().verificationStepName(ESTABLISH_COMMUNICATION).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Failed to establish Site-to-Site Connection: " + e).build());
        }
        return verificationResults;
    }

    private class JsonRecordReader
    implements RecordReader {
        private RecordSchema recordSchema;
        private final JsonParser jsonParser;
        private final boolean array;
        private final JsonNode firstJsonNode;
        private boolean firstObjectConsumed = false;
        private final Supplier<DateFormat> dateFormat = () -> DataTypeUtils.getDateFormat((String)RecordFieldType.DATE.getDefaultFormat());
        private final Supplier<DateFormat> timeFormat = () -> DataTypeUtils.getDateFormat((String)RecordFieldType.TIME.getDefaultFormat());
        private final Supplier<DateFormat> timestampFormat = () -> DataTypeUtils.getDateFormat((String)RecordFieldType.TIMESTAMP.getDefaultFormat());

        public JsonRecordReader(InputStream in, RecordSchema recordSchema) throws IOException, MalformedRecordException {
            this.recordSchema = recordSchema;
            try {
                this.jsonParser = new JsonFactory().createParser(in);
                this.jsonParser.setCodec((ObjectCodec)new ObjectMapper());
                JsonToken token = this.jsonParser.nextToken();
                if (token == JsonToken.START_ARRAY) {
                    this.array = true;
                    token = this.jsonParser.nextToken();
                } else {
                    this.array = false;
                }
                this.firstJsonNode = token == JsonToken.START_OBJECT ? (JsonNode)this.jsonParser.readValueAsTree() : null;
            }
            catch (JsonParseException e) {
                throw new MalformedRecordException("Could not parse data as JSON", (Throwable)e);
            }
        }

        public void close() throws IOException {
            this.jsonParser.close();
        }

        public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
            if (this.firstObjectConsumed && !this.array) {
                return null;
            }
            JsonNode nextNode = this.getNextJsonNode();
            if (nextNode == null) {
                return null;
            }
            try {
                return this.convertJsonNodeToRecord(nextNode, this.getSchema(), null, coerceTypes, dropUnknownFields);
            }
            catch (MalformedRecordException mre) {
                throw mre;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new MalformedRecordException("Failed to convert data into a Record object with the given schema", (Throwable)e);
            }
        }

        public RecordSchema getSchema() throws MalformedRecordException {
            return this.recordSchema;
        }

        private JsonNode getNextJsonNode() throws IOException, MalformedRecordException {
            JsonToken token;
            if (!this.firstObjectConsumed) {
                this.firstObjectConsumed = true;
                return this.firstJsonNode;
            }
            block5: while (true) {
                if ((token = this.jsonParser.nextToken()) == null) {
                    return null;
                }
                switch (token) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case START_OBJECT: {
                        return (JsonNode)this.jsonParser.readValueAsTree();
                    }
                    case END_ARRAY: 
                    case START_ARRAY: {
                        return null;
                    }
                }
                break;
            }
            throw new MalformedRecordException("Expected to get a JSON Object but got a token of type " + token.name());
        }

        private Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, String fieldNamePrefix, boolean coerceTypes, boolean dropUnknown) throws IOException, MalformedRecordException {
            HashMap<String, Object> values = new HashMap<String, Object>(schema.getFieldCount() * 2);
            if (dropUnknown) {
                for (RecordField recordField : schema.getFields()) {
                    Object value;
                    JsonNode childNode = this.getChildNode(jsonNode, recordField);
                    if (childNode == null) continue;
                    String fieldName = recordField.getFieldName();
                    if (coerceTypes) {
                        DataType desiredType = recordField.getDataType();
                        String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                        value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                    } else {
                        value = this.getRawNodeValue(childNode, recordField == null ? null : recordField.getDataType());
                    }
                    values.put(fieldName, value);
                }
            } else {
                Iterator fieldNames = jsonNode.fieldNames();
                while (fieldNames.hasNext()) {
                    Object value;
                    String fieldName = (String)fieldNames.next();
                    JsonNode childNode = jsonNode.get(fieldName);
                    RecordField recordField = schema.getField(fieldName).orElse(null);
                    if (coerceTypes && recordField != null) {
                        DataType desiredType = recordField.getDataType();
                        String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                        value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                    } else {
                        value = this.getRawNodeValue(childNode, recordField == null ? null : recordField.getDataType());
                    }
                    values.put(fieldName, value);
                }
            }
            Supplier<String> supplier = () -> jsonNode.toString();
            return new MapRecord(schema, values, SerializedForm.of(supplier, (String)"application/json"), false, dropUnknown);
        }

        private JsonNode getChildNode(JsonNode jsonNode, RecordField field) {
            if (jsonNode.has(field.getFieldName())) {
                return jsonNode.get(field.getFieldName());
            }
            for (String alias : field.getAliases()) {
                if (!jsonNode.has(alias)) continue;
                return jsonNode.get(alias);
            }
            return null;
        }

        protected Object convertField(JsonNode fieldNode, String fieldName, DataType desiredType, boolean dropUnknown) throws IOException, MalformedRecordException {
            if (fieldNode == null || fieldNode.isNull()) {
                return null;
            }
            switch (desiredType.getFieldType()) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case BIGINT: 
                case DECIMAL: 
                case LONG: 
                case SHORT: 
                case STRING: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    Object rawValue = this.getRawNodeValue(fieldNode, null);
                    Object converted = DataTypeUtils.convertType((Object)rawValue, (DataType)desiredType, this.dateFormat, this.timeFormat, this.timestampFormat, (String)fieldName);
                    return converted;
                }
                case MAP: {
                    DataType valueType = ((MapDataType)desiredType).getValueType();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Iterator fieldNameItr = fieldNode.fieldNames();
                    while (fieldNameItr.hasNext()) {
                        String childName = (String)fieldNameItr.next();
                        JsonNode childNode = fieldNode.get(childName);
                        Object childValue = this.convertField(childNode, fieldName, valueType, dropUnknown);
                        map.put(childName, childValue);
                    }
                    return map;
                }
                case ARRAY: {
                    ArrayNode arrayNode = (ArrayNode)fieldNode;
                    int numElements = arrayNode.size();
                    Object[] arrayElements = new Object[numElements];
                    int count = 0;
                    for (JsonNode node : arrayNode) {
                        DataType elementType = ((ArrayDataType)desiredType).getElementType();
                        Object converted = this.convertField(node, fieldName, elementType, dropUnknown);
                        arrayElements[count++] = converted;
                    }
                    return arrayElements;
                }
                case RECORD: {
                    if (fieldNode.isObject()) {
                        if (!(desiredType instanceof RecordDataType)) {
                            return null;
                        }
                        RecordSchema childSchema = ((RecordDataType)desiredType).getChildSchema();
                        if (childSchema == null) {
                            ArrayList<RecordField> fields = new ArrayList<RecordField>();
                            Iterator fieldNameItr = fieldNode.fieldNames();
                            while (fieldNameItr.hasNext()) {
                                fields.add(new RecordField((String)fieldNameItr.next(), RecordFieldType.STRING.getDataType()));
                            }
                            childSchema = new SimpleRecordSchema(fields);
                        }
                        return this.convertJsonNodeToRecord(fieldNode, childSchema, fieldName + ".", true, dropUnknown);
                    }
                    return null;
                }
                case CHOICE: {
                    return DataTypeUtils.convertType((Object)this.getRawNodeValue(fieldNode, null), (DataType)desiredType, (String)fieldName);
                }
            }
            return null;
        }

        protected Object getRawNodeValue(JsonNode fieldNode, DataType dataType) throws IOException {
            if (fieldNode == null || fieldNode.isNull()) {
                return null;
            }
            if (fieldNode.isNumber()) {
                return fieldNode.numberValue();
            }
            if (fieldNode.isBinary()) {
                return fieldNode.binaryValue();
            }
            if (fieldNode.isBoolean()) {
                return fieldNode.booleanValue();
            }
            if (fieldNode.isTextual()) {
                return fieldNode.textValue();
            }
            if (fieldNode.isArray()) {
                DataType elementDataType;
                ArrayNode arrayNode = (ArrayNode)fieldNode;
                int numElements = arrayNode.size();
                Object[] arrayElements = new Object[numElements];
                int count = 0;
                if (dataType != null && dataType.getFieldType() == RecordFieldType.ARRAY) {
                    ArrayDataType arrayDataType = (ArrayDataType)dataType;
                    elementDataType = arrayDataType.getElementType();
                } else {
                    elementDataType = null;
                }
                for (JsonNode node : arrayNode) {
                    Object value = this.getRawNodeValue(node, elementDataType);
                    arrayElements[count++] = value;
                }
                return arrayElements;
            }
            if (fieldNode.isObject()) {
                SimpleRecordSchema childSchema;
                if (dataType != null && RecordFieldType.RECORD == dataType.getFieldType()) {
                    RecordDataType recordDataType = (RecordDataType)dataType;
                    childSchema = recordDataType.getChildSchema();
                } else {
                    childSchema = null;
                }
                if (childSchema == null) {
                    childSchema = new SimpleRecordSchema(Collections.emptyList());
                }
                Iterator fieldNames = fieldNode.fieldNames();
                HashMap<String, Object> childValues = new HashMap<String, Object>();
                while (fieldNames.hasNext()) {
                    String childFieldName = (String)fieldNames.next();
                    Object childValue = this.getRawNodeValue(fieldNode.get(childFieldName), dataType);
                    childValues.put(childFieldName, childValue);
                }
                MapRecord record = new MapRecord((RecordSchema)childSchema, childValues);
                return record;
            }
            return null;
        }
    }
}

