/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.AESKeyedCipherProvider;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.KeyedCipherProvider;
import org.apache.nifi.security.util.crypto.PBKDF2SecureHasher;
import org.apache.nifi.security.util.crypto.RandomIVPBECipherProvider;
import org.bouncycastle.shaded.crypto.Digest;
import org.bouncycastle.shaded.crypto.digests.MD5Digest;
import org.bouncycastle.shaded.crypto.digests.SHA1Digest;
import org.bouncycastle.shaded.crypto.digests.SHA256Digest;
import org.bouncycastle.shaded.crypto.digests.SHA384Digest;
import org.bouncycastle.shaded.crypto.digests.SHA512Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBKDF2CipherProvider
extends RandomIVPBECipherProvider {
    private static final Logger logger = LoggerFactory.getLogger(PBKDF2CipherProvider.class);
    private static final int DEFAULT_SALT_LENGTH = 16;
    private final int iterationCount;
    private final Digest prf;
    private static final String DEFAULT_PRF = "SHA-512";
    private static final int DEFAULT_ITERATION_COUNT = 160000;

    public PBKDF2CipherProvider() {
        this(DEFAULT_PRF, 160000);
    }

    public PBKDF2CipherProvider(String prf, int iterationCount) {
        this.iterationCount = iterationCount;
        if (iterationCount < 160000) {
            logger.warn("The provided iteration count {} is below the recommended minimum {}", (Object)iterationCount, (Object)160000);
        }
        this.prf = this.resolvePRF(prf);
    }

    @Override
    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, byte[] salt, byte[] iv, int keyLength, boolean encryptMode) throws Exception {
        try {
            return this.getInitializedCipher(encryptionMethod, password, salt, iv, keyLength, encryptMode);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessException("Error initializing the cipher", (Throwable)e);
        }
    }

    @Override
    Logger getLogger() {
        return logger;
    }

    @Override
    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, byte[] salt, int keyLength, boolean encryptMode) throws Exception {
        return this.getCipher(encryptionMethod, password, salt, new byte[0], keyLength, encryptMode);
    }

    protected Cipher getInitializedCipher(EncryptionMethod encryptionMethod, String password, byte[] salt, byte[] iv, int keyLength, boolean encryptMode) throws Exception {
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("The encryption method must be specified");
        }
        if (!encryptionMethod.isCompatibleWithStrongKDFs()) {
            throw new IllegalArgumentException(encryptionMethod.name() + " is not compatible with PBKDF2");
        }
        String algorithm = encryptionMethod.getAlgorithm();
        String cipherName = CipherUtility.parseCipherFromAlgorithm(algorithm);
        if (!CipherUtility.isValidKeyLength(keyLength, cipherName)) {
            throw new IllegalArgumentException(String.valueOf(keyLength) + " is not a valid key length for " + cipherName);
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Encryption with an empty password is not supported");
        }
        if (salt == null || salt.length < 16) {
            throw new IllegalArgumentException("The salt must be at least 16 bytes. To generate a salt, use PBKDF2CipherProvider#generateSalt()");
        }
        PBKDF2SecureHasher pbkdf2SecureHasher = new PBKDF2SecureHasher(this.getPRFName(), this.getIterationCount(), salt.length, keyLength / 8);
        byte[] hashBytes = pbkdf2SecureHasher.hashRaw(password.getBytes(StandardCharsets.UTF_8), salt);
        SecretKeySpec tempKey = new SecretKeySpec(hashBytes, algorithm);
        AESKeyedCipherProvider keyedCipherProvider = new AESKeyedCipherProvider();
        return ((KeyedCipherProvider)keyedCipherProvider).getCipher(encryptionMethod, tempKey, iv, encryptMode);
    }

    @Override
    public byte[] generateSalt() {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    @Override
    public int getDefaultSaltLength() {
        return 16;
    }

    protected int getIterationCount() {
        return this.iterationCount;
    }

    protected String getPRFName() {
        if (this.prf != null) {
            return this.prf.getAlgorithmName();
        }
        return "No PRF enabled";
    }

    private Digest resolvePRF(String prf) {
        if (StringUtils.isEmpty((CharSequence)prf)) {
            throw new IllegalArgumentException("Cannot resolve empty PRF");
        }
        String formattedPRF = prf.toLowerCase().replaceAll("[\\W]+", "");
        logger.debug("Resolved PRF {} to {}", (Object)prf, (Object)formattedPRF);
        switch (formattedPRF) {
            case "md5": {
                return new MD5Digest();
            }
            case "sha1": {
                return new SHA1Digest();
            }
            case "sha384": {
                return new SHA384Digest();
            }
            case "sha256": {
                return new SHA256Digest();
            }
            case "sha512": {
                return new SHA512Digest();
            }
        }
        logger.warn("Could not resolve PRF {}. Using default PRF {} instead", (Object)prf, (Object)DEFAULT_PRF);
        return new SHA512Digest();
    }
}

