/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.security.kms.FileBasedKeyProvider;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.kms.KeyStoreKeyProvider;
import org.apache.nifi.security.kms.StaticKeyProvider;
import org.apache.nifi.security.kms.configuration.FileBasedKeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.KeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.KeyStoreKeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.StaticKeyProviderConfiguration;
import org.apache.nifi.security.kms.reader.KeyReaderException;

public class KeyProviderFactory {
    private static final String SECRET_KEY_ALGORITHM = "AES";

    public static KeyProvider getKeyProvider(KeyProviderConfiguration<?> configuration) {
        StaticKeyProvider keyProvider;
        if (configuration instanceof StaticKeyProviderConfiguration) {
            StaticKeyProviderConfiguration providerConfiguration = (StaticKeyProviderConfiguration)configuration;
            try {
                Map<String, SecretKey> secretKeys = KeyProviderFactory.getSecretKeys(providerConfiguration.getKeys());
                keyProvider = new StaticKeyProvider(secretKeys);
            }
            catch (DecoderException e) {
                throw new KeyReaderException("Decoding Hexadecimal Secret Keys failed", e);
            }
        } else if (configuration instanceof FileBasedKeyProviderConfiguration) {
            FileBasedKeyProviderConfiguration providerConfiguration = (FileBasedKeyProviderConfiguration)configuration;
            Path keyProviderPath = Paths.get(providerConfiguration.getLocation(), new String[0]);
            keyProvider = new FileBasedKeyProvider(keyProviderPath, providerConfiguration.getRootKey());
        } else if (configuration instanceof KeyStoreKeyProviderConfiguration) {
            KeyStoreKeyProviderConfiguration providerConfiguration = (KeyStoreKeyProviderConfiguration)configuration;
            KeyStore keyStore = providerConfiguration.getKeyStore();
            keyProvider = new KeyStoreKeyProvider(keyStore, providerConfiguration.getKeyPassword());
        } else {
            throw new UnsupportedOperationException(String.format("Key Provider [%s] not supported", configuration.getKeyProviderClass().getName()));
        }
        return keyProvider;
    }

    private static Map<String, SecretKey> getSecretKeys(Map<String, String> keys) throws DecoderException {
        HashMap<String, SecretKey> secretKeys = new HashMap<String, SecretKey>();
        for (Map.Entry<String, String> keyEntry : keys.entrySet()) {
            byte[] encodedSecretKey = Hex.decodeHex((String)keyEntry.getValue());
            SecretKeySpec secretKey = new SecretKeySpec(encodedSecretKey, SECRET_KEY_ALGORITHM);
            secretKeys.put(keyEntry.getKey(), secretKey);
        }
        return secretKeys;
    }
}

