/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.script;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.lookup.script.BaseScriptedLookupService;

@Tags(value={"lookup", "script", "invoke", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Allows the user to provide a scripted LookupService instance in order to enrich records from an incoming flow file. The script is expected to return an optional string value rather than an arbitrary object (record, e.g.). Also the scripted lookup service should implement StringLookupService, otherwise the getValueType() method must be implemented even though it will be ignored, as SimpleScriptedLookupService returns String as the value type on the script's behalf. Please note that due to a bug in Jython that remains unresolved, it is not possible to use Jython to write a script for this service in Python.")
@DynamicProperty(name="Script Engine Binding property", value="Binding property value passed to Script Runner", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class SimpleScriptedLookupService
extends BaseScriptedLookupService
implements StringLookupService {
    public Set<String> getRequiredKeys() {
        return ((LookupService)this.lookupService.get()).getRequiredKeys();
    }

    public Optional<String> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        return ((LookupService)this.lookupService.get()).lookup(coordinates);
    }
}

