/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script.impl;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.script.impl.BaseScriptRunner;
import org.python.core.PyString;

public class JythonScriptRunner
extends BaseScriptRunner {
    private final CompiledScript compiledScript;

    public JythonScriptRunner(ScriptEngine engine, String scriptBody, String[] modulePaths) throws ScriptException {
        super(engine, scriptBody, JythonScriptRunner.buildPreloads(modulePaths), modulePaths);
        this.compiledScript = ((Compilable)((Object)engine)).compile(this.scriptBody);
    }

    private static String buildPreloads(String[] modulePaths) {
        return "import sys\n" + Arrays.stream(modulePaths).map(modulePath -> "sys.path.append(" + PyString.encode_UnicodeEscape((String)modulePath, (boolean)true) + ")").collect(Collectors.joining("\n")) + "\n";
    }

    @Override
    public String getScriptEngineName() {
        return "python";
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public void run(Bindings bindings) throws ScriptException {
        if (this.compiledScript == null) {
            throw new ScriptException("Jython script has not been successfully compiled");
        }
        this.compiledScript.eval();
    }
}

