/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.nifi.processors.script.engine.ClojureScriptEngine;

public class ClojureScriptEngineFactory
implements ScriptEngineFactory {
    public static final List<String> EXTENSIONS = Collections.unmodifiableList(Collections.singletonList("clj"));
    public static final List<String> MIME_TYPES = Collections.unmodifiableList(Arrays.asList("application/clojure", "text/clojure"));
    public static final List<String> NAMES = Collections.unmodifiableList(Collections.singletonList("Clojure"));
    private static ScriptEngine scriptEngine;

    public ClojureScriptEngineFactory() {
        scriptEngine = this.getScriptEngine();
    }

    @Override
    public String getEngineName() {
        return (String)scriptEngine.get("javax.script.engine");
    }

    @Override
    public String getEngineVersion() {
        return (String)scriptEngine.get("javax.script.engine_version");
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return NAMES;
    }

    @Override
    public String getLanguageName() {
        return (String)scriptEngine.get("javax.script.language");
    }

    @Override
    public String getLanguageVersion() {
        return (String)scriptEngine.get("javax.script.language_version");
    }

    @Override
    public Object getParameter(String key) {
        return key == null ? null : scriptEngine.get(key);
    }

    @Override
    public String getMethodCallSyntax(String object, String method, String ... args) {
        List<String> params = Arrays.asList("(." + method, object);
        params.addAll(Arrays.asList(args));
        return params.stream().collect(Collectors.joining(" ")).concat(")");
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return toDisplay == null ? null : "(println \"" + toDisplay + "\")";
    }

    @Override
    public String getProgram(String ... statements) {
        if (statements == null) {
            return null;
        }
        return Arrays.stream(statements).collect(Collectors.joining("\""));
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new ClojureScriptEngine(this);
    }
}

