/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.nifi.schema.inference.FieldTypeInference;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;

public abstract class HierarchicalSchemaInference<T>
implements SchemaInferenceEngine<T> {
    @Override
    public RecordSchema inferSchema(RecordSource<T> recordSource) throws IOException {
        T rawRecord;
        LinkedHashMap<String, FieldTypeInference> typeMap = new LinkedHashMap<String, FieldTypeInference>();
        String rootElementName = null;
        while ((rawRecord = recordSource.next()) != null) {
            this.inferSchema(rawRecord, typeMap);
            String name = this.getRootName(rawRecord);
            if (rootElementName == null) {
                rootElementName = name;
                continue;
            }
            if (rootElementName.equals(name)) continue;
            rootElementName = null;
        }
        RecordSchema inferredSchema = this.createSchema(typeMap, rootElementName);
        return this.defaultArrayTypes(inferredSchema);
    }

    protected void inferSchema(T rawRecord, Map<String, FieldTypeInference> inferences) {
        if (this.isObject(rawRecord)) {
            BiConsumer<String, Object> inferType = (fieldName, value) -> this.inferType((String)fieldName, (T)value, inferences);
            this.forEachFieldInRecord(rawRecord, inferType);
        } else if (this.isArray(rawRecord)) {
            this.forEachRawRecordInArray(rawRecord, arrayElement -> this.inferSchema(arrayElement, inferences));
        } else {
            throw new IllegalArgumentException("Cannot derive a Record Schema : expected an Array or Complex Object but got " + rawRecord);
        }
    }

    private void inferType(String fieldName, T value, Map<String, FieldTypeInference> inferences) {
        if (value == null) {
            return;
        }
        FieldTypeInference typeInference = inferences.computeIfAbsent(fieldName, key -> new FieldTypeInference());
        if (this.isObject(value)) {
            RecordSchema schema = this.createSchema(value);
            DataType fieldDataType = RecordFieldType.RECORD.getRecordDataType(schema);
            typeInference.addPossibleDataType(fieldDataType);
        } else if (this.isArray(value)) {
            if (this.isEmptyArray(value)) {
                DataType arrayDataType = RecordFieldType.ARRAY.getArrayDataType(null);
                typeInference.addPossibleDataType(arrayDataType);
            } else {
                FieldTypeInference arrayElementTypeInference = new FieldTypeInference();
                this.forEachRawRecordInArray(value, arrayElement -> this.inferType(arrayElement, arrayElementTypeInference));
                DataType elementDataType = arrayElementTypeInference.toDataType();
                DataType arrayDataType = RecordFieldType.ARRAY.getArrayDataType(elementDataType);
                typeInference.addPossibleDataType(arrayDataType);
            }
        } else {
            typeInference.addPossibleDataType(this.getDataType(value));
        }
    }

    private RecordSchema defaultArrayTypes(RecordSchema recordSchema) {
        ArrayList<RecordField> newRecordFields = new ArrayList<RecordField>(recordSchema.getFieldCount());
        for (RecordField childRecordField : recordSchema.getFields()) {
            newRecordFields.add(this.defaultArrayTypes(childRecordField));
        }
        return new SimpleRecordSchema(newRecordFields, recordSchema.getIdentifier());
    }

    private RecordField defaultArrayTypes(RecordField recordField) {
        DataType dataType = recordField.getDataType();
        RecordFieldType fieldType = dataType.getFieldType();
        if (fieldType == RecordFieldType.ARRAY) {
            ArrayDataType arrayDataType = (ArrayDataType)dataType;
            if (arrayDataType.getElementType() == null) {
                return new RecordField(recordField.getFieldName(), RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.STRING.getDataType()), recordField.getDefaultValue(), recordField.getAliases(), recordField.isNullable());
            }
            RecordField elementRecordField = new RecordField(recordField.getFieldName() + "_element", arrayDataType.getElementType(), recordField.isNullable());
            RecordField adjustedElementRecordField = this.defaultArrayTypes(elementRecordField);
            return new RecordField(recordField.getFieldName(), RecordFieldType.ARRAY.getArrayDataType(adjustedElementRecordField.getDataType()), recordField.getDefaultValue(), recordField.getAliases(), recordField.isNullable());
        }
        if (fieldType == RecordFieldType.RECORD) {
            RecordDataType recordDataType = (RecordDataType)dataType;
            RecordSchema childSchema = recordDataType.getChildSchema();
            RecordSchema adjustedRecordSchema = this.defaultArrayTypes(childSchema);
            return new RecordField(recordField.getFieldName(), RecordFieldType.RECORD.getRecordDataType(adjustedRecordSchema), recordField.getDefaultValue(), recordField.getAliases(), recordField.isNullable());
        }
        if (fieldType == RecordFieldType.CHOICE) {
            ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
            List choices = choiceDataType.getPossibleSubTypes();
            LinkedHashSet<DataType> defaulted = new LinkedHashSet<DataType>(choices.size());
            for (DataType choice : choices) {
                RecordField choiceRecordField = new RecordField(recordField.getFieldName() + "_choice", choice, recordField.isNullable());
                RecordField defaultedRecordField = this.defaultArrayTypes(choiceRecordField);
                defaulted.add(defaultedRecordField.getDataType());
            }
            if (defaulted.size() == 1) {
                return new RecordField(recordField.getFieldName(), (DataType)defaulted.iterator().next(), recordField.getDefaultValue(), recordField.getAliases(), recordField.isNullable());
            }
            ArrayList defaultedTypeList = new ArrayList(defaulted);
            return new RecordField(recordField.getFieldName(), RecordFieldType.CHOICE.getChoiceDataType(defaultedTypeList), recordField.getDefaultValue(), recordField.getAliases(), recordField.isNullable());
        }
        return recordField;
    }

    private void inferType(T value, FieldTypeInference typeInference) {
        if (this.isObject(value)) {
            RecordSchema schema = this.createSchema(value);
            DataType fieldDataType = RecordFieldType.RECORD.getRecordDataType(schema);
            typeInference.addPossibleDataType(fieldDataType);
        } else if (this.isArray(value)) {
            if (this.isEmptyArray(value)) {
                DataType arrayDataType = RecordFieldType.ARRAY.getArrayDataType(null);
                typeInference.addPossibleDataType(arrayDataType);
            } else {
                FieldTypeInference arrayElementTypeInference = new FieldTypeInference();
                this.forEachRawRecordInArray(value, arrayElement -> this.inferType(arrayElement, arrayElementTypeInference));
                DataType elementDataType = arrayElementTypeInference.toDataType();
                DataType arrayDataType = RecordFieldType.ARRAY.getArrayDataType(elementDataType);
                typeInference.addPossibleDataType(arrayDataType);
            }
        } else {
            typeInference.addPossibleDataType(this.getDataType(value));
        }
    }

    private RecordSchema createSchema(Map<String, FieldTypeInference> inferences, String rootElementName) {
        ArrayList recordFields = new ArrayList(inferences.size());
        inferences.forEach((fieldName, type) -> recordFields.add(new RecordField(fieldName, type.toDataType())));
        SimpleRecordSchema schema = new SimpleRecordSchema(recordFields);
        schema.setSchemaName(rootElementName);
        return schema;
    }

    protected RecordSchema createSchema(T rawRecord) {
        LinkedHashMap<String, FieldTypeInference> typeMap = new LinkedHashMap<String, FieldTypeInference>();
        this.inferSchema(rawRecord, typeMap);
        RecordSchema schema = this.createSchema(typeMap, this.getRootName(rawRecord));
        return schema;
    }

    protected abstract DataType getDataType(T var1);

    protected abstract boolean isObject(T var1);

    protected abstract boolean isArray(T var1);

    protected abstract boolean isEmptyArray(T var1);

    protected abstract void forEachFieldInRecord(T var1, BiConsumer<String, T> var2);

    protected abstract void forEachRawRecordInArray(T var1, Consumer<T> var2);

    protected abstract String getRootName(T var1);
}

