/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.redis.util;

import java.time.Duration;
import java.util.Objects;
import org.apache.nifi.redis.RedisType;

public class RedisConfig {
    private final RedisType redisMode;
    private final String connectionString;
    private String sentinelMaster;
    private String sentinelUsername;
    private String sentinelPassword;
    private String username;
    private String password;
    private int dbIndex = 0;
    private int timeout = 10000;
    private int clusterMaxRedirects = 5;
    private int poolMaxTotal = 8;
    private int poolMaxIdle = 8;
    private int poolMinIdle = 0;
    private boolean blockWhenExhausted = true;
    private Duration maxWaitTime = Duration.ofSeconds(10L);
    private Duration minEvictableIdleTime = Duration.ofSeconds(60L);
    private Duration timeBetweenEvictionRuns = Duration.ofSeconds(30L);
    private int numTestsPerEvictionRun = -1;
    private boolean testOnCreate = true;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private boolean testWhenIdle = true;

    public RedisConfig(RedisType redisMode, String connectionString) {
        this.redisMode = Objects.requireNonNull(redisMode);
        this.connectionString = Objects.requireNonNull(connectionString);
    }

    public RedisType getRedisMode() {
        return this.redisMode;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getSentinelMaster() {
        return this.sentinelMaster;
    }

    public void setSentinelMaster(String sentinelMaster) {
        this.sentinelMaster = sentinelMaster;
    }

    public String getSentinelUsername() {
        return this.sentinelUsername;
    }

    public void setSentinelUsername(String sentinelUsername) {
        this.sentinelUsername = sentinelUsername;
    }

    public String getSentinelPassword() {
        return this.sentinelPassword;
    }

    public void setSentinelPassword(String sentinelPassword) {
        this.sentinelPassword = sentinelPassword;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getClusterMaxRedirects() {
        return this.clusterMaxRedirects;
    }

    public void setClusterMaxRedirects(int clusterMaxRedirects) {
        this.clusterMaxRedirects = clusterMaxRedirects;
    }

    public int getPoolMaxTotal() {
        return this.poolMaxTotal;
    }

    public void setPoolMaxTotal(int poolMaxTotal) {
        this.poolMaxTotal = poolMaxTotal;
    }

    public int getPoolMaxIdle() {
        return this.poolMaxIdle;
    }

    public void setPoolMaxIdle(int poolMaxIdle) {
        this.poolMaxIdle = poolMaxIdle;
    }

    public int getPoolMinIdle() {
        return this.poolMinIdle;
    }

    public void setPoolMinIdle(int poolMinIdle) {
        this.poolMinIdle = poolMinIdle;
    }

    public boolean getBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public Duration getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(Duration maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public Duration getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public void setMinEvictableIdleTime(Duration minEvictableIdleTime) {
        this.minEvictableIdleTime = minEvictableIdleTime;
    }

    public Duration getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public void setTimeBetweenEvictionRuns(Duration timeBetweenEvictionRuns) {
        this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean getTestWhenIdle() {
        return this.testWhenIdle;
    }

    public void setTestWhenIdle(boolean testWhenIdle) {
        this.testWhenIdle = testWhenIdle;
    }
}

