/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.redis.service;

import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.redis.RedisConnectionPool;
import org.apache.nifi.redis.RedisType;
import org.apache.nifi.redis.util.RedisUtils;
import org.apache.nifi.ssl.SSLContextService;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

@Tags(value={"redis", "cache"})
@CapabilityDescription(value="A service that provides connections to Redis.")
public class RedisConnectionPoolService
extends AbstractControllerService
implements RedisConnectionPool {
    private volatile PropertyContext context;
    private volatile RedisType redisType;
    private volatile JedisConnectionFactory connectionFactory;
    private volatile SSLContext sslContext;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return RedisUtils.REDIS_CONNECTION_PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return RedisUtils.validate((ValidationContext)validationContext);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
        if (context.getProperty(RedisUtils.SSL_CONTEXT_SERVICE).isSet()) {
            SSLContextService sslContextService = (SSLContextService)context.getProperty(RedisUtils.SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
            this.sslContext = sslContextService.createContext();
        }
        String redisMode = context.getProperty(RedisUtils.REDIS_MODE).getValue();
        this.redisType = RedisType.fromDisplayName((String)redisMode);
    }

    @OnDisabled
    public void onDisabled() {
        if (this.connectionFactory != null) {
            this.connectionFactory.destroy();
            this.connectionFactory = null;
            this.redisType = null;
            this.context = null;
            this.sslContext = null;
        }
    }

    public RedisType getRedisType() {
        return this.redisType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedisConnection getConnection() {
        if (this.connectionFactory == null) {
            RedisConnectionPoolService redisConnectionPoolService = this;
            synchronized (redisConnectionPoolService) {
                if (this.connectionFactory == null) {
                    this.connectionFactory = RedisUtils.createConnectionFactory((PropertyContext)this.context, (SSLContext)this.sslContext);
                }
            }
        }
        return this.connectionFactory.getConnection();
    }
}

