/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.pattern;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.pattern.DiscontinuedException;
import org.apache.nifi.processor.util.pattern.ErrorTypes;
import org.apache.nifi.processor.util.pattern.PartialFunctions;
import org.apache.nifi.processor.util.pattern.RoutingResult;

public class ExceptionHandler<C> {
    private Function<Exception, ErrorTypes> mapException;
    private BiFunction<C, ErrorTypes, ErrorTypes.Result> adjustError;
    private OnError<C, ?> onError;

    public void mapException(Function<Exception, ErrorTypes> mapException) {
        this.mapException = mapException;
    }

    public void adjustError(BiFunction<C, ErrorTypes, ErrorTypes.Result> adjustError) {
        this.adjustError = adjustError;
    }

    public void onError(OnError<C, ?> onError) {
        this.onError = onError;
    }

    public <I> boolean execute(C context, I input, Procedure<I> procedure) throws ProcessException, DiscontinuedException {
        return this.execute(context, input, procedure, this.onError);
    }

    public <I> boolean execute(C context, I input, Procedure<I> procedure, OnError<C, I> onError) throws ProcessException, DiscontinuedException {
        try {
            procedure.apply(input);
            return true;
        }
        catch (Exception e) {
            if (this.mapException == null) {
                throw new ProcessException("An exception was thrown: " + e, (Throwable)e);
            }
            ErrorTypes type = this.mapException.apply(e);
            ErrorTypes.Result result = this.adjustError != null ? this.adjustError.apply(context, type) : new ErrorTypes.Result(type.destination(), type.penalty());
            if (onError == null) {
                throw new IllegalStateException("OnError is not set.");
            }
            onError.apply(context, input, result, e);
            return false;
        }
    }

    private static FlowFile penalize(ProcessContext context, ProcessSession session, FlowFile flowFile, ErrorTypes.Penalty penalty) {
        switch (penalty) {
            case Penalize: {
                return session.penalize(flowFile);
            }
            case Yield: {
                context.yield();
            }
        }
        return flowFile;
    }

    public static <C> OnError<C, FlowFile> createOnError(ProcessContext context, ProcessSession session, RoutingResult routingResult, Relationship relFailure, Relationship relRetry) {
        return (fc, input, result, e) -> {
            PartialFunctions.FlowFileGroup flowFileGroup = () -> Collections.singletonList(input);
            ExceptionHandler.createOnGroupError(context, session, routingResult, relFailure, relRetry).apply(fc, flowFileGroup, result, e);
        };
    }

    public static <C, I extends PartialFunctions.FlowFileGroup> OnError<C, I> createOnGroupError(ProcessContext context, ProcessSession session, RoutingResult routingResult, Relationship relFailure, Relationship relRetry) {
        return (c, g, r, e) -> {
            Relationship routeTo = switch (r.destination()) {
                case ErrorTypes.Destination.Failure -> relFailure;
                case ErrorTypes.Destination.Retry -> relRetry;
                case ErrorTypes.Destination.Self -> Relationship.SELF;
                default -> {
                    if (e instanceof ProcessException) {
                        throw (ProcessException)e;
                    }
                    String inputs = null;
                    if (g != null) {
                        List<FlowFile> flowFiles = g.getFlowFiles();
                        switch (flowFiles.size()) {
                            case 0: {
                                inputs = "[]";
                                break;
                            }
                            case 1: {
                                inputs = flowFiles.get(0);
                                break;
                            }
                            default: {
                                inputs = String.format("%d FlowFiles including %s", flowFiles.size(), flowFiles.get(0));
                            }
                        }
                    }
                    throw new ProcessException(String.format("Failed to process %s due to %s", inputs, e), (Throwable)e);
                }
            };
            for (FlowFile f : g.getFlowFiles()) {
                FlowFile maybePenalized = ExceptionHandler.penalize(context, session, f, r.penalty());
                routingResult.routeTo(maybePenalized, routeTo);
            }
        };
    }

    public static interface OnError<C, I> {
        public void apply(C var1, I var2, ErrorTypes.Result var3, Exception var4);

        default public OnError<C, I> andThen(OnError<C, I> after) {
            return (c, i, r, e) -> {
                this.apply(c, i, r, e);
                after.apply(c, i, r, e);
            };
        }
    }

    @FunctionalInterface
    public static interface Procedure<I> {
        public void apply(I var1) throws Exception;
    }
}

