/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.proxy;

import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.proxy.SocksVersion;

@CapabilityDescription(value="Provides a set of configurations for different NiFi components to use a proxy server.")
@Tags(value={"Proxy"})
public class StandardProxyConfigurationService
extends AbstractControllerService
implements ProxyConfigurationService {
    public static final PropertyDescriptor PROXY_TYPE = new PropertyDescriptor.Builder().name("proxy-type").displayName("Proxy Type").description("Proxy type.").allowableValues((Enum[])Proxy.Type.values()).defaultValue(Proxy.Type.DIRECT.name()).required(true).build();
    public static final PropertyDescriptor SOCKS_VERSION = new PropertyDescriptor.Builder().name("socks-version").displayName("SOCKS Version").description("SOCKS Protocol Version").allowableValues((Enum[])SocksVersion.values()).defaultValue(SocksVersion.SOCKS5.name()).dependsOn(PROXY_TYPE, Proxy.Type.SOCKS.name(), new String[0]).required(true).build();
    public static final PropertyDescriptor PROXY_SERVER_HOST = new PropertyDescriptor.Builder().name("proxy-server-host").displayName("Proxy Server Host").description("Proxy server hostname or ip-address.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor PROXY_SERVER_PORT = new PropertyDescriptor.Builder().name("proxy-server-port").displayName("Proxy Server Port").description("Proxy server port number.").addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor PROXY_USER_NAME = new PropertyDescriptor.Builder().name("proxy-user-name").displayName("Proxy User Name").description("The name of the proxy client for user authentication.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor PROXY_USER_PASSWORD = new PropertyDescriptor.Builder().name("proxy-user-password").displayName("Proxy User Password").description("The password of the proxy client for user authentication.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(true).build();
    private volatile ProxyConfiguration configuration = ProxyConfiguration.DIRECT_CONFIGURATION;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(PROXY_TYPE);
        properties.add(SOCKS_VERSION);
        properties.add(PROXY_SERVER_HOST);
        properties.add(PROXY_SERVER_PORT);
        properties.add(PROXY_USER_NAME);
        properties.add(PROXY_USER_PASSWORD);
        return properties;
    }

    @OnEnabled
    public void setConfiguredValues(ConfigurationContext context) {
        this.configuration = new ProxyConfiguration();
        Proxy.Type proxyType = Proxy.Type.valueOf(context.getProperty(PROXY_TYPE).getValue());
        this.configuration.setProxyType(proxyType);
        this.configuration.setSocksVersion(proxyType == Proxy.Type.SOCKS ? SocksVersion.valueOf((String)context.getProperty(SOCKS_VERSION).getValue()) : null);
        this.configuration.setProxyServerHost(context.getProperty(PROXY_SERVER_HOST).evaluateAttributeExpressions().getValue());
        this.configuration.setProxyServerPort(context.getProperty(PROXY_SERVER_PORT).evaluateAttributeExpressions().asInteger());
        this.configuration.setProxyUserName(context.getProperty(PROXY_USER_NAME).evaluateAttributeExpressions().getValue());
        this.configuration.setProxyUserPassword(context.getProperty(PROXY_USER_PASSWORD).evaluateAttributeExpressions().getValue());
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Proxy.Type proxyType = Proxy.Type.valueOf(validationContext.getProperty(PROXY_TYPE).getValue());
        if (Proxy.Type.DIRECT.equals((Object)proxyType)) {
            return Collections.emptyList();
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (!validationContext.getProperty(PROXY_SERVER_HOST).isSet()) {
            results.add(new ValidationResult.Builder().subject(PROXY_SERVER_HOST.getDisplayName()).explanation("required").valid(false).build());
        }
        if (!validationContext.getProperty(PROXY_SERVER_PORT).isSet()) {
            results.add(new ValidationResult.Builder().subject(PROXY_SERVER_PORT.getDisplayName()).explanation("required").valid(false).build());
        }
        return results;
    }

    public ProxyConfiguration getConfiguration() {
        return this.configuration;
    }
}

