/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.util.Objects;
import javax.crypto.SecretKey;
import org.apache.nifi.encrypt.KeyedCipherPropertyEncryptor;
import org.apache.nifi.encrypt.PasswordBasedCipherPropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptionMethod;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertySecretKeyProvider;
import org.apache.nifi.encrypt.StandardPropertySecretKeyProvider;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.AESKeyedCipherProvider;
import org.apache.nifi.security.util.crypto.KeyedCipherProvider;
import org.apache.nifi.security.util.crypto.NiFiLegacyCipherProvider;
import org.apache.nifi.security.util.crypto.PBECipherProvider;

public class PropertyEncryptorBuilder {
    private static final PropertySecretKeyProvider SECRET_KEY_PROVIDER = new StandardPropertySecretKeyProvider();
    private final String password;
    private String algorithm = PropertyEncryptionMethod.NIFI_ARGON2_AES_GCM_256.toString();

    public PropertyEncryptorBuilder(String password) {
        Objects.requireNonNull(password, "Password required");
        this.password = password;
    }

    public PropertyEncryptorBuilder setAlgorithm(String algorithm) {
        Objects.requireNonNull(algorithm, "Algorithm required");
        this.algorithm = algorithm;
        return this;
    }

    public PropertyEncryptor build() {
        PropertyEncryptionMethod propertyEncryptionMethod = this.findPropertyEncryptionAlgorithm(this.algorithm);
        if (propertyEncryptionMethod == null) {
            return this.getPasswordBasedCipherPropertyEncryptor();
        }
        AESKeyedCipherProvider keyedCipherProvider = new AESKeyedCipherProvider();
        SecretKey secretKey = SECRET_KEY_PROVIDER.getSecretKey(propertyEncryptionMethod, this.password);
        EncryptionMethod encryptionMethod = propertyEncryptionMethod.getEncryptionMethod();
        return new KeyedCipherPropertyEncryptor((KeyedCipherProvider)keyedCipherProvider, encryptionMethod, secretKey);
    }

    private PasswordBasedCipherPropertyEncryptor getPasswordBasedCipherPropertyEncryptor() {
        EncryptionMethod encryptionMethod = this.findEncryptionMethod(this.algorithm);
        if (encryptionMethod.isPBECipher()) {
            NiFiLegacyCipherProvider cipherProvider = new NiFiLegacyCipherProvider();
            return new PasswordBasedCipherPropertyEncryptor((PBECipherProvider)cipherProvider, encryptionMethod, this.password);
        }
        String message = String.format("Algorithm [%s] not supported for Sensitive Properties", encryptionMethod.getAlgorithm());
        throw new UnsupportedOperationException(message);
    }

    private PropertyEncryptionMethod findPropertyEncryptionAlgorithm(String algorithm) {
        PropertyEncryptionMethod foundPropertyEncryptionMethod = null;
        for (PropertyEncryptionMethod propertyEncryptionMethod : PropertyEncryptionMethod.values()) {
            if (!propertyEncryptionMethod.toString().equals(algorithm)) continue;
            foundPropertyEncryptionMethod = propertyEncryptionMethod;
            break;
        }
        return foundPropertyEncryptionMethod;
    }

    private EncryptionMethod findEncryptionMethod(String algorithm) {
        EncryptionMethod encryptionMethod = EncryptionMethod.forAlgorithm((String)algorithm);
        if (encryptionMethod == null) {
            String message = String.format("Encryption Method not found for Algorithm [%s]", algorithm);
            throw new IllegalArgumentException(message);
        }
        return encryptionMethod;
    }
}

