/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.nifi.encrypt.CipherPropertyEncryptor;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.KeyedCipherProvider;

class KeyedCipherPropertyEncryptor
extends CipherPropertyEncryptor {
    private static final int INITIALIZATION_VECTOR_LENGTH = 16;
    private static final int ARRAY_START = 0;
    private static final boolean ENCRYPT = true;
    private static final boolean DECRYPT = false;
    private final KeyedCipherProvider cipherProvider;
    private final EncryptionMethod encryptionMethod;
    private final SecretKey secretKey;
    private final SecureRandom secureRandom;
    private final String description;

    protected KeyedCipherPropertyEncryptor(KeyedCipherProvider cipherProvider, EncryptionMethod encryptionMethod, SecretKey secretKey) {
        this.cipherProvider = cipherProvider;
        this.encryptionMethod = encryptionMethod;
        this.secretKey = secretKey;
        this.secureRandom = new SecureRandom();
        this.description = String.format("%s Encryption Method [%s] Key Algorithm [%s] Key Bytes [%d]", this.getClass().getSimpleName(), encryptionMethod.getAlgorithm(), secretKey.getAlgorithm(), secretKey.getEncoded().length);
    }

    @Override
    protected Cipher getDecryptionCipher(byte[] encryptedBinary) {
        byte[] initializationVector = this.readInitializationVector(encryptedBinary);
        return this.getCipher(initializationVector, false);
    }

    @Override
    protected Cipher getEncryptionCipher(byte[] encodedParameters) {
        return this.getCipher(encodedParameters, true);
    }

    @Override
    protected byte[] getCipherBinary(byte[] encryptedBinary) {
        return Arrays.copyOfRange(encryptedBinary, 16, encryptedBinary.length);
    }

    @Override
    protected byte[] getEncodedParameters() {
        byte[] initializationVector = new byte[16];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    private Cipher getCipher(byte[] initializationVector, boolean encrypt) {
        try {
            return this.cipherProvider.getCipher(this.encryptionMethod, this.secretKey, initializationVector, encrypt);
        }
        catch (Exception e) {
            String message = String.format("Failed to get Cipher for Algorithm [%s]", this.encryptionMethod.getAlgorithm());
            throw new EncryptionException(message, e);
        }
    }

    private byte[] readInitializationVector(byte[] binary) {
        byte[] initializationVector = new byte[16];
        System.arraycopy(binary, 0, initializationVector, 0, 16);
        return initializationVector;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (this == object) {
            equals = true;
        } else if (object instanceof KeyedCipherPropertyEncryptor) {
            KeyedCipherPropertyEncryptor encryptor = (KeyedCipherPropertyEncryptor)object;
            equals = Objects.equals(this.encryptionMethod, encryptor.encryptionMethod) && Objects.equals(this.secretKey, encryptor.secretKey);
        }
        return equals;
    }

    public int hashCode() {
        return Objects.hash(this.encryptionMethod, this.secretKey);
    }

    public String toString() {
        return this.description;
    }
}

