/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hpe;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.util.hpe.HpeProperties;
import org.apache.nifi.util.hpe.HpePropertiesLoader;
import org.apache.nifi.util.mapr.MapRComponentsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HpePropertiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(HpePropertiesUtils.class);
    public static final String MAPR_HADOOP_PROPERTY_PROVIDER = "$HadoopProvider";
    public static final String SERVER_TRUSTSTORE_PASSWORD = "ssl.server.truststore.password";
    public static final String SERVER_TRUSTSTORE_LOCATION = "ssl.server.truststore.location";
    public static final String SERVER_TRUSTSTORE_TYPE = "ssl.server.truststore.type";
    public static final String SERVER_KEYSTORE_KEY_PASSWORD = "ssl.server.keystore.keypassword";
    public static final String SERVER_KEYSTORE_PASSWORD = "ssl.server.keystore.password";
    public static final String SERVER_KEYSTORE_LOCATION = "ssl.server.keystore.location";
    public static final String SERVER_KEYSTORE_TYPE = "ssl.server.keystore.type";
    private static final String PASSWORD_SUFFIX = "password";
    private static final String OIDC_SECURITY_SUFFIX = "nifi.security.user.oidc";
    private static final String HADOOP_COMPONENT_NAME = "hadoop";
    private static final Path HADOOP_CONF_PATH = HpePropertiesUtils.getHadoopConfFolder();
    private static final String HADOOP_HOME_PROPERTY = "hadoop.home.dir";
    private static final String HADOOP_CONF_INTERNAL_PATH = "etc/hadoop";
    private static final String HADOOP_CONF_CORE_SITE_XML = "core-site.xml";
    private static final String HADOOP_CONF_SSL_SERVER_XML = "ssl-server.xml";
    private static final String HADOOP_CONF_SSL_CLIENT_XML = "ssl-client.xml";
    private static final String HADOOP_CONF_HDFS_SITE_XML = "hdfs-site.xml";
    private static volatile HpeProperties hpeProperties = null;
    private static volatile boolean sslResourceLoaded = false;
    private static final Map<String, String> mapNifiToHadoopProperties = new HashMap<String, String>();
    private static final List<String> sslProperties = new ArrayList<String>();
    private static final List<String> hadoopClientConfigs = new ArrayList<String>();

    public static List<String> getHadoopClientConfigs() {
        return new ArrayList<String>(hadoopClientConfigs);
    }

    public static String getHadoopProperty(String key) {
        if (key.startsWith(OIDC_SECURITY_SUFFIX)) {
            return HpePropertiesUtils.getOidcSecurityProperty(key);
        }
        String hadoopKey = mapNifiToHadoopProperties.get(key);
        if (hadoopKey == null) {
            throw new RuntimeException(String.format("No mapping for property '%s'", key));
        }
        if (hadoopKey.toLowerCase().endsWith(PASSWORD_SUFFIX)) {
            return HpePropertiesUtils.getPassword(hadoopKey);
        }
        return HpePropertiesUtils.getProperty(hadoopKey);
    }

    public static String getProperty(String property) {
        HpePropertiesUtils.lazyLoadSslResources(property);
        return HpePropertiesUtils.getHpeProperties().get(property);
    }

    public static String getPassword(String property) {
        HpePropertiesUtils.lazyLoadSslResources(property);
        char[] data = HpePropertiesUtils.getHpeProperties().getPassword(property);
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    private static String getOidcSecurityProperty(String key) {
        switch (key) {
            case "nifi.security.user.oidc.discovery.url": {
                return HpePropertiesUtils.getHpeProperties().getOidcDiscoveryUrl();
            }
            case "nifi.security.user.oidc.client.id": {
                return HpePropertiesUtils.getHpeProperties().getOidcClientId();
            }
            case "nifi.security.user.oidc.client.secret": {
                return HpePropertiesUtils.getHpeProperties().getOidcClientSecret();
            }
            case "nifi.security.user.oidc.claim.identifying.user": {
                return HpePropertiesUtils.getHpeProperties().getUserClaim();
            }
        }
        logger.warn("OIDC property '{}' can't be loaded from Hadoop", (Object)key);
        return null;
    }

    private static void lazyLoadSslResources(String propertyKey) {
        if (!sslResourceLoaded && sslProperties.contains(propertyKey)) {
            HpeProperties properties = HpePropertiesUtils.getHpeProperties();
            properties.addResource(HADOOP_CONF_PATH.toString(), HADOOP_CONF_SSL_SERVER_XML);
            sslResourceLoaded = true;
        }
    }

    private static synchronized HpeProperties getHpeProperties() {
        if (hpeProperties == null) {
            hpeProperties = HpePropertiesLoader.getHpeProperties();
            hpeProperties.addResource(HADOOP_CONF_PATH.toString(), HADOOP_CONF_CORE_SITE_XML);
        }
        return hpeProperties;
    }

    private static Path getHadoopConfFolder() {
        Path hadoopFolder;
        try {
            hadoopFolder = MapRComponentsUtils.getComponentFolder((String)HADOOP_COMPONENT_NAME);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HpePropertiesUtils.setHadoopHomeIfNotSet(hadoopFolder.toString());
        return hadoopFolder.resolve(HADOOP_CONF_INTERNAL_PATH);
    }

    private static void setHadoopHomeIfNotSet(String hadoopFolder) {
        String defaultHadoopHome = System.getProperty(HADOOP_HOME_PROPERTY, "");
        if (defaultHadoopHome.isEmpty()) {
            System.setProperty(HADOOP_HOME_PROPERTY, hadoopFolder);
        }
    }

    static {
        mapNifiToHadoopProperties.put("nifi.security.keystore", SERVER_KEYSTORE_LOCATION);
        mapNifiToHadoopProperties.put("nifi.security.keystoreType", SERVER_KEYSTORE_TYPE);
        mapNifiToHadoopProperties.put("nifi.security.keystorePasswd", SERVER_KEYSTORE_PASSWORD);
        mapNifiToHadoopProperties.put("nifi.security.keyPasswd", SERVER_KEYSTORE_KEY_PASSWORD);
        mapNifiToHadoopProperties.put("nifi.security.truststore", SERVER_TRUSTSTORE_LOCATION);
        mapNifiToHadoopProperties.put("nifi.security.truststoreType", SERVER_TRUSTSTORE_TYPE);
        mapNifiToHadoopProperties.put("nifi.security.truststorePasswd", SERVER_TRUSTSTORE_PASSWORD);
        sslProperties.add(SERVER_KEYSTORE_LOCATION);
        sslProperties.add(SERVER_KEYSTORE_TYPE);
        sslProperties.add(SERVER_KEYSTORE_PASSWORD);
        sslProperties.add(SERVER_KEYSTORE_KEY_PASSWORD);
        sslProperties.add(SERVER_TRUSTSTORE_LOCATION);
        sslProperties.add(SERVER_TRUSTSTORE_TYPE);
        sslProperties.add(SERVER_TRUSTSTORE_PASSWORD);
        hadoopClientConfigs.add(HADOOP_CONF_PATH.resolve(HADOOP_CONF_HDFS_SITE_XML).toString());
        hadoopClientConfigs.add(HADOOP_CONF_PATH.resolve(HADOOP_CONF_SSL_CLIENT_XML).toString());
    }
}

