/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.prometheus.util;

import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.prometheus.util.BulletinMetricsRegistry;
import org.apache.nifi.prometheus.util.ConnectionAnalyticsMetricsRegistry;
import org.apache.nifi.prometheus.util.JvmMetricsRegistry;
import org.apache.nifi.prometheus.util.NiFiMetricsRegistry;
import org.apache.nifi.util.StringUtils;

public class PrometheusMetricsUtil {
    public static final AllowableValue METRICS_STRATEGY_ROOT = new AllowableValue("Root Process Group", "Root Process Group", "Send rollup metrics for the entire root process group");
    public static final AllowableValue METRICS_STRATEGY_PG = new AllowableValue("All Process Groups", "All Process Groups", "Send metrics for each process group");
    public static final AllowableValue METRICS_STRATEGY_COMPONENTS = new AllowableValue("All Components", "All Components", "Send metrics for each component in the system, to include processors, connections, controller services, etc.");
    private static final CollectorRegistry CONNECTION_ANALYTICS_REGISTRY = new CollectorRegistry();
    private static final CollectorRegistry BULLETIN_REGISTRY = new CollectorRegistry();
    protected static final String DEFAULT_LABEL_STRING = "";
    private static final double MAXIMUM_BACKPRESSURE = 1.0;
    private static final double UNDEFINED_BACKPRESSURE = -1.0;
    public static final AllowableValue CLIENT_NONE = new AllowableValue("No Authentication", "No Authentication", "ReportingTask will not authenticate clients. Anyone can communicate with this ReportingTask anonymously");
    public static final AllowableValue CLIENT_WANT = new AllowableValue("Want Authentication", "Want Authentication", "ReportingTask will try to verify the client but if unable to verify will allow the client to communicate anonymously");
    public static final AllowableValue CLIENT_NEED = new AllowableValue("Need Authentication", "Need Authentication", "ReportingTask will reject communications from any client unless the client provides a certificate that is trusted by the TrustStorespecified in the SSL Context Service");
    public static final PropertyDescriptor METRICS_ENDPOINT_PORT = new PropertyDescriptor.Builder().name("prometheus-reporting-task-metrics-endpoint-port").displayName("Prometheus Metrics Endpoint Port").description("The Port where prometheus metrics can be accessed").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("9092").addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor INSTANCE_ID = new PropertyDescriptor.Builder().name("prometheus-reporting-task-instance-id").displayName("Instance ID").description("Id of this NiFi instance to be included in the metrics sent to Prometheus").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("${hostname(true)}").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("prometheus-reporting-task-client-auth").displayName("Client Authentication").description("Specifies whether or not the Reporting Task should authenticate clients. This value is ignored if the <SSL Context Service> Property is not specified or the SSL Context provided uses only a KeyStore and not a TrustStore.").required(true).allowableValues(new AllowableValue[]{CLIENT_NONE, CLIENT_WANT, CLIENT_NEED}).defaultValue(CLIENT_NONE.getValue()).build();

    public static CollectorRegistry createNifiMetrics(NiFiMetricsRegistry nifiMetricsRegistry, ProcessGroupStatus status, String instId, String parentProcessGroupId, String compType, String metricsStrategy) {
        String instanceId = StringUtils.isEmpty((String)instId) ? DEFAULT_LABEL_STRING : instId;
        String parentPGId = StringUtils.isEmpty((String)parentProcessGroupId) ? DEFAULT_LABEL_STRING : parentProcessGroupId;
        String componentType = StringUtils.isEmpty((String)compType) ? DEFAULT_LABEL_STRING : compType;
        String componentId = StringUtils.isEmpty((String)status.getId()) ? DEFAULT_LABEL_STRING : status.getId();
        String componentName = StringUtils.isEmpty((String)status.getName()) ? DEFAULT_LABEL_STRING : status.getName();
        nifiMetricsRegistry.setDataPoint(status.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getFlowFilesTransferred(), "AMOUNT_FLOWFILES_TRANSFERRED", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getBytesSent(), "AMOUNT_BYTES_SENT", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getBytesRead().longValue(), "AMOUNT_BYTES_READ", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getBytesWritten().longValue(), "AMOUNT_BYTES_WRITTEN", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getBytesTransferred(), "AMOUNT_BYTES_TRANSFERRED", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getOutputContentSize().longValue(), "SIZE_CONTENT_OUTPUT_TOTAL", instanceId, componentType, componentName, componentId, parentPGId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        nifiMetricsRegistry.setDataPoint(status.getInputContentSize().longValue(), "SIZE_CONTENT_INPUT_TOTAL", instanceId, componentType, componentName, componentId, parentPGId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        nifiMetricsRegistry.setDataPoint(status.getQueuedContentSize().longValue(), "SIZE_CONTENT_QUEUED_TOTAL", instanceId, componentType, componentName, componentId, parentPGId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        nifiMetricsRegistry.setDataPoint(status.getOutputCount().intValue(), "AMOUNT_ITEMS_OUTPUT", instanceId, componentType, componentName, componentId, parentPGId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        nifiMetricsRegistry.setDataPoint(status.getInputCount().intValue(), "AMOUNT_ITEMS_INPUT", instanceId, componentType, componentName, componentId, parentPGId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        nifiMetricsRegistry.setDataPoint(status.getQueuedCount().intValue(), "AMOUNT_ITEMS_QUEUED", instanceId, componentType, componentName, componentId, parentPGId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        nifiMetricsRegistry.setDataPoint(status.getActiveThreadCount() == null ? 0.0 : (double)status.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", instanceId, componentType, componentName, componentId, parentPGId);
        nifiMetricsRegistry.setDataPoint(status.getTerminatedThreadCount() == null ? 0.0 : (double)status.getTerminatedThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_TERMINATED", instanceId, componentType, componentName, componentId, parentPGId);
        if (METRICS_STRATEGY_PG.getValue().equals(metricsStrategy) || METRICS_STRATEGY_COMPONENTS.getValue().equals(metricsStrategy)) {
            status.getProcessGroupStatus().forEach(childGroupStatus -> PrometheusMetricsUtil.createNifiMetrics(nifiMetricsRegistry, childGroupStatus, instanceId, componentId, "ProcessGroup", metricsStrategy));
        }
        if (METRICS_STRATEGY_COMPONENTS.getValue().equals(metricsStrategy)) {
            Boolean isTransmitting;
            String portComponentType;
            String parentId;
            String portComponentName;
            String portComponentId;
            for (ProcessorStatus processorStatus : status.getProcessorStatus()) {
                Map counters = processorStatus.getCounters();
                if (counters != null) {
                    counters.entrySet().stream().forEach(entry -> nifiMetricsRegistry.setDataPoint(((Long)entry.getValue()).longValue(), "PROCESSOR_COUNTERS", processorStatus.getName(), (String)entry.getKey(), processorStatus.getId(), instanceId));
                }
                String procComponentType = "Processor";
                String procComponentId = StringUtils.isEmpty((String)processorStatus.getId()) ? DEFAULT_LABEL_STRING : processorStatus.getId();
                String procComponentName = StringUtils.isEmpty((String)processorStatus.getName()) ? DEFAULT_LABEL_STRING : processorStatus.getName();
                String parentId2 = StringUtils.isEmpty((String)processorStatus.getGroupId()) ? DEFAULT_LABEL_STRING : processorStatus.getGroupId();
                nifiMetricsRegistry.setDataPoint(processorStatus.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(processorStatus.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(processorStatus.getFlowFilesRemoved(), "AMOUNT_FLOWFILES_REMOVED", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(processorStatus.getBytesSent(), "AMOUNT_BYTES_SENT", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(processorStatus.getBytesRead(), "AMOUNT_BYTES_READ", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(processorStatus.getBytesWritten(), "AMOUNT_BYTES_WRITTEN", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(processorStatus.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(processorStatus.getOutputBytes(), "SIZE_CONTENT_OUTPUT_TOTAL", instanceId, "Processor", procComponentName, procComponentId, parentId2, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(processorStatus.getInputBytes(), "SIZE_CONTENT_INPUT_TOTAL", instanceId, "Processor", procComponentName, procComponentId, parentId2, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(processorStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", instanceId, "Processor", procComponentName, procComponentId, parentId2, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(processorStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", instanceId, "Processor", procComponentName, procComponentId, parentId2, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(processorStatus.getAverageLineageDuration(), "AVERAGE_LINEAGE_DURATION", instanceId, "Processor", procComponentName, procComponentId, parentId2, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(status.getActiveThreadCount() == null ? 0.0 : (double)status.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", instanceId, "Processor", procComponentName, procComponentId, parentId2);
                nifiMetricsRegistry.setDataPoint(status.getTerminatedThreadCount() == null ? 0.0 : (double)status.getTerminatedThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_TERMINATED", instanceId, "Processor", procComponentName, procComponentId, parentId2);
            }
            for (ConnectionStatus connectionStatus : status.getConnectionStatus()) {
                String connComponentId = StringUtils.isEmpty((String)connectionStatus.getId()) ? DEFAULT_LABEL_STRING : connectionStatus.getId();
                String connComponentName = StringUtils.isEmpty((String)connectionStatus.getName()) ? DEFAULT_LABEL_STRING : connectionStatus.getName();
                String sourceId = StringUtils.isEmpty((String)connectionStatus.getSourceId()) ? DEFAULT_LABEL_STRING : connectionStatus.getSourceId();
                String sourceName = StringUtils.isEmpty((String)connectionStatus.getSourceName()) ? DEFAULT_LABEL_STRING : connectionStatus.getSourceName();
                String destinationId = StringUtils.isEmpty((String)connectionStatus.getDestinationId()) ? DEFAULT_LABEL_STRING : connectionStatus.getDestinationId();
                String destinationName = StringUtils.isEmpty((String)connectionStatus.getDestinationName()) ? DEFAULT_LABEL_STRING : connectionStatus.getDestinationName();
                String parentId3 = StringUtils.isEmpty((String)connectionStatus.getGroupId()) ? DEFAULT_LABEL_STRING : connectionStatus.getGroupId();
                String connComponentType = "Connection";
                nifiMetricsRegistry.setDataPoint(connectionStatus.getOutputBytes(), "SIZE_CONTENT_OUTPUT_TOTAL", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(connectionStatus.getInputBytes(), "SIZE_CONTENT_INPUT_TOTAL", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(connectionStatus.getQueuedBytes(), "SIZE_CONTENT_QUEUED_TOTAL", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(connectionStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(connectionStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(connectionStatus.getQueuedCount(), "AMOUNT_ITEMS_QUEUED", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(connectionStatus.getBackPressureBytesThreshold(), "BACKPRESSURE_BYTES_THRESHOLD", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(connectionStatus.getBackPressureObjectThreshold(), "BACKPRESSURE_OBJECT_THRESHOLD", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(PrometheusMetricsUtil.getUtilization(connectionStatus.getQueuedBytes(), connectionStatus.getBackPressureBytesThreshold()), "PERCENT_USED_BYTES", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                nifiMetricsRegistry.setDataPoint(PrometheusMetricsUtil.getUtilization(connectionStatus.getQueuedCount(), connectionStatus.getBackPressureObjectThreshold()), "PERCENT_USED_COUNT", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
                boolean isBackpressureEnabled = connectionStatus.getBackPressureObjectThreshold() > 0L && connectionStatus.getBackPressureObjectThreshold() <= (long)connectionStatus.getQueuedCount() || connectionStatus.getBackPressureBytesThreshold() > 0L && connectionStatus.getBackPressureBytesThreshold() <= connectionStatus.getQueuedBytes();
                nifiMetricsRegistry.setDataPoint(isBackpressureEnabled ? 1.0 : 0.0, "IS_BACKPRESSURE_ENABLED", instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName);
            }
            for (PortStatus portStatus : status.getInputPortStatus()) {
                portComponentId = StringUtils.isEmpty((String)portStatus.getId()) ? DEFAULT_LABEL_STRING : portStatus.getId();
                portComponentName = StringUtils.isEmpty((String)portStatus.getName()) ? DEFAULT_LABEL_STRING : portStatus.getId();
                parentId = StringUtils.isEmpty((String)portStatus.getGroupId()) ? DEFAULT_LABEL_STRING : portStatus.getId();
                portComponentType = "InputPort";
                nifiMetricsRegistry.setDataPoint(portStatus.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", instanceId, "InputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", instanceId, "InputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getBytesSent(), "AMOUNT_BYTES_SENT", instanceId, "InputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getInputBytes(), "AMOUNT_BYTES_READ", instanceId, "InputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getOutputBytes(), "AMOUNT_BYTES_WRITTEN", instanceId, "InputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", instanceId, "InputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", instanceId, "InputPort", portComponentName, portComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(portStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", instanceId, "InputPort", portComponentName, portComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                isTransmitting = portStatus.isTransmitting();
                nifiMetricsRegistry.setDataPoint(isTransmitting == null ? 0.0 : (double)(isTransmitting != false ? 1 : 0), "IS_TRANSMITTING", instanceId, "InputPort", portComponentName, portComponentId, parentId, portStatus.getRunStatus().name());
                nifiMetricsRegistry.setDataPoint(portStatus.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", instanceId, "InputPort", portComponentName, portComponentId, parentId);
            }
            for (PortStatus portStatus : status.getOutputPortStatus()) {
                portComponentId = StringUtils.isEmpty((String)portStatus.getId()) ? DEFAULT_LABEL_STRING : portStatus.getId();
                portComponentName = StringUtils.isEmpty((String)portStatus.getName()) ? DEFAULT_LABEL_STRING : portStatus.getName();
                parentId = StringUtils.isEmpty((String)portStatus.getGroupId()) ? DEFAULT_LABEL_STRING : portStatus.getGroupId();
                portComponentType = "OutputPort";
                nifiMetricsRegistry.setDataPoint(portStatus.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", instanceId, "OutputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", instanceId, "OutputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getBytesSent(), "AMOUNT_BYTES_SENT", instanceId, "OutputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getInputBytes(), "AMOUNT_BYTES_READ", instanceId, "OutputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getOutputBytes(), "AMOUNT_BYTES_WRITTEN", instanceId, "OutputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", instanceId, "OutputPort", portComponentName, portComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(portStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", instanceId, "OutputPort", portComponentName, portComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(portStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", instanceId, "OutputPort", portComponentName, portComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                isTransmitting = portStatus.isTransmitting();
                nifiMetricsRegistry.setDataPoint(isTransmitting == null ? 0.0 : (double)(isTransmitting != false ? 1 : 0), "IS_TRANSMITTING", instanceId, "OutputPort", portComponentName, portComponentId, parentId, portStatus.getRunStatus().name());
                nifiMetricsRegistry.setDataPoint(portStatus.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", instanceId, "OutputPort", portComponentName, portComponentId, parentId);
            }
            for (RemoteProcessGroupStatus remoteProcessGroupStatus : status.getRemoteProcessGroupStatus()) {
                String rpgComponentId = StringUtils.isEmpty((String)remoteProcessGroupStatus.getId()) ? DEFAULT_LABEL_STRING : remoteProcessGroupStatus.getId();
                String rpgComponentName = StringUtils.isEmpty((String)remoteProcessGroupStatus.getName()) ? DEFAULT_LABEL_STRING : remoteProcessGroupStatus.getName();
                parentId = StringUtils.isEmpty((String)remoteProcessGroupStatus.getGroupId()) ? DEFAULT_LABEL_STRING : remoteProcessGroupStatus.getGroupId();
                String rpgComponentType = "RemoteProcessGroup";
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getSentContentSize().longValue(), "AMOUNT_BYTES_WRITTEN", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getReceivedContentSize().longValue(), "AMOUNT_BYTES_RECEIVED", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId);
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getSentCount().intValue(), "AMOUNT_ITEMS_OUTPUT", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getReceivedCount().intValue(), "AMOUNT_ITEMS_INPUT", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getActiveRemotePortCount().intValue(), "ACTIVE_REMOTE_PORT_COUNT", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getInactiveRemotePortCount().intValue(), "INACTIVE_REMOTE_PORT_COUNT", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getAverageLineageDuration(), "AVERAGE_LINEAGE_DURATION", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
                nifiMetricsRegistry.setDataPoint(TransmissionStatus.Transmitting.equals((Object)remoteProcessGroupStatus.getTransmissionStatus()) ? 1.0 : 0.0, "IS_TRANSMITTING", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, remoteProcessGroupStatus.getTransmissionStatus().name());
                nifiMetricsRegistry.setDataPoint(remoteProcessGroupStatus.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId);
            }
        }
        return nifiMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createJvmMetrics(JvmMetricsRegistry jvmMetricsRegistry, JvmMetrics jvmMetrics, String instId) {
        String instanceId = StringUtils.isEmpty((String)instId) ? DEFAULT_LABEL_STRING : instId;
        jvmMetricsRegistry.setDataPoint(jvmMetrics.heapUsed(DataUnit.B), "JVM_HEAP_USED", instanceId);
        jvmMetricsRegistry.setDataPoint(jvmMetrics.heapUsage(), "JVM_HEAP_USAGE", instanceId);
        jvmMetricsRegistry.setDataPoint(jvmMetrics.nonHeapUsage(), "JVM_HEAP_NON_USAGE", instanceId);
        jvmMetricsRegistry.setDataPoint(jvmMetrics.threadCount(), "JVM_THREAD_COUNT", instanceId);
        jvmMetricsRegistry.setDataPoint(jvmMetrics.daemonThreadCount(), "JVM_DAEMON_THREAD_COUNT", instanceId);
        jvmMetricsRegistry.setDataPoint(jvmMetrics.uptime(), "JVM_UPTIME", instanceId);
        jvmMetricsRegistry.setDataPoint(jvmMetrics.fileDescriptorUsage(), "JVM_FILE_DESCRIPTOR_USAGE", instanceId);
        jvmMetrics.garbageCollectors().forEach((name, stat) -> {
            jvmMetricsRegistry.setDataPoint(stat.getRuns(), "JVM_GC_RUNS", instanceId, (String)name);
            jvmMetricsRegistry.setDataPoint(stat.getTime(TimeUnit.MILLISECONDS), "JVM_GC_TIME", instanceId, (String)name);
        });
        return jvmMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createConnectionStatusAnalyticsMetrics(ConnectionAnalyticsMetricsRegistry connectionAnalyticsMetricsRegistry, StatusAnalytics statusAnalytics, String instId, String connComponentType, String connName, String connId, String pgId, String srcId, String srcName, String destId, String destName) {
        if (statusAnalytics != null) {
            String instanceId = StringUtils.isEmpty((String)instId) ? DEFAULT_LABEL_STRING : instId;
            String connComponentId = StringUtils.isEmpty((String)connId) ? DEFAULT_LABEL_STRING : connId;
            String connComponentName = StringUtils.isEmpty((String)connName) ? DEFAULT_LABEL_STRING : connName;
            String sourceId = StringUtils.isEmpty((String)srcId) ? DEFAULT_LABEL_STRING : srcId;
            String sourceName = StringUtils.isEmpty((String)srcName) ? DEFAULT_LABEL_STRING : srcName;
            String destinationId = StringUtils.isEmpty((String)destId) ? DEFAULT_LABEL_STRING : destId;
            String destinationName = StringUtils.isEmpty((String)destName) ? DEFAULT_LABEL_STRING : destName;
            String parentId = StringUtils.isEmpty((String)pgId) ? DEFAULT_LABEL_STRING : pgId;
            Map predictions = statusAnalytics.getPredictions();
            connectionAnalyticsMetricsRegistry.setDataPoint(((Long)predictions.get("timeToBytesBackpressureMillis")).longValue(), "TIME_TO_BYTES_BACKPRESSURE_PREDICTION", instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName);
            connectionAnalyticsMetricsRegistry.setDataPoint(((Long)predictions.get("timeToCountBackpressureMillis")).longValue(), "TIME_TO_COUNT_BACKPRESSURE_PREDICTION", instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName);
            connectionAnalyticsMetricsRegistry.setDataPoint(((Long)predictions.get("nextIntervalBytes")).longValue(), "BYTES_AT_NEXT_INTERVAL_PREDICTION", instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName);
            connectionAnalyticsMetricsRegistry.setDataPoint(((Long)predictions.get("nextIntervalCount")).longValue(), "COUNT_AT_NEXT_INTERVAL_PREDICTION", instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName);
        }
        return connectionAnalyticsMetricsRegistry.getRegistry();
    }

    private static double getUtilization(double used, double total) {
        return used / total * 100.0;
    }

    public static CollectorRegistry createBulletinMetrics(BulletinMetricsRegistry bulletinMetricsRegistry, String instId, String compType, String compId, String pgId, String nodeAddr, String cat, String srcName, String srcId, String lvl) {
        String instanceId = StringUtils.isEmpty((String)instId) ? DEFAULT_LABEL_STRING : instId;
        String componentType = StringUtils.isEmpty((String)compType) ? DEFAULT_LABEL_STRING : compType;
        String componentId = StringUtils.isEmpty((String)compId) ? DEFAULT_LABEL_STRING : compId;
        String sourceId = StringUtils.isEmpty((String)srcId) ? DEFAULT_LABEL_STRING : srcId;
        String sourceName = StringUtils.isEmpty((String)srcName) ? DEFAULT_LABEL_STRING : srcName;
        String nodeAddress = StringUtils.isEmpty((String)nodeAddr) ? DEFAULT_LABEL_STRING : nodeAddr;
        String category = StringUtils.isEmpty((String)cat) ? DEFAULT_LABEL_STRING : cat;
        String parentId = StringUtils.isEmpty((String)pgId) ? DEFAULT_LABEL_STRING : pgId;
        String level = StringUtils.isEmpty((String)lvl) ? DEFAULT_LABEL_STRING : lvl;
        bulletinMetricsRegistry.setDataPoint(1.0, "BULLETIN", instanceId, componentType, componentId, parentId, nodeAddress, category, sourceName, sourceId, level);
        return bulletinMetricsRegistry.getRegistry();
    }

    public static void aggregatePercentUsed(ProcessGroupStatus status, Map<String, Double> aggregatedMetrics) {
        status.getProcessGroupStatus().forEach(childGroupStatus -> PrometheusMetricsUtil.aggregatePercentUsed(childGroupStatus, aggregatedMetrics));
        for (ConnectionStatus connectionStatus : status.getConnectionStatus()) {
            double percentUsedBytes = PrometheusMetricsUtil.getUtilization(connectionStatus.getQueuedBytes(), connectionStatus.getBackPressureBytesThreshold());
            double percentUsedCount = PrometheusMetricsUtil.getUtilization(connectionStatus.getQueuedCount(), connectionStatus.getBackPressureObjectThreshold());
            PrometheusMetricsUtil.determineMaxValueForPercentUsed(aggregatedMetrics, "nifi_percent_used_bytes", percentUsedBytes);
            PrometheusMetricsUtil.determineMaxValueForPercentUsed(aggregatedMetrics, "nifi_percent_used_count", percentUsedCount);
            PrometheusMetricsUtil.setBackpressure(aggregatedMetrics, percentUsedBytes, "bytesAtBackpressure");
            PrometheusMetricsUtil.setBackpressure(aggregatedMetrics, percentUsedCount, "countAtBackpressure");
        }
    }

    public static void aggregateConnectionPredictionMetrics(Map<String, Double> aggregatedMetrics, Map<String, Long> predictions) {
        PrometheusMetricsUtil.determineMinValueForPredictions(aggregatedMetrics, "nifi_time_to_bytes_backpressure_prediction", predictions.get("timeToBytesBackpressureMillis").longValue(), "bytesAtBackpressure");
        PrometheusMetricsUtil.determineMinValueForPredictions(aggregatedMetrics, "nifi_time_to_count_backpressure_prediction", predictions.get("timeToCountBackpressureMillis").longValue(), "countAtBackpressure");
    }

    private static void setBackpressure(Map<String, Double> aggregatedMetrics, double percentUsed, String atBackpressureKey) {
        if (percentUsed >= 100.0) {
            aggregatedMetrics.put(atBackpressureKey, 1.0);
        } else if (!aggregatedMetrics.containsKey(atBackpressureKey)) {
            aggregatedMetrics.put(atBackpressureKey, 0.0);
        }
    }

    private static void determineMinValueForPredictions(Map<String, Double> aggregatedMetrics, String metricFamilySamplesName, double metricSampleValue, String atBackpressureKey) {
        Double currentValue = aggregatedMetrics.get(metricFamilySamplesName);
        if (aggregatedMetrics.get(atBackpressureKey) != null && aggregatedMetrics.get(atBackpressureKey) == 1.0) {
            aggregatedMetrics.put(metricFamilySamplesName, 0.0);
        } else if (currentValue == null) {
            aggregatedMetrics.put(metricFamilySamplesName, metricSampleValue);
        } else if (metricSampleValue > -1.0) {
            if (currentValue == -1.0) {
                aggregatedMetrics.put(metricFamilySamplesName, metricSampleValue);
            } else {
                aggregatedMetrics.put(metricFamilySamplesName, Math.min(metricSampleValue, currentValue));
            }
        }
    }

    private static void determineMaxValueForPercentUsed(Map<String, Double> aggregatedMetrics, String metricFamilySamplesName, double metricSampleValue) {
        Double currentValue = aggregatedMetrics.get(metricFamilySamplesName);
        if (currentValue == null) {
            currentValue = 0.0;
        }
        aggregatedMetrics.put(metricFamilySamplesName, Math.max(metricSampleValue, currentValue));
    }

    public static CollectorRegistry createAggregatedConnectionStatusAnalyticsMetrics(ConnectionAnalyticsMetricsRegistry connectionAnalyticsMetricsRegistry, Map<String, Double> aggregatedMetrics, String instId, String compType, String compName, String compId) {
        String instanceId = StringUtils.isEmpty((String)instId) ? DEFAULT_LABEL_STRING : instId;
        String componentType = StringUtils.isEmpty((String)compType) ? DEFAULT_LABEL_STRING : compType;
        String componentName = StringUtils.isEmpty((String)compName) ? DEFAULT_LABEL_STRING : compName;
        String componentId = StringUtils.isEmpty((String)compId) ? DEFAULT_LABEL_STRING : compId;
        Double bytesValue = aggregatedMetrics.get("nifi_time_to_bytes_backpressure_prediction");
        Double countsValue = aggregatedMetrics.get("nifi_time_to_count_backpressure_prediction");
        double bytesBackpressure = bytesValue == null ? -1.0 : bytesValue;
        double countsBackpressure = countsValue == null ? -1.0 : countsValue;
        connectionAnalyticsMetricsRegistry.setDataPoint(bytesBackpressure, "TIME_TO_BYTES_BACKPRESSURE_PREDICTION", instanceId, componentType, componentName, componentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        connectionAnalyticsMetricsRegistry.setDataPoint(countsBackpressure, "TIME_TO_COUNT_BACKPRESSURE_PREDICTION", instanceId, componentType, componentName, componentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        return connectionAnalyticsMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createAggregatedNifiMetrics(NiFiMetricsRegistry niFiMetricsRegistry, Map<String, Double> aggregatedMetrics, String instId, String compType, String compName, String compId) {
        String instanceId = StringUtils.isEmpty((String)instId) ? DEFAULT_LABEL_STRING : instId;
        String componentType = StringUtils.isEmpty((String)compType) ? DEFAULT_LABEL_STRING : compType;
        String componentName = StringUtils.isEmpty((String)compName) ? DEFAULT_LABEL_STRING : compName;
        String componentId = StringUtils.isEmpty((String)compId) ? DEFAULT_LABEL_STRING : compId;
        Double bytesValue = aggregatedMetrics.get("nifi_percent_used_bytes");
        Double countsValue = aggregatedMetrics.get("nifi_percent_used_count");
        double percentBytes = bytesValue == null ? 0.0 : bytesValue;
        double percentCount = countsValue == null ? 0.0 : countsValue;
        niFiMetricsRegistry.setDataPoint(percentBytes, "PERCENT_USED_BYTES", instanceId, componentType, componentName, componentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        niFiMetricsRegistry.setDataPoint(percentCount, "PERCENT_USED_COUNT", instanceId, componentType, componentName, componentId, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING, DEFAULT_LABEL_STRING);
        return niFiMetricsRegistry.getRegistry();
    }
}

