/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.ssl.SSLContextService;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class PrometheusServer {
    private static ComponentLog logger;
    private final Server server;
    private final ServletContextHandler handler;
    private ReportingContext context;
    private List<Function<ReportingContext, CollectorRegistry>> metricsCollectors;

    public PrometheusServer(InetSocketAddress addr, ComponentLog logger) throws Exception {
        PrometheusServer.logger = logger;
        this.metricsCollectors = Collections.emptyList();
        this.server = new Server(addr);
        this.handler = new ServletContextHandler("/metrics");
        this.handler.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/");
        this.server.setHandler((Handler)this.handler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            logger.debug("PrometheusServer: Couldn't start Jetty server, stopping manually", (Throwable)e);
            this.server.stop();
            throw e;
        }
    }

    public PrometheusServer(int addr, SSLContextService sslContextService, ComponentLog logger, boolean needClientAuth, boolean wantClientAuth) throws Exception {
        PrometheusServer.logger = logger;
        this.server = new Server();
        this.handler = new ServletContextHandler("/metrics");
        this.handler.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/");
        this.server.setHandler((Handler)this.handler);
        SslContextFactory.Server sslFactory = this.createSslFactory(sslContextService, needClientAuth, wantClientAuth);
        HttpConfiguration httpsConfiguration = new HttpConfiguration();
        httpsConfiguration.setSecureScheme("https");
        httpsConfiguration.setSecurePort(addr);
        httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector https = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslFactory, "http/1.1"), new HttpConnectionFactory(httpsConfiguration)});
        https.setPort(addr);
        this.server.setConnectors(new Connector[]{https});
        try {
            this.server.start();
        }
        catch (Exception e) {
            logger.debug("PrometheusServer: Couldn't start Jetty server, stopping manually", (Throwable)e);
            this.server.stop();
            throw e;
        }
    }

    private SslContextFactory.Server createSslFactory(SSLContextService sslService, boolean needClientAuth, boolean wantClientAuth) {
        SslContextFactory.Server sslFactory = new SslContextFactory.Server();
        sslFactory.setNeedClientAuth(needClientAuth);
        sslFactory.setWantClientAuth(wantClientAuth);
        SSLContext sslContext = sslService.createContext();
        sslFactory.setSslContext(sslContext);
        return sslFactory;
    }

    public Server getServer() {
        return this.server;
    }

    public ReportingContext getReportingContext() {
        return this.context;
    }

    public void setReportingContext(ReportingContext rc) {
        this.context = rc;
    }

    public List<Function<ReportingContext, CollectorRegistry>> getMetricsCollectors() {
        return this.metricsCollectors;
    }

    public void setMetricsCollectors(List<Function<ReportingContext, CollectorRegistry>> metricsCollectors) {
        this.metricsCollectors = metricsCollectors;
    }

    class MetricsServlet
    extends HttpServlet {
        MetricsServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            logger.debug("PrometheusServer doGet() called");
            ServletOutputStream response = resp.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response, StandardCharsets.UTF_8);
            for (Function<ReportingContext, CollectorRegistry> mc : PrometheusServer.this.metricsCollectors) {
                CollectorRegistry collectorRegistry = mc.apply(PrometheusServer.this.getReportingContext());
                TextFormat.write004((Writer)osw, (Enumeration)collectorRegistry.metricFamilySamples());
            }
            resp.setHeader("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
            resp.setStatus(200);
            osw.flush();
            osw.close();
            response.flush();
            response.close();
            resp.flushBuffer();
        }
    }
}

