/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.prometheus.util.PrometheusMetricsUtil;
import org.apache.nifi.record.sink.RecordSinkService;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.prometheus.PrometheusServer;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.eclipse.jetty.server.Server;

@Tags(value={"record", "send", "write", "prometheus"})
@CapabilityDescription(value="Specifies a Record Sink Service that exposes data points to a Prometheus scraping service. Numeric fields are exposed as Gauges, String fields are the label values for the gauges, and all other fields are ignored.")
@DeprecationNotice(reason="This component is deprecated and will be removed in NiFi 2.x.")
public class PrometheusRecordSink
extends AbstractControllerService
implements RecordSinkService {
    private volatile PrometheusServer prometheusServer;
    private volatile RecordSchema recordSchema;
    private volatile String[] labelNames;
    private volatile Map<String, Gauge> gauges;
    private static final CollectorRegistry RECORD_REGISTRY = new CollectorRegistry();
    public static final PropertyDescriptor SSL_CONTEXT = new PropertyDescriptor.Builder().name("prometheus-reporting-task-ssl-context").displayName("SSL Context Service").description("The SSL Context Service to use in order to secure the server. If specified, the server willaccept only HTTPS requests; otherwise, the server will accept only HTTP requests").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    private static final List<PropertyDescriptor> properties;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @OnEnabled
    public void onScheduled(ConfigurationContext context) {
        RECORD_REGISTRY.clear();
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        String metricsEndpointPort = context.getProperty(PrometheusMetricsUtil.METRICS_ENDPOINT_PORT).evaluateAttributeExpressions().getValue();
        try {
            ArrayList<Function<ReportingContext, CollectorRegistry>> metricsCollectors = new ArrayList<Function<ReportingContext, CollectorRegistry>>();
            if (sslContextService == null) {
                this.prometheusServer = new PrometheusServer(new InetSocketAddress(Integer.parseInt(metricsEndpointPort)), this.getLogger());
            } else {
                boolean want;
                boolean need;
                String clientAuthValue = context.getProperty(PrometheusMetricsUtil.CLIENT_AUTH).getValue();
                if (PrometheusMetricsUtil.CLIENT_NEED.getValue().equals(clientAuthValue)) {
                    need = true;
                    want = false;
                } else if (PrometheusMetricsUtil.CLIENT_WANT.getValue().equals(clientAuthValue)) {
                    need = false;
                    want = true;
                } else {
                    need = false;
                    want = false;
                }
                this.prometheusServer = new PrometheusServer(Integer.parseInt(metricsEndpointPort), sslContextService, this.getLogger(), need, want);
            }
            Function<ReportingContext, CollectorRegistry> nifiMetrics = reportingContext -> RECORD_REGISTRY;
            metricsCollectors.add(nifiMetrics);
            this.prometheusServer.setMetricsCollectors(metricsCollectors);
            this.getLogger().info("Started Jetty server");
        }
        catch (Exception e) {
            throw new ProcessException("Failed to start Jetty server", (Throwable)e);
        }
    }

    public WriteResult sendData(RecordSet recordSet, Map<String, String> attributes, boolean sendZeroResults) throws IOException {
        Record r;
        WriteResult writeResult = null;
        if (this.recordSchema == null) {
            this.recordSchema = recordSet.getSchema();
            RECORD_REGISTRY.clear();
            this.labelNames = (String[])this.recordSchema.getFields().stream().filter(f -> this.isLabel(f.getDataType().getFieldType())).map(RecordField::getFieldName).toArray(String[]::new);
            this.gauges = new HashMap<String, Gauge>();
            this.recordSchema.getFields().stream().filter(field -> this.isNumeric(field.getDataType().getFieldType())).forEach(field -> this.gauges.put(field.getFieldName(), (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(field.getFieldName())).help("Metric for " + field.getFieldName())).labelNames(this.labelNames)).register(RECORD_REGISTRY)));
        }
        int recordCount = 0;
        while ((r = recordSet.next()) != null) {
            Record record = r;
            String[] labelValues = (String[])Arrays.stream(this.labelNames).map(labelName -> {
                String value = record.getAsString(labelName);
                return value != null ? value : "";
            }).toArray(String[]::new);
            this.gauges.forEach((name, gauge) -> {
                Optional dataType = record.getSchema().getDataType(name);
                if (dataType.isPresent()) {
                    RecordFieldType recordFieldType = ((DataType)dataType.get()).getFieldType();
                    double value = RecordFieldType.BOOLEAN.equals((Object)recordFieldType) ? (record.getAsBoolean(name) != false ? 1.0 : 0.0) : record.getAsDouble(name);
                    ((Gauge.Child)gauge.labels(labelValues)).set(value);
                }
            });
            ++recordCount;
        }
        attributes.put("record.count", Integer.toString(recordCount));
        writeResult = WriteResult.of((int)recordCount, attributes);
        return writeResult;
    }

    @OnDisabled
    public void onStopped() throws Exception {
        Server server;
        if (this.prometheusServer != null && (server = this.prometheusServer.getServer()) != null) {
            server.stop();
        }
        this.recordSchema = null;
    }

    @OnShutdown
    public void onShutDown() throws Exception {
        Server server;
        if (this.prometheusServer != null && (server = this.prometheusServer.getServer()) != null) {
            server.stop();
        }
        this.recordSchema = null;
    }

    public void reset() {
        this.recordSchema = null;
    }

    private boolean isNumeric(RecordFieldType dataType) {
        return RecordFieldType.INT.equals((Object)dataType) || RecordFieldType.SHORT.equals((Object)dataType) || RecordFieldType.LONG.equals((Object)dataType) || RecordFieldType.BIGINT.equals((Object)dataType) || RecordFieldType.FLOAT.equals((Object)dataType) || RecordFieldType.DOUBLE.equals((Object)dataType) || RecordFieldType.DECIMAL.equals((Object)dataType) || RecordFieldType.BOOLEAN.equals((Object)dataType);
    }

    private boolean isLabel(RecordFieldType dataType) {
        return RecordFieldType.STRING.equals((Object)dataType) || RecordFieldType.CHAR.equals((Object)dataType);
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(PrometheusMetricsUtil.METRICS_ENDPOINT_PORT);
        props.add(PrometheusMetricsUtil.INSTANCE_ID);
        props.add(SSL_CONTEXT);
        props.add(PrometheusMetricsUtil.CLIENT_AUTH);
        properties = Collections.unmodifiableList(props);
    }
}

