/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.excel.CellFieldTypeReader;
import org.apache.nifi.schema.inference.FieldTypeInference;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

class StandardCellFieldTypeReader
implements CellFieldTypeReader {
    private final TimeValueInference timeValueInference;

    StandardCellFieldTypeReader(TimeValueInference timeValueInference) {
        this.timeValueInference = Objects.requireNonNull(timeValueInference, "Time Value Inference required");
    }

    @Override
    public void inferCellFieldType(Cell cell, String fieldName, Map<String, FieldTypeInference> fieldTypes) {
        Objects.requireNonNull(fieldName, "Field Name required");
        Objects.requireNonNull(fieldTypes, "Field Types required");
        FieldTypeInference fieldTypeInference = fieldTypes.computeIfAbsent(fieldName, key -> new FieldTypeInference());
        DataType dataType = this.getCellDataType(cell);
        fieldTypeInference.addPossibleDataType(dataType);
    }

    @Override
    public DataType getCellDataType(Cell cell) {
        Object dataType;
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (CellType.NUMERIC == cellType) {
            double numericCellValue = cell.getNumericCellValue();
            dataType = DateUtil.isCellDateFormatted((Cell)cell) ? this.getDateTimeDataType(numericCellValue) : (this.isWholeNumber(numericCellValue) ? RecordFieldType.LONG.getDataType() : RecordFieldType.DOUBLE.getDataType());
        } else if (CellType.BOOLEAN == cellType) {
            dataType = RecordFieldType.BOOLEAN.getDataType();
        } else if (CellType.STRING == cellType) {
            String cellValue = cell.getStringCellValue();
            Optional timeDataType = this.timeValueInference.getDataType(cellValue);
            dataType = timeDataType.orElse(RecordFieldType.STRING.getDataType());
        } else {
            dataType = CellType.FORMULA == cellType ? this.getFormulaResultDataType(cell) : null;
        }
        return dataType;
    }

    private DataType getDateTimeDataType(double numericCellValue) {
        DataType dataType = this.isWholeNumber(numericCellValue) ? RecordFieldType.DATE.getDataType() : (numericCellValue < 1.0 ? RecordFieldType.TIME.getDataType() : RecordFieldType.TIMESTAMP.getDataType());
        return dataType;
    }

    private DataType getFormulaResultDataType(Cell cell) {
        DataType dataType;
        CellType formulaResultType = cell.getCachedFormulaResultType();
        if (CellType.BOOLEAN == formulaResultType) {
            dataType = RecordFieldType.BOOLEAN.getDataType();
        } else if (CellType.STRING == formulaResultType) {
            dataType = RecordFieldType.STRING.getDataType();
        } else if (CellType.NUMERIC == formulaResultType) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                double numericCellValue = cell.getNumericCellValue();
                dataType = this.getDateTimeDataType(numericCellValue);
            } else {
                dataType = RecordFieldType.DOUBLE.getDataType();
            }
        } else {
            dataType = null;
        }
        return dataType;
    }

    private boolean isWholeNumber(double numericCellValue) {
        long roundedCellValue = (long)numericCellValue;
        return (double)roundedCellValue == numericCellValue;
    }
}

